#! /router/bin/python

import os
import sys
import time

root_dir = '/var/log'

verbose = 0

confd_cap = 5*1024*1024

def clean_file_with_pattern(pattern):
    a_list = []
    total = 0
    for item in os.listdir(root_dir):
        if verbose == 1:
            print ("file name is:", item)

        for val in pattern:

            if verbose == 1:
                print ("pattern element is :", val)

            if val in item:

                item_name_and_path = os.path.join(root_dir, item)

                if verbose == 1:
                    print ("file name and path is: ", item_name_and_path)

                if os.path.isfile(item_name_and_path):
                    stat = os.stat(item_name_and_path)
                    a_list.append([int(stat.st_mtime), int(stat.st_size), item_name_and_path])

                    total = total + stat.st_size



    # sort by st_mtime
    if total >= confd_cap:

        if verbose == 1:
            print("list before sorting is:", a_list)

        a_list.sort(key=lambda x: x[0], reverse = True)

        if verbose == 1:
            print("list after sorting is:", a_list)

        total_again = 0

        # delete oldest first
        for i, val in enumerate(a_list):
            total_again = total_again + val[1]
            if total_again >= confd_cap:
                try:
                    if verbose == 1:
                        print("Truncating file :", total_again, i, val[2])

                    target = open(val[2],'w')
                    target.truncate(0)
                    target.write("truncated by file_cleanup.py")
                except:
                    pass

if __name__ == "__main__":
    clean_file_with_pattern(["user.log", "auth.log", "syslog", "cmpp.log", "confd_audit.log", "confd_developer.log","cm.log", "confd_error.log", "access.log", "postinstall.log", "relay.local.log", "confd_daemon.log", "ntp.log", "messages"])
