#!/bin/bash
# Added this script for CSCvm80553 (wd_memmon crashed on calvados)

# Script to drop cache. Spawned as a new process for 20 seconds,
# from file - calvados/shared_pkg/common/rm/src/wd_memmon.c
# from function - wd_cl_mem_tot()

touch /tmp/log_wd_memmon_drop_cache.txt

# If log file size exceeds 1MB, clear its content
file_size=$(stat -c %s /tmp/log_wd_memmon_drop_cache.txt)
max_size=1000000
echo "file_size = $file_size" >> /tmp/log_wd_memmon_drop_cache.txt

if [ $file_size -ge $max_size ]
then
    > /tmp/log_wd_memmon_drop_cache.txt
fi


# Check if the process is already running
if pidof -x "`basename $0`" -o $$ >/dev/null; 
then
    echo "Process '`basename $0`' is already running" >> /tmp/log_wd_memmon_drop_cache.txt
else
    echo "Before drop_caches : $(date)" >> /tmp/log_wd_memmon_drop_cache.txt

    echo 3 > /proc/sys/vm/drop_caches

    echo "After drop_caches : $(date)" >> /tmp/log_wd_memmon_drop_cache.txt
fi

