#!/bin/bash

#-----------------------------------------------------------------------------
#
# Copyright (c) 2012-2014, 2016 by Cisco Systems, Inc.
# All rights reserved.
#
#-----------------------------------------------------------------------------

source /opt/cisco/calvados/script/show_tech_main_fragment

function ExecuteCli {
    echo "====================================================================="
    echo "$@"
    ${EXEC_CONFD_CMD} <<EOF
$@ | nomore
EOF
    echo " "
}

function ExecuteHiddenCli {
    echo "====================================================================="
    echo "$@"
    ${EXEC_CONFD_CMD} <<EOF
unhide debug
secret
$@ | nomore
EOF
    echo " "
}

EXEC_CONFD_CMD="confd_cli"

display() {

    print_main_heading "show tech-support fpd"

    # fpd ctrace
    echo "Extracting fpdmgr ctrace logs:"
    /opt/cisco/calvados/bin/ctracedec -Agkstpd fpdmgr
    echo " "
    echo "Extracting fpdserv ctrace logs:"
    /opt/cisco/calvados/bin/ctracedec -Agkstpd fpdserv
    echo " "

    # other CLI
    echo "Extracting ccc_driver ctrace logs:"
    /opt/cisco/calvados/bin/ctracedec -Agkstpd ccc_driver
    echo " "
    echo "Extracting bios_fpd ctrace logs:"
    /opt/cisco/calvados/bin/ctracedec -Agkstpd bios_fpd
    echo " "
    echo "Extracting sata_fpd ctrace logs:"
    /opt/cisco/calvados/bin/ctracedec -Agkstpd sata_fpd
    echo " "

    # shelfmgr CLI
    ExecuteCli "show platform"
    ExecuteCli "show platform detail"
    ExecuteCli "show inventory all"
    ExecuteCli "show fpd package"
    ExecuteCli "show hw-module fpd"
    echo " "

    ExecuteCli "show diag detail"
    echo " "

    mkdir /misc/disk1/showtech-fpd-dumps
    # log messages
    cp /var/log/messages  /misc/disk1/showtech-fpd-dumps
    echo "Copied /var/log/messages to /misc/disk1/showtech-fpd-dumps"
    echo " "

    # inv dump
    /opt/cisco/calvados/bin/inv_dump_tool rack
    mv /var/log/inv_RACK*  /misc/disk1/showtech-fpd-dumps
    echo " "
    echo "inv_dump_tool log moved to /misc/disk1/showtech-fpd-dumps"
}

source /opt/cisco/calvados/script/show_tech_file_fragment

