#!/bin/bash
# Dump the golden version's for RP, LC , LC
# Copyright (c) 2015-2019 by cisco Systems, Inc. All rights reserved.
#

MAX_FC_SLOT=6
MAX_FC2S_SLOT=4
FPD_BIN=/opt/cisco/calvados/bin/fpd_spi_writer
RMON_BIN_LC=/opt/cisco/hostos/bin/rmon_spi_writer_lc
RMON_BIN_RP=/opt/cisco/hostos/bin/rmon_spi_writer_rp

function check_upgrade_progress()
{
    process_check=$(ps -aef)
    rmon_process_check_on_host=$(ssh my_host 'ps x |grep -v grep |grep -c "rmon_spi_writer"')
    if [[ $process_check == *"_spi_writer"* || $process_check == *"fpd_golden_lock"* || $rmon_process_check_on_host == 1 ]]; then
         printf "\n\t\tWARNING: upgrade in progress,\n\t\tPlease run after upgrade done...\n\n"
         exit
    fi
}


function get_board_type()
{
    if [[ -f /root/cmdline ]]; then
        PROC_CMDLINE=$(cat /root/cmdline)
    else
        PROC_CMDLINE=$(cat /proc/cmdline)
    fi

    for x in ${PROC_CMDLINE} ; do
        case "$x" in
            boardtype=*)
            BOARDTYPE="${x#boardtype=}"
            ;;
            cardtype=*)
            PD_CARDTYPE="${x#cardtype=}"
            ;;
            iputype=*)
            HW_CARDTYPE="${x#iputype=}"
            ;;
            chassis_type=*)
            CHASSISTYPE="${x#chassis_type=}"
            ;;
        esac
    done
}

function is_chassis_mtron()
{
    if [ "${CHASSISTYPE}" == "0xef02f8" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_chassis_sscream()
{
    if [ "${CHASSISTYPE}" == "0xef02f7" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_chassis_twood()
{
    if [ "${CHASSISTYPE}" == "0xef02f4" ]; then
        printf "true"
    else
        printf "false"
    fi
}


function is_chassis_swave()
{
    if [ "${CHASSISTYPE}" == "0xef02f5" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_azteca_mb_db_only()
{
    if [ "${PD_CARDTYPE}" == "0x3f0500" -o \
         "${PD_CARDTYPE}" == "0x3f050a" -o \
         "${PD_CARDTYPE}" == "0x3f0506" -o \
         "${PD_CARDTYPE}" == "0x3f0517" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rp3_rsp5()
{
    if [ "${PD_CARDTYPE}" == "0x100346" -o \
         "${PD_CARDTYPE}" == "0x100347" -o \
         "${PD_CARDTYPE}" == "0x100348" -o \
         "${PD_CARDTYPE}" == "0x100336" -o \
         "${PD_CARDTYPE}" == "0x100337" -o \
         "${PD_CARDTYPE}" == "0x100338" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rp3()
{
    if [ "${PD_CARDTYPE}" == "0x100346" -o \
         "${PD_CARDTYPE}" == "0x100347" -o \
         "${PD_CARDTYPE}" == "0x100348" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rp2()
{
    if [ "${PD_CARDTYPE}" == "0x100326" -o \
         "${PD_CARDTYPE}" == "0x100327" -o \
         "${PD_CARDTYPE}" == "0x100328" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rp2_rp3()
{
    rp2=$(is_board_rp2)
    rp3=$(is_board_rp3_rsp5)

    if [ "$rp2" == "true" -o \
         "$rp3" == "true" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rsp4s()
{
    if [ "${PD_CARDTYPE}" == "0x100320" -o \
         "${PD_CARDTYPE}" == "0x100321" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rsp4l()
{
    if [ "${PD_CARDTYPE}" == "0x10031a" -o \
         "${PD_CARDTYPE}" == "0x10031b" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rp_starlord()
{
    if [ "${PD_CARDTYPE}" == "0x101014" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_fc3()
{
    declare -i fc_base=0
    declare -i fc_idx=$1

    mtron=$(is_chassis_mtron)
    sscram=$(is_chassis_sscream)
    twood=$(is_chassis_twood)
    swave=$(is_chassis_swave)



    if [ "$mtron" == "true" ]; then
        fc_base=22
    elif [ "$twood" == "true" ]; then
        fc_base=06
    elif [ "$swave" == "true" ]; then
        fc_base=10
    else
        fc_base=12
    fi
 
    idx=`expr $fc_base + $fc_idx`

    FC_IDPROM="/opt/cisco/calvados/bin/canbus_client -s "$idx" -c 1"

    match=`$FC_IDPROM | grep -i A99-SFC3 | wc -l`

    if [ $match == "0" ]; then
        printf "false"
    else
	printf "true"
    fi
}

function usage()
{
   printf "\nfor RSP4/RP2/RSP4S : fpd_golden_info.sh <RP/rp>\n"
   printf "for LC : fpd_golden_info.sh <LC/lc> <type \n"
   printf "         0-Octane, 1-Skyhammer 2-Laserbeak 3-Sureshot\n"
   printf "         4-Azteca 5-Powerglide 6-Starlord\n"
   printf "for SFC2/SFC3            : fpd_golden_info.sh <FC/fc> <0...6>\n"
   printf "for SFC-S/T & SFC3-S/T   : fpd_golden_info.sh <FC/fc> <0...4>\n\n"
}

function rp_golden()
{
    bios_ready=$($RMON_BIN_RP -i)
    if [ "$bios_ready" != "1" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_rp -t 0 -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    optimus=$($FPD_BIN -s 7 -t 0 -v)
    omega=$($FPD_BIN -s 6 -t 0 -v)
    cha=$($FPD_BIN -s 8 -t 0 -v)
    alpha=$($FPD_BIN -s 5 -t 0 -v)
    rp2=$(is_board_rp2)

    printf "\n\t********************************************************\n"
    if [ "$rp2" == "true" ]; then
        printf "      \t*        RP2 Golden Version                            *\n"
    else
        printf "      \t*        RSP4 Golden Version                           *\n"
    fi
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    if [ "$rp2" == "true" ]; then
        printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "14.30" "$Rommon" "*"
    else
        printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "10.60" "$Rommon" "*"
    fi

    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.96" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.96" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "0.52" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Optimus-FPGA" "0.12" "$optimus" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Omega-FPGA" "0.11" "$omega" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Alpha-FPGA" "0.14" "$alpha" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Cha-FPGA" "0.8" "$cha" "*"
    printf "\t********************************************************\n"
}

function rp3_golden()
{
    rp3=$(is_board_rp3)
    gol_rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_rp -t 0 -v')
    pri_rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_rp -t 1 -v')

    gol_ipu=$($FPD_BIN -s 37 -t 0 -v)
    gol_beta=$($FPD_BIN -s 5 -t 0 -v)
    gol_orion=$($FPD_BIN -s 6 -t 0 -v)
    gol_zenith=$($FPD_BIN -s 7 -t 0 -v)
    gol_aldrin_0=$($FPD_BIN -s 13 -i 0 -t 0 -v)

    if [ "$rp3" == "true" ]; then
    	gol_aldrin_1=$($FPD_BIN -s 13 -i 1 -t 0 -v)
    	pri_aldrin_1=$($FPD_BIN -s 13 -i 1 -t 1 -v)
    fi

    pri_ipu=$($FPD_BIN -s 37 -t 1 -v)
    pri_beta=$($FPD_BIN -s 5 -t 1 -v)
    pri_orion=$($FPD_BIN -s 6 -t 1 -v)
    pri_zenith=$($FPD_BIN -s 7 -t 1 -v)
    pri_aldrin_0=$($FPD_BIN -s 13 -i 0 -t 1 -v)

    printf "\n\t********************************************************\n"
    if [ "$rp3" == "true" ]; then
        printf "      \t*        RP3 Golden/Primary flash Version              *\n"
    else
        printf "      \t*        RSP5 Golden/Primary flash Version             *\n"
    fi
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Golden" "Primary" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "$gol_rommon" "$pri_rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU-DDR4" "$gol_ipu" "$pri_ipu" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Beta-FPGA" "$gol_beta" "$pri_beta" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Zenith-FPGA" "$gol_zenith" "$pri_zenith" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Orion-FPGA" "$gol_orion" "$pri_orion" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Aldrin-0-FPGA" "$gol_aldrin_0" "$pri_aldrin_0" "*"
    if [ "$rp3" == "true" ]; then
    	printf "\t*    %-18s %-10s %-10s %10s\n" "Aldrin-1-FPGA" "$gol_aldrin_1" "$pri_aldrin_1" "*"
    fi
    printf "\t********************************************************\n"
}

function rsp4l_golden()
{
    bios_ready=$($RMON_BIN_RP -i -o)
    if [ -z "$bios_ready" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_rp -t 0 -d -o -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    optimus=$($FPD_BIN -s 7 -t 0 -v)
    omega=$($FPD_BIN -s 6 -t 0 -v)
    alpha=$($FPD_BIN -s 5 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        RSP4L Golden Version                          *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "17.31" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.110" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.110" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "0.19" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Optimus-FPGA" "0.4" "$optimus" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Omega-FPGA" "0.4" "$omega" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Alpha-FPGA" "0.5" "$alpha" "*"
    printf "\t********************************************************\n"
}

function rsp4s_golden()
{
    bios_ready=$($RMON_BIN_RP -i)
    if [ "$bios_ready" != "1" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_rp -t 0 -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    optimus=$($FPD_BIN -s 7 -t 0 -v)
    omega=$($FPD_BIN -s 6 -t 0 -v)
    cha=$($FPD_BIN -s 8 -t 0 -v)
    alpha=$($FPD_BIN -s 5 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        RSP4S Golden Version                           *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "16.9" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.96" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.96" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "0.52" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Optimus-FPGA" "0.12" "$optimus" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Omega-FPGA" "0.11" "$omega" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Alpha-FPGA" "0.14" "$alpha" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Cha-FPGA" "0.8" "$cha" "*"
    printf "\t********************************************************\n"
}

function rp_starlord_golden()
{
    bios_ready=$($RMON_BIN_RP -i -o)
    if [ -z "$bios_ready" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_rp -t 0 -d -o -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    drax=$($FPD_BIN -s 5 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        STARLORD RP Golden Version                    *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "22.16" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.104" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.104" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "2.4" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "DRAX-FPGA" "0.27" "$drax" "*"
    printf "\t********************************************************\n"
}

function lc_starlord_golden()
{
    bios_ready=$($RMON_BIN_LC -i -o)
    if [ -z "$bios_ready" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -d -o -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    gamora=$($FPD_BIN -s 5 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        STARLORD LC Golden Version                    *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "23.15" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.104" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.104" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "1.8" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "GAMORA-FPGA" "0.26" "$gamora" "*"
    printf "\t********************************************************\n"
}

function lc_laserbeak_golden()
{
    bios_ready=$($RMON_BIN_LC -i)
    if [ "$bios_ready" != "1" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    Meldun_0=$($FPD_BIN -s 5 -i 0 -t 0 -v)
    Martell=$($FPD_BIN -s 6 -i 0 -t 0 -v)
    Doran=$($FPD_BIN -s 7 -t 0 -v)
    Frenzy=$($FPD_BIN -s 9 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        LC Laserbeak Golden Version                      *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "8.43" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.98" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.98"  "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "1.92" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Meldun-0" "1.6" "$Meldun_0" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Martell" "1.3" "$Martell" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Doran" "1.5" "$Doran" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Frenzy" "49.0" "$Frenzy" "*"
    printf "\t********************************************************\n"
}


function lc_octane_golden()
{
    bios_ready=$($RMON_BIN_LC -i)
    if [ "$bios_ready" != "1" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    Meldun_0=$($FPD_BIN -s 5 -i 1 -t 0 -v)
    Meldun_1=$($FPD_BIN -s 5 -i 0 -t 0 -v)
    Dalla=$($FPD_BIN -s 6 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        LC Octane Golden Version                      *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "8.43" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.96" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.96"  "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "1.91" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Meldun-0" "1.6" "$Meldun_0" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Meldun-1" "1.6" "$Meldun_1" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Dalla" "1.9" "$Dalla" "*"
    printf "\t********************************************************\n"
}

function lc_skyhammer_golden()
{
    bios_ready=$($RMON_BIN_LC -i -o)
    if [ -z "$bios_ready" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -d -o -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    Morra_0=$($FPD_BIN -s 5 -i 1 -t 0 -v)
    Sideswipe_0=$($FPD_BIN -s 6 -i 1 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        LC Skyhammer Golden Version                   *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "9.23" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.112" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.112" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "1.88" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Morra-0" "1.2" "$Morra_0" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Sideswipe-0" "1.2" "$Sideswipe_0" "*"
    if [ "$PD_CARDTYPE" != "0x3d02c2" ]; then
        Morra_1=$($FPD_BIN -s 5 -i 0 -t 0 -v)
        Sideswipe_1=$($FPD_BIN -s 6 -i 0 -t 0 -v)
        printf "\t*    %-18s %-10s %-10s %10s\n" "Morra-1" "1.2" "$Morra_1" "*"
        printf "\t*    %-18s %-10s %-10s %10s\n" "Sideswipe-1" "1.2" "$Sideswipe_1" "*"
    fi
    printf "\t********************************************************\n"
}

function lc_sureshot_golden()
{
    bios_ready=$($RMON_BIN_LC -i)
    if [ "$bios_ready" != "1" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)
    Blaster=$($FPD_BIN -s 12 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        LC Sureshot Golden Version                    *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "8.43" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.96" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.96"  "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "1.91" "$ipu_fpga" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Blaster" "1.19" "$Blaster" "*"
    printf "\t********************************************************\n"
}

function lc_azteca_golden()
{
    gol_rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -v')
    pri_rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 1 -v')

    mb_db=$(is_board_azteca_mb_db_only)

    gol_ipu=$($FPD_BIN -s 37 -t 0 -v)
    gol_grapple_0=$($FPD_BIN -s 5 -i 1 -t 0 -v)
    gol_scamper=$($FPD_BIN -s 6 -t 0 -v)
    gol_mixmaster_0=$($FPD_BIN -s 7 -i 1 -t 0 -v)
    gol_skylynx_0=$($FPD_BIN -s 8 -i 1 -t 0 -v)
    gol_aldrin=$($FPD_BIN -s 13 -i 0 -t 0 -v)

    if [ "$mb_db" == "true" ]; then
    	gol_mixmaster_1=$($FPD_BIN -s 7 -i 0 -t 0 -v)
    	gol_skylynx_1=$($FPD_BIN -s 8 -i 0 -t 0 -v)
    	gol_grapple_1=$($FPD_BIN -s 5 -i 0 -t 0 -v)
    	pri_mixmaster_1=$($FPD_BIN -s 7 -i 0 -t 1 -v)
    	pri_skylynx_1=$($FPD_BIN -s 8 -i 0 -t 1 -v)
    	pri_grapple_1=$($FPD_BIN -s 5 -i 0 -t 1 -v)
    fi

    pri_ipu=$($FPD_BIN -s 37 -t 1 -v)
    pri_grapple_0=$($FPD_BIN -s 5 -i 1 -t 1 -v)
    pri_scamper=$($FPD_BIN -s 6 -t 1 -v)
    pri_mixmaster_0=$($FPD_BIN -s 7 -i 1 -t 1 -v)
    pri_skylynx_0=$($FPD_BIN -s 8 -i 1 -t 1 -v)
    pri_aldrin=$($FPD_BIN -s 13 -i 0 -t 1 -v)



    printf "\n\t********************************************************\n"
    printf "      \t*        Azteca Golden/Primary flash Version           *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Golden" "Primary" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "$gol_rommon" "$pri_rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU-DDR4" "$gol_ipu" "$pri_ipu" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Grapple-0" "$gol_grapple_0" "$pri_grapple_0" "*"
    if [ "$mb_db" == "true" ]; then
    	printf "\t*    %-18s %-10s %-10s %10s\n" "Grapple-1" "$gol_grapple_1" "$pri_grapple_1" "*"
    fi
    printf "\t*    %-18s %-10s %-10s %10s\n" "Mixmaster-0" "$gol_mixmaster_0" "$pri_mixmaster_0" "*"
    if [ "$mb_db" == "true" ]; then
    	printf "\t*    %-18s %-10s %-10s %10s\n" "Mixmaster-1" "$gol_mixmaster_1" "$pri_mixmaster_1" "*"
    fi
    printf "\t*    %-18s %-10s %-10s %10s\n" "Skylynx-0" "$gol_skylynx_0" "$pri_skylynx_0" "*"
    if [ "$mb_db" == "true" ]; then
    	printf "\t*    %-18s %-10s %-10s %10s\n" "Skylynx-1" "$gol_skylynx_1" "$pri_skylynx_1" "*"
    fi
    printf "\t*    %-18s %-10s %-10s %10s\n" "Scamper" "$gol_scamper" "$pri_scamper" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Aldrin" "$gol_aldrin" "$pri_aldrin" "*"
    printf "\t********************************************************\n"
}

function lc_powerglide_golden()
{
    local db_ct

    let "db_ct = $PD_CARDTYPE & 0xF"
            
    bios_ready=$($RMON_BIN_LC -i -o)
    if [ -z "$bios_ready" ]; then
        Rommon="NOT READY"
    else
    	Rommon=$(ssh my_host '/opt/cisco/hostos/bin/rmon_spi_writer_lc -t 0 -d -o -v')
    fi

    ipu_fsbl=$($FPD_BIN -s 28 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 4 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 29 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*        LC Powerglide Golden Version                  *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "Primary-BIOS" "18.24" "$Rommon" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.111" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.111" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "1.88" "$ipu_fpga" "*"
    # Powerglide 24port linecards are 1 slice based
    if [ $db_ct -eq 10 -o  $db_ct -eq 11 -o $db_ct -eq 12 ]; then
        Leadfoot_0=$($FPD_BIN -s 5 -i 0 -t 0 -v)
        printf "\t*    %-18s %-10s %-10s %10s\n" "Leadfoot-0" "0.05" "$Leadfoot_0" "*"
    else
        Leadfoot_0=$($FPD_BIN -s 5 -i 1 -t 0 -v)
        Leadfoot_1=$($FPD_BIN -s 5 -i 0 -t 0 -v)
        printf "\t*    %-18s %-10s %-10s %10s\n" "Leadfoot-0" "0.05" "$Leadfoot_0" "*"
        printf "\t*    %-18s %-10s %-10s %10s\n" "Leadfoot-1" "0.05" "$Leadfoot_1" "*"
    fi
    printf "\t********************************************************\n"
}

function fc2_golden()
{
    ipu_fsbl=$($FPD_BIN -s 32 -i $1 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 10 -i $1 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 33 -i $1 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*             FC2 Golden Version                       *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.100" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.100" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "0.37" "$ipu_fpga" "*"
    printf "\t********************************************************\n"
}

function fc2s_golden()
{
    ipu_fsbl=$($FPD_BIN -s 32 -i $1 -t 0 -v)
    ipu_fpga=$($FPD_BIN -s 10 -i $1 -t 0 -v)
    ipu_linux=$($FPD_BIN -s 33 -i $1 -t 0 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*             FC2S Golden Version                      *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Minimum" "Programmed" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FSBL" "1.100" "$ipu_fsbl" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_Linux" "1.100" "$ipu_linux" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU_FPGA" "0.37" "$ipu_fpga" "*"
    printf "\t********************************************************\n"
}

function fc3_golden()
{
    gol_ipu=$($FPD_BIN -s 38 -i $1 -t 0 -v)

    pri_ipu=$($FPD_BIN -s 38 -i $1 -t 1 -v)

    printf "\n\t********************************************************\n"
    printf "      \t*             FC3 Golden/Primary Version               *\n"
    printf "\t********************************************************\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Golden" "Primary" "*"
    printf "\t*    %-18s %-10s %-10s %10s\n" "" "Version" "Version" "*"
    printf "\t*                                                      *\n"
    printf "\t*    %-18s %-10s %-10s %10s\n" "IPU-DDR4" "$gol_ipu" "$pri_ipu" "*"
    printf "\t********************************************************\n"
}

if [ "${1}" == "RP" -o "${1}" == "rp" ]; then
    check_upgrade_progress
    get_board_type
    rsp4s=$(is_board_rsp4s)
    rsp4l=$(is_board_rsp4l)
    rp3=$(is_board_rp3_rsp5)
    star_rp=$(is_board_rp_starlord)
    if [ "${BOARDTYPE}" == "RP" ]; then
        if [ "$rsp4s" == "true" ]; then
            rsp4s_golden
        elif [ "$star_rp" == "true" ]; then
            rp_starlord_golden
        elif [ "$rsp4l" == "true" ]; then
            rsp4l_golden
        elif [ "$rp3" == "true" ]; then
            rp3_golden
        else
            rp_golden
        fi
    else
       printf "this is not RP2/RSP4/RSP4S/RSP4L, please run it on RP\n"
    fi
elif [ "${1}" == "LC" -o "${1}" == "lc" ]; then
    check_upgrade_progress
    get_board_type
    if [ "${BOARDTYPE}" == "LC" ]; then
        if [ "${2}" == "0" ]; then
            lc_octane_golden
        elif [ "${2}" == "1" ]; then
            lc_skyhammer_golden
        elif [ "${2}" == "2" ]; then
            lc_laserbeak_golden
        elif [ "${2}" == "3" ]; then
            lc_sureshot_golden
        elif [ "${2}" == "4" ]; then
            lc_azteca_golden
        elif [ "${2}" == "5" ]; then
            lc_powerglide_golden
        elif [ "${2}" == "6" ]; then
            lc_starlord_golden
        else
            usage
        fi 
    else
       printf "this is not LC, please run it on LC\n"
    fi

elif [ "${1}" == "FC" -o "${1}" == "fc" ]; then
    check_upgrade_progress
    get_board_type
    rsp4s=$(is_board_rsp4s)
    rp2_rp3=$(is_board_rp2_rp3)
    if [ "${BOARDTYPE}" == "RP" -a "$rp2_rp3" == "true" ]; then
        if [ "$2" != "" -a $2 -le $MAX_FC_SLOT ]; then
            fc3=$(is_board_fc3 $2)
            if [ "$fc3" == "false" ]; then         
                fc2_golden $2
            else
                fc3_golden $2
            fi
        else
            usage
        fi
    elif [ "${BOARDTYPE}" == "RP" -a "$rsp4s" == "true" ]; then
        if [ "$2" != "" -a $2 -le $MAX_FC2S_SLOT ]; then
            fc2s_golden $2
        else
            usage
        fi

    else
       printf "this is not RP2/RP3/RSP4S, please run it on RP2/RP3/RSP4S\n"
    fi
else
    usage
fi 
