#!/bin/bash
# Dump the golden lock status for RP, LC
# Copyright (c) 2015-2019 by cisco Systems, Inc. All rights reserved.
#

LOCK_BIN=/opt/cisco/calvados/bin/fpd_flash_golden

function check_upgrade_progress()
{
    process_check=$(ps -aef)
    if [[ $process_check == *"_spi_writer"* || $process_check == *"fpd_golden_lock"* ]]; then
         printf "\n\t\tWARNING: upgrade in progress,\n\t\tPlease run after upgrade done...\n\n"
         exit
    fi
}


function get_board_type()
{
    if [[ -f /root/cmdline ]]; then
        PROC_CMDLINE=$(cat /root/cmdline)
    else
        PROC_CMDLINE=$(cat /proc/cmdline)
    fi

    for x in ${PROC_CMDLINE} ; do
        case "$x" in
            cardtype=*)
            PD_CARDTYPE="${x#cardtype=}"
            ;;
        esac
    done
}

function is_board_azteca()
{
    if [ "${PD_CARDTYPE}" \> "0x3f04ff" -a \
         "${PD_CARDTYPE}" \< "0x3f0601" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_board_rp3_rsp5()
{
    if [ "${PD_CARDTYPE}" == "0x100346" -o \
         "${PD_CARDTYPE}" == "0x100347" -o \
         "${PD_CARDTYPE}" == "0x100348" -o \
         "${PD_CARDTYPE}" == "0x100336" -o \
         "${PD_CARDTYPE}" == "0x100337" -o \
         "${PD_CARDTYPE}" == "0x100338" ]; then
        printf "true"
    else
        printf "false"
    fi
}

function is_locked()
{
    if [ "$2" == "golden_is_all_locked: returned 1" ]; then
        printf "\t*    %-18s %-18s %s\n" "$1" "LOCKED" "*"
    elif [ "$2" == "golden_is_all_locked: returned 0" ]; then
        printf "\t*    %-18s %-18s %s\n" "$1" "NOT LOCKED" "*"
    else
        printf "\t*    %-18s %-18s %s\n" "$1" "ERRORED" "*"
    fi
}

function lock_status()
{
   $LOCK_BIN -c isLocked -f $1
}

function tomahawk_fpd()
{
    ipu_fsbl=$(lock_status "3")
    ipu_fpga=$(lock_status "4")
    ipu_linux=$(lock_status "5")

    is_locked "IPU_FSBL" "$ipu_fsbl"
    is_locked "IPU_LINUX" "$ipu_linux"
    is_locked "IPU_FPGA" "$ipu_fpga"
}

function rp3_ls_fpd()
{
    ipu_bundle=$(lock_status "2")
    is_locked "IPU-DDR4" "$ipu_bundle"
    secure=$(lock_status "6")
    if [ "$1" == "true" ]; then
        is_locked "SCAMPER" "$secure"
    else
        is_locked "ORION" "$secure"
    fi
}

check_upgrade_progress
get_board_type
rp3=$(is_board_rp3_rsp5)
azteca=$(is_board_azteca)
printf "\n\t********************************************\n"
printf "\t*             Golden Lock Status           *\n"
printf "\t********************************************\n"
if [ "$rp3" == "true" -o "$azteca" == "true" ]; then
    rp3_ls_fpd "$azteca"
else
    tomahawk_fpd
fi
printf "\t********************************************\n"
