#!/bin/bash 
# console_mux.sh
#This shell script is called from agetty when a single
#serial port is used to toggle between
#all the running entities in the system.
#      
# Copyright (c) 2015-2016 by Cisco Systems, Inc.

source /etc/init.d/console_lib.sh

if [ -f /etc/init.d/calvados_bootstrap.cfg ]; then
    source /etc/init.d/calvados_bootstrap.cfg
fi

if [ -f /etc/init.d/pd-functions ]; then
    source /etc/init.d/pd-functions
    declare -F platform_get_mux_tty_settings &>/dev/null \
       && platform_get_mux_tty_settings
fi

#function to get the list of XR/Calvados domains
function get_domain_list {

    local list=''
    local array=''
    local index=0
    local count=0
    declare -a list

    if [[ "$VIRT_METHOD" == "lxc" ]]; then
         list=`$VIRSH_LXC_CMD list --all | sed -n '3,$p'` 
    else
         list=`$VIRSH_VM_CMD list --all | sed -n '3,$p'`
    fi
    array=($list)
    for (( count=0; count<"${#array[@]}"; count+=3 ))
    do
        if [[ "${array[$count+2]}" == "running" ]]; then 
            if [[ "${array[$count+1]}" == "sysadmin" ]] || 
               [[ "${array[$count+1]}" == "default-sdr"* ]]; then
                list[$index]="${array[$count+1]}"
                index=$index+1
            fi
        fi    
    done

    #return
    eval $1="'${list[@]}'"

}

function start_lxc_console {
    local lxc_name=$1
    while true 
    do 
        socat "$MUX_TTY","$MUX_TTY_SOCAT_OPTION",escape=0x0f EXEC:"/etc/init.d/console_wait.sh ${lxc_name}",pty,setsid,ctty
        check_lxc ${lxc_name}
        if [[ $? -ne 0 ]]; then
           return 
        fi
        local real_lxc_name=
        get_lxc_name_from_wc ${lxc_name} real_lxc_name
        get_lxc_port "${real_lxc_name}" port_num
        if [[ "$port_num" != "0" ]]; then
            echo -ne '\n'
            echo "Connecting to '${real_lxc_name}' console" 
            socat "$MUX_TTY","$MUX_TTY_SOCAT_OPTION",escape=0x0f tcp:127.0.0.1:$port_num
            echo -ne '\n'
            echo "Disconnecting from '${real_lxc_name}' console. Continue(Y/N)?"
            #Logic to wait for 5 secs and to allow user to provide the input
            #RETURN is not considered as input
	    diff=0
            prompt=""
            date1=$(date +"%s")
            while [ $diff -lt 5 ]; do
                read -t 5 -e prompt
                date2=$(date +"%s")
                diff=$(($date2-$date1))
                if [[ $prompt = "" ]]; then
                    continue
                else
                    break
                fi
            done 
              
            if [[ "$prompt" =~ ^(yes|[yY]| ) ]]; then
                echo -ne '\n'
                return
            elif [[ "$prompt" =~ ^(no|[nN]| ) || $prompt = "" ]]; then
                echo -ne '\n'
            fi
        else
            continue
        fi
    done
}


function start_host_console {
    while true 
    do 
        echo "Connecting to 'host' console" 
        socat "$MUX_TTY","$MUX_TTY_SOCAT_OPTION",escape=0x0f EXEC:'/opt/cisco/hostos/bin/host_login',pty,setsid,ctty,stderr
        echo "Disconnecting from host console. Continue(Y/N)?"
        diff=0
        prompt=""
        date1=$(date +"%s")
        while [ $diff -lt 5 ]; do
            read -t 5 -e prompt
            date2=$(date +"%s")
            diff=$(($date2-$date1))
            if [[ $prompt = "" ]]; then
                continue
            else
                break
            fi
        done

        if [[ "$prompt" =~ ^(yes|[yY]| ) ]]; then
            echo -ne '\n'
            return
        elif [[ "$prompt" =~ ^(no|[nN]| ) || $prompt = "" ]]; then
            echo -ne '\n'
        fi
    done
}

#We ideally don't want to give host access
#Wait for calvados to be up
sleep 3

export LD_LIBRARY_PATH=/opt/cisco/hostos/usr/lib64

if [ -n "$MUX_TTY" ] ; then

    declare -a domain_list

    # In case of MUX_TTY_TYPE=3, we want to connect to default-sdr first.
    # In failure case when default-sdr is not launched, 
    while true
    do
        case "$MUX_TTY_TYPE" in
        4)
            start_lxc_console "default-sdr--1"
            start_lxc_console "sysadmin"
            ;;
        3)
            start_lxc_console "default-sdr--1"
            start_lxc_console "sysadmin"
            start_host_console
            ;;
        2)
            start_lxc_console "sysadmin"
            start_host_console
            ;;
        1)
            # Considering ISSU console mux accepts wildcard regex
            start_lxc_console "default-sdr.*"
            start_lxc_console "sysadmin"
            start_host_console
            ;;
        *)
            #get the list of domains in the system
            get_domain_list RETVAL
            domain_list=($RETVAL)
            #Escape character is "ctrl O <ENTER>; O as in Orange"
            for (( count=0; count<${#domain_list[@]}; count+=1 ))
            do    
                get_lxc_port "${domain_list[$count]}" port_num
                if [[ "$port_num" != "0" ]]; then
                   socat "$MUX_TTY","$MUX_TTY_SOCAT_OPTION",escape=0x0f tcp:127.0.0.1:$port_num
                fi
            done
            socat "$MUX_TTY","$MUX_TTY_SOCAT_OPTION",escape=0x0f EXEC:'/opt/cisco/hostos/bin/host_login',pty,setsid,ctty
            ;;
        esac
    done
fi

