#!/bin/bash
#------------------------------------------------------------------
# xr_post_launch.sh
#
#------------------------------------------------------------------
# Add code in this script for XR post launch
#
# Copyright (c) 2014-2016 by Cisco Systems, Inc.
# All rights reserved.

# The script is only valid on HostOS
#
# The Calvados VMM manager calls this script.
# The script can add frontpanel usb disk to XR
# 
if [ -f /etc/init.d/spirit-functions ]; then
    source /etc/init.d/spirit-functions
fi

if [ -f /etc/init.d/pd-functions ]; then
    source /etc/init.d/pd-functions
fi

BOOTSTRAP_FILE="/etc/init.d/calvados_bootstrap.cfg"
source $BOOTSTRAP_FILE

declare -F platform_log &>/dev/null && platform_log "XR post launch, VMTYPE $VMTYPE"

# for app hosting a special CGROUP node is created and configured
# on per platform.
if [[ "$VMTYPE" == "hostos" && "$VIRT_METHOD" == "lxc" ]]; then
    declare -F app_host_is_enabled &>/dev/null && app_host_is_enabled
    if [[ $? -eq 0 ]]; then
        /etc/init.d/tp_app_cgrp_cfg.sh
    fi
fi

if [ -z ${VMTYPE} ]; then
    VMTYPE=`cat /proc/cmdline | sed 's/^.*vmtype=//' | cut -d" " -f1`
fi

if [ -n ${VMTYPE} -a ${VMTYPE} == "hostos" ]; then
    declare -F platform_log &>/dev/null && platform_log "XR post launch; wait for VM"

    COLDPLUG=$(ls /dev/usbsd* 2> /dev/null )
    if [[ -n ${COLDPLUG} ]]; then
        sleep 40 # Give some time for XR VM to launch
        for i in ${COLDPLUG}; do
            j=$(basename "${i}")
            /usr/bin/usb_passthrough.sh "add" "${j}"
        done
    fi
fi

declare -F platform_post_xr_launch &>/dev/null && platform_post_xr_launch 

declare -F platform_log &>/dev/null && platform_log "XR post launch, done"

exit 0
