#!/usr/bin/env python
#
# Plugin for app_hosting_apply_host_cmd remote host linux commands support
#
# Copyright (c) 2017 by cisco Systems, Inc.
# All rights reserved.
#
import app_hosting_apply_cmd_util

#
# host ommands class for handling remote host linux commands.
#
class HostCommand(object):

    def handle_command(self, cmd):
        '''
        Only mount and umount linux tools are allowed
        with this utility.
        '''
        hostcmd_supported_commands = ["mount", "umount"]

        if cmd[1] in hostcmd_supported_commands:
            return app_hosting_apply_cmd_util.shell(cmd[1:])

        return (-1, "Unsupported host_cmd command {}".format(cmd), "")

    def description(self):

        return ("""
                mount  - mount file systems (see man mount for more info)
                umount - unmount file systems (see man umount for more info)
                """)
