#!/bin/bash
# console_wait.sh
# Copyright (c) 2015-2016 by Cisco Systems, Inc.

lxc_name=$1
source /etc/init.d/console_lib.sh

if [ -f /etc/init.d/calvados_bootstrap.cfg ]; then
    source /etc/init.d/calvados_bootstrap.cfg
fi

retry_count=1
RETRY_TIMEOUT=900
if [ ! -z "$PD_CONSOLE_MUX_RETRY_TIMEOUT" ]; then
    RETRY_TIMEOUT=$PD_CONSOLE_MUX_RETRY_TIMEOUT
fi

while [[ $retry_count -lt $RETRY_TIMEOUT ]]
do
    check_lxc ${lxc_name}
    if [[ $? -eq 0 ]]; then
        port_num=0
        lxc_real_name=
        get_lxc_name_from_wc ${lxc_name} lxc_real_name 
        get_lxc_port "${lxc_real_name}" port_num
        netstat -nat | grep LISTEN | grep -q $port_num
        if [[ $? -eq 0 ]]; then
            sleep 2
            exit
        else
            retry_count=$(($retry_count+1))
            continue
        fi
    else
        read -t 5 -e prompt
        if [[ $? -eq 0 ]]; then
            echo "#### Waiting for '${lxc_real_name}' $VIRT_METHOD to be ready. ####"
            echo -ne '\n'
            echo "If you want to connect to available console, press 'Ctrl-o' <'o' as in orange>"
            echo -ne '\n'
            retry_count=$(($retry_count+1))
        else
            retry_count=$(($retry_count+5))
        fi
    fi
done

