#!/bin/sh
# Copyright (c) 2014-2015 by cisco Systems, Inc.
# All rights reserved.
# 
# Get Host OS IP address from a calvados boot strap
# file maintained per platform. 
# The bootstrap config file contains the address in
# hex format. Convert to dotted notation before 
# configuring the interface.

BOOTSTRAP_FILE="/etc/init.d/calvados_bootstrap.cfg"
if [ -f $BOOTSTRAP_FILE ]; then
    . $BOOTSTRAP_FILE
fi
HOST_IP_STR=$(for i in $(/bin/echo -n ${HOST_IP_ADDR} | sed 's/\(..\)/0x\1 /g'); do printf "%hu." $i; done | sed 's/\.$//') > /dev/null 2>&1

if [ "${HOST_IP_STR}" != "" ]; then
    ifconfig $1 ${HOST_IP_STR}/24 up
fi
