#!/bin/sh
#------------------------------------------------------------------
# restart_libvirtd.sh
#  
# Copyright (c) 2014-2015 by Cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
# When vm_manager gets stuck at a libvirt call, it can falls in an
# endless restart loop. Then vm_manager will invoke this script to
# get rid of the dead restart loop. ccc reset will not kick in to
# recover the system in this case.
#
# The script will dump a core for libvirtd and save /var/log/libvirt
# before restarting libvirtd.
#
# The script is only valid on HostOS
#
LIBVIRTD_PID=`cat /var/run/libvirtd.pid`
kill -6 $LIBVIRTD_PID > /dev/null
sleep 2
LIBVIRTD_CORE=$(ls /misc/scratch/core/libvirtd_${LIBVIRTD_PID}.by.6.*.core.txt | head -n 1)
VARLOG_BASE=$(basename "${LIBVIRTD_CORE}")
VARLOG_BASE="${VARLOG_BASE/%core.txt/var_log_libvirt.tgz}"
VARLOG_DIR=$(dirname "${LIBVIRTD_CORE}")
VARLOG=${VARLOG_DIR}/${VARLOG_BASE}
tar cvfz ${VARLOG} /var/log/libvirt > /dev/null 2>&1
service libvirtd restart > /dev/null

