<?xml version="1.0" encoding="UTF-8"?>

<!-- Stylesheet Version: 1.0

This file contains the commonly used stylesheet.

May 2014 Sudhanshu

Copyright (c) 2014-2015, 2018 by Cisco Systems, Inc.
All rights reserved.

 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:str="http://www.ora.com/XSLTCookbook/namespaces/strings"
  xmlns:text="http://www.ora.com/XSLTCookbook/namespaces/text">
    <xsl:include href="/pkg/xslt/text.justify.xslt"/>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefCard/BriefLocationTable/">
        <xsl:call-template name="brief_node_info">
                <xsl:with-param name="indent" select="BriefLocation"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="brief_node_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Active Alarms (Brief) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Active/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>

<xsl:if test="count(Active/AlarmInfo/Entry)!=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="Active/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
History Alarms (Brief) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(History/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>

<xsl:if test="count(History/AlarmInfo/Entry)!=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Clear Time'"/>
          <xsl:with-param name="width" select="56"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="History/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="65"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Suppressed Alarms (Brief) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Suppressed/SuppressedInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>

<xsl:if test="count(Suppressed/SuppressedInfo/Entry)!=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Suppressed Time'"/>
          <xsl:with-param name="width" select="61"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="Suppressed/SuppressedInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SuppressedTime"/>
          <xsl:with-param name="width" select="65"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Conditions (Brief) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Conditions/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>

<xsl:if test="count(Conditions/AlarmInfo/Entry)!=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="Conditions/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/Active/AlarmInfo">
        <xsl:call-template name="brief_active_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="brief_active_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Active Alarms (Brief)
--------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/History/AlarmInfo">
        <xsl:call-template name="brief_history_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>
    </xsl:template>

<xsl:template name="brief_history_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped History Alarms (Brief) 
--------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Clear Time'"/>
          <xsl:with-param name="width" select="56"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="65"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/Suppressed/SuppressedInfo">
        <xsl:call-template name="brief_suppressed_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>
    </xsl:template>

<xsl:template name="brief_suppressed_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Suppressed Alarms (Brief) 
--------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Suppressed Time'"/>
          <xsl:with-param name="width" select="61"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SuppressedTime"/>
          <xsl:with-param name="width" select="65"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/Conditions/AlarmInfo">
        <xsl:call-template name="brief_conditions_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="brief_conditions_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Conditions (Brief)
--------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>


    <xsl:output method="text"/>
    <xsl:template
match="//Alarms/Detail/DetailCard/DetailLocationTable/">
        <xsl:call-template name="detail_node_info">
                <xsl:with-param name="indent" select="DetailLocation"/>

        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_node_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Active Alarms (Detail) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Active/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:for-each select="Active/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>

<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="'Description:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Description"/>
  <xsl:with-param name="width" select="256"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Location:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Location"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'AID:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="AID"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'EID:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="EID"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="ReportingAgentID"/>
  <xsl:with-param name="width" select="10"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Pending Sync:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="PendingSync"/>
  <xsl:with-param name="width" select="5"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Severity:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Severity"/>
  <xsl:with-param name="width" select="12"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Status:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Status"/>
  <xsl:with-param name="width" select="8"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Group:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Group"/>
  <xsl:with-param name="width" select="20"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Set Time:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="SetTime"/>
  <xsl:with-param name="width" select="64"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Clear Time:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="ClearTime"/>
  <xsl:with-param name="width" select="64"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Service Affecting:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="ServiceAffecting"/>
  <xsl:with-param name="width" select="19"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Transport Direction:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="OTN/Direction"/>
  <xsl:with-param name="width" select="12"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Transport Source:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
 <xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="OTN/NotificationSource"/>
  <xsl:with-param name="width" select="12"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Interface:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Interface"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Alarm Name:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="AlarmName"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
History Alarms (Detail) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(History/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:for-each select="History/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'AID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'EID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="EID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportingAgentID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Pending Sync:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="PendingSync"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Status:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Status"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Set Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Clear Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Service Affecting:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ServiceAffecting"/>
          <xsl:with-param name="width" select="19"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Direction:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/Direction"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Source:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/NotificationSource"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Interface:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Interface"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarm Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AlarmName"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Suppressed Alarms (Detail) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Suppressed/SuppressedInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:for-each select="Suppressed/SuppressedInfo/Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'AID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'EID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="EID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportingAgentID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Pending Sync:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="PendingSync"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Status:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Status"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Set Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Suppressed Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SuppressedTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Service Affecting:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ServiceAffecting"/>
          <xsl:with-param name="width" select="19"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Direction:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/Direction"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Source:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/NotificationSource"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Interface:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Interface"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarm Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AlarmName"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Conditions (Detail) for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Conditions/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:for-each select="Conditions/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>

<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="'Description:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Description"/>
  <xsl:with-param name="width" select="256"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Location:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Location"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'AID:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="AID"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'EID:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="EID"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="ReportingAgentID"/>
  <xsl:with-param name="width" select="10"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Pending Sync:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="PendingSync"/>
  <xsl:with-param name="width" select="5"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Severity:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Severity"/>
  <xsl:with-param name="width" select="12"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Status:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Status"/>
  <xsl:with-param name="width" select="8"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Group:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Group"/>
  <xsl:with-param name="width" select="20"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Set Time:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="SetTime"/>
  <xsl:with-param name="width" select="64"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Clear Time:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="ClearTime"/>
  <xsl:with-param name="width" select="64"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Service Affecting:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="ServiceAffecting"/>
  <xsl:with-param name="width" select="19"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Transport Direction:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="OTN/Direction"/>
  <xsl:with-param name="width" select="12"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Transport Source:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
 <xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="OTN/NotificationSource"/>
  <xsl:with-param name="width" select="12"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Interface:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="Interface"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
<xsl:call-template name="text:justify">
 <xsl:with-param name="value" select="'Alarm Name:'"/>
  <xsl:with-param name="width" select="25"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
<xsl:call-template name="text:justify">
  <xsl:with-param name="value" select="AlarmName"/>
  <xsl:with-param name="width" select="128"/>
  <xsl:with-param name="align" select=" 'left' "/>
</xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Clients for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Clients/ClientInfo/Entry)=0">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:for-each select="Clients/ClientInfo/Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Agent Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Name"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Id"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Handle:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Handle"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent State:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="State"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Type:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Type"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter Display:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterDisp"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Subscriber ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SubscriberId"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterSeverity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter State:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterState"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterGroup"/>
          <xsl:with-param name="width" select="14"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Connect Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ConnectCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Connect Timestamp:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ConnectTimestamp"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Get Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="GetCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Subscribe Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SubscribeCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Report Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------</xsl:text>
Statistics for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Alarms Reported:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/Reported"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarms Dropped:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/Dropped"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Active (bi-state set):'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/Active"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'History (bi-state cleared):'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/History"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Suppressed:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/Suppressed"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped Invalid AID:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/DroppedInvalidAID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped No Memory:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/DroppedInsuffMem"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped DB Error:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/DroppedDbError"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped Clear Without Set:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/DroppedClearWithoutSet"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped Duplicate:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/DroppedDuplicate"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Cache Hit:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/CacheHit"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Cache Miss:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Stats/CacheMiss"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Detail/DetailSystem/Active/AlarmInfo">
        <xsl:call-template name="detail_system_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_system_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Active Alarms (Detail)</xsl:text>
    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'AID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'EID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="EID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportingAgentID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Pending Sync:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="PendingSync"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Status:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Status"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Set Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Clear Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Service Affecting:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ServiceAffecting"/>
          <xsl:with-param name="width" select="19"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Direction:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/Direction"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Source:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/NotificationSource"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Interface:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Interface"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarm Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AlarmName"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
    </xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Detail/DetailSystem/History/AlarmInfo">
        <xsl:call-template name="detail_system_history_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_system_history_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped History Alarms (Detail)</xsl:text>
    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'AID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'EID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="EID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportingAgentID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Pending Sync:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="PendingSync"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Status:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Status"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Set Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Clear Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Service Affecting:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ServiceAffecting"/>
          <xsl:with-param name="width" select="19"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Direction:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/Direction"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Source:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/NotificationSource"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Interface:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Interface"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarm Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AlarmName"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
    </xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Detail/DetailSystem/Suppressed/SuppressedInfo">
        <xsl:call-template name="detail_system_suppressed_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_system_suppressed_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Suppressed Alarms (Detail)</xsl:text>
    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'AID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'EID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="EID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportingAgentID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Pending Sync:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="PendingSync"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Status:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Status"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Set Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Suppressed Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SuppressedTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Service Affecting:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ServiceAffecting"/>
          <xsl:with-param name="width" select="19"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Direction:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/Direction"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Source:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/NotificationSource"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Interface:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Interface"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarm Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AlarmName"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Detail/DetailSystem/Conditions/AlarmInfo">
        <xsl:call-template name="detail_system_conditions_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_system_conditions_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Conditions (Detail)</xsl:text>
    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'AID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Tag String:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Tag"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Module Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Module"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'EID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="EID"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Reporting Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportingAgentID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Pending Sync:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="PendingSync"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Status:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Status"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Set Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Clear Time:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Service Affecting:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ServiceAffecting"/>
          <xsl:with-param name="width" select="19"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Direction:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/Direction"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Transport Source:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="OTN/NotificationSource"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Interface:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Interface"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarm Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="AlarmName"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
    </xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Detail/DetailSystem/Clients/ClientInfo">
        <xsl:call-template name="detail_system_clients_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_system_clients_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Clients</xsl:text>
    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Agent Name:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Name"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Id"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Location:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Handle:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Handle"/>
          <xsl:with-param name="width" select="128"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent State:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="State"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Type:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Type"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter Display:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterDisp"/>
          <xsl:with-param name="width" select="5"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Subscriber ID:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SubscriberId"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter Severity:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterSeverity"/>
          <xsl:with-param name="width" select="12"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter State:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterState"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Filter Group:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="FilterGroup"/>
          <xsl:with-param name="width" select="14"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Connect Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ConnectCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Connect Timestamp:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ConnectTimestamp"/>
          <xsl:with-param name="width" select="64"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Get Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
         <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="GetCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Subscribe Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SubscribeCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"> 
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Agent Report Count:'"/>
          <xsl:with-param name="width" select="25"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ReportCount"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
    </xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Detail/DetailSystem/Stats">
        <xsl:call-template name="detail_stats_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="detail_stats_info">
<xsl:param name="indent"/>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
System Scoped Statistics</xsl:text>
<xsl:text xml:space="preserve">
--------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Alarms Reported:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Reported"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Alarms Dropped:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Dropped"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Active (bi-state set):'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Active"/>
          <xsl:with-param name="width" select="20"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'History (bi-state cleared):'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="History"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Sys-admin Active:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SysadminActive"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Sys-admin History:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SysadminHistory"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Sys-admin Suppressed:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SysadminSuppressed"/>
          <xsl:with-param name="width" select="8"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped Invalid AID:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="DroppedInvalidAID"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped No Memory:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="DroppedInsuffMem"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped DB Error:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="DroppedDbError"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped Clear Without Set:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="DroppedClearWithoutSet"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Dropped Duplicate:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="DroppedDuplicate"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Cache Hit:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="CacheHit"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
         <xsl:with-param name="value" select="'Cache Miss:'"/>
          <xsl:with-param name="width" select="32"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="CacheMiss"/>
          <xsl:with-param name="width" select="10"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>



</xsl:stylesheet>
