<?xml version="1.0" encoding="UTF-8"?>

<!-- Stylesheet Version: 1.0

This file contains the commonly used stylesheet.

May 2014 Sudhanshu

Copyright (c) 2014-2016, 2018 by Cisco Systems, Inc.
All rights reserved.

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:str="http://www.ora.com/XSLTCookbook/namespaces/strings"
  xmlns:text="http://www.ora.com/XSLTCookbook/namespaces/text">
    <xsl:include href="/pkg/xslt/text.justify.xslt"/>
    
    <xsl:output method="text"/>
    <xsl:template
match="//Alarms/Brief/BriefCard/BriefLocationTable/">
        <xsl:call-template name="brief_node_info">
                <xsl:with-param name="indent" select="BriefLocation"/>

        </xsl:call-template>        
    </xsl:template>

<xsl:template name="brief_node_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
Active Alarms for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Active/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:if test="count(Active/AlarmInfo/Entry)!=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="250"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="Active/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="250"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
History Alarms for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(History/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:if test="count(History/AlarmInfo/Entry)!=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="23"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="256"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Clear Time'"/>
          <xsl:with-param name="width" select="56"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="History/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="250"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="69"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
Suppressed Alarms for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Suppressed/SuppressedInfo/Entry)=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:if test="count(Suppressed/SuppressedInfo/Entry)!=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Suppressed Time'"/>
          <xsl:with-param name="width" select="61"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="Suppressed/SuppressedInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SuppressedTime"/>
          <xsl:with-param name="width" select="69"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
Conditions for <xsl:value-of select="Naming/NodeID/Rack"/>/<xsl:value-of select="Naming/NodeID/Slot"/>
<xsl:if test="count(Conditions/AlarmInfo/Entry)=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
No entries.</xsl:text>
</xsl:if>
<xsl:if test="count(Conditions/AlarmInfo/Entry)!=0">
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="250"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>
</xsl:if>
    <xsl:for-each select="Conditions/AlarmInfo/Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="250"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>

</xsl:template>

</xsl:stylesheet>
