<?xml version="1.0" encoding="UTF-8"?>

<!-- Stylesheet Version: 1.0

This file contains the commonly used stylesheet.

May 2014 Sudhanshu

Copyright (c) 2014-2016, 2018 by Cisco Systems, Inc.
All rights reserved.

 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:str="http://www.ora.com/XSLTCookbook/namespaces/strings"
  xmlns:text="http://www.ora.com/XSLTCookbook/namespaces/text">
    <xsl:include href="/pkg/xslt/text.justify.xslt"/>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/Active/AlarmInfo">
        <xsl:call-template name="brief_active_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="brief_active_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
Active Alarms 
------------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/History/AlarmInfo">
        <xsl:call-template name="brief_history_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>
    </xsl:template>

<xsl:template name="brief_history_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
History Alarms 
------------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Clear Time'"/>
          <xsl:with-param name="width" select="56"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="ClearTime"/>
          <xsl:with-param name="width" select="69"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/Suppressed/SuppressedInfo">
        <xsl:call-template name="brief_suppressed_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>
    </xsl:template>

<xsl:template name="brief_suppressed_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
Suppressed Alarms 
------------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Suppressed Time'"/>
          <xsl:with-param name="width" select="61"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SuppressedTime"/>
          <xsl:with-param name="width" select="69"/>
          <xsl:with-param name="align" select=" 'right' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

    <xsl:output method="text"/>
    <xsl:template match="//Alarms/Brief/BriefSystem/Conditions/AlarmInfo">
        <xsl:call-template name="brief_conditions_info">
                <xsl:with-param name="indent" select="0"/>
        </xsl:call-template>        
    </xsl:template>

<xsl:template name="brief_conditions_info">
<xsl:param name="indent"/>

<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------
Conditions 
------------------------------------------------------------------------------------</xsl:text>
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Location'"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Severity'"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Group'"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Set Time'"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="'Description'"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve">
------------------------------------------------------------------------------------</xsl:text>

    <xsl:for-each select="Entry">
<xsl:text xml:space="preserve">
</xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Location"/>
          <xsl:with-param name="width" select="16"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Severity"/>
          <xsl:with-param name="width" select="13"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Group"/>
          <xsl:with-param name="width" select="17"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="SetTime"/>
          <xsl:with-param name="width" select="27"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
<xsl:text xml:space="preserve"></xsl:text>
        <xsl:call-template name="text:justify">
          <xsl:with-param name="value" select="Description"/>
          <xsl:with-param name="width" select="252"/>
          <xsl:with-param name="align" select=" 'left' "/>
        </xsl:call-template>
</xsl:for-each>
<xsl:text xml:space="preserve">
</xsl:text>
</xsl:template>

</xsl:stylesheet>

