#!/usr/bin/python
#------------------------------------------------------------------
# install_health_tooli_ld_verification.py
#
# Copyright (c) 2015-2018 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
#
import re
import os 
XR_LD_FILE = '/install/instdb/local/xr_ldpath.txt'
CAL_LD_FILE = '/install/instdb/local/calvados_ldpath.txt'
XR_PKG_PATH = "find /opt/cisco/XR/packages -iname *CSC*"
CAL_PKG_PATH = "find /opt/cisco/calvados/packages -iname *CSC*"  

def get_ld_path_smus():
    fh = open(XR_LD_FILE)
    val = fh.read()
    list1 = []
    match = re.search("ncs5500(.*)",val)

    if match: 
        list1 = list(map(str,match.group().split(":")))
    return list1

def get_build_time(list1):
    list2 = []
    for x in list1:
        cmd = "rpm -qi %s" %(x)
        val = os.popen(cmd).read()
        bt = re.search("Build Date: (.*)",val)
        list2.append(bt.group().split("Build Date: ")[1])
    return list2


def build_dictionary_for_order(ld_path_smus_list,ld_path_smus_build_time):
    dict1= {}
    i =0 
    len1 = len(ld_path_smus_list)
    while i<len1:
        val = re.split(r"(-\d)",ld_path_smus_list[i])
        if dict1.get(val[0]) == None:
            dict1[val[0]] = [((val[1]+val[2])[1:],i,ld_path_smus_build_time[i])]
        else:
            dict1.get(val[0]).append(((val[1]+val[2])[1:],i,ld_path_smus_build_time[i]))
        i +=1

    return dict1

def verify_build_order(build_order_dict):
    for k,v in build_order_dict.items():
        val = all(v[i][1] < v[i+1][1] for i in range(len(v)-1))
        if not val:
            print(False)
            break
        val = all(v[i][2] > v[i+1][2] for i in range(len(v)-1))
        if not val:
            print(False)
            break


def get_installed_smus():
    smus_list = [] 
    cmd = XR_PKG_PATH 
    val = os.popen(cmd).read()
    for k in val.split(os.linesep):
        if k:
            smus_list.append(k)
    return smus_list


def verify_content(smus_list,build_order_dict):
    for smu in smus_list:
        cmd = "find " + smu + " -type f"
        val = os.popen(cmd).read()
        for k in val.split(os.linesep):
            if k:
                val1= k.split("/")
                val2 = re.split(r"(-\d)",val1[5])
                superseded  = (val2[0] +"-" +build_order_dict.get(val2[0])[0][0])
                p = "/".join(val1[7:])
                cmd = "readlink -f /pkg/" + p
                link = os.popen(cmd).read()
                if link!= "" and len(link.split("/")) > 5 and superseded !=  link.split("/")[5]:
                    print(cmd)
    else:
        print(True)

if __name__ == "__main__":
    ld_path_smus_list = get_ld_path_smus()    
    ld_path_smus_build_time = get_build_time(ld_path_smus_list)
    if len(ld_path_smus_list) > 0 and len(ld_path_smus_build_time) > 0:
        build_order_dict = build_dictionary_for_order(ld_path_smus_list,
                ld_path_smus_build_time) 
    verify_build_order(build_order_dict)
    smus_list= get_installed_smus()
    verify_content(smus_list,build_order_dict)

