#!/bin/sh

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# Script that ensure log files dont constantly increase in size
#
# Feb 2016, Jieming Wang
#
# Copyright (c) 2016-2018 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

if [ -z "$USER" ]
then
    export USER=root
fi

is_calvados=$(cat /proc/cmdline|egrep "vmtype=sysadmin-vm")
is_xr=$(cat /proc/cmdline|egrep "vmtype=xr-vm")

if [ -n "${is_calvados}" ]
then
    pam_manager_log="/opt/cisco/calvados/pam/pam_manager.log"
    logrotate_conf=/opt/cisco/calvados/pam/pam_logrotate.conf
elif [ -n "${is_xr}" -o -f /opt/cisco/thinxr/am_i_thinxr ]
then
    pam_manager_log="/opt/cisco/pam/pam_manager.log"
    logrotate_conf=/pkg/opt/cisco/pam/pam_logrotate.conf
else 
    echo "Could not detect platform\n"
    exit 1
fi

test ! -d /opt/cisco/pam/ && mkdir -p /opt/cisco/pam/

if [ -f $logrotate_conf -a -f $pam_manager_log ]
then
     if [ -f /usr/sbin/logrotate ]
     then
	  /usr/sbin/logrotate $logrotate_conf >/dev/null 2>&1
     elif [ -f /usr/bin/logrotate ]
     then
	  /usr/bin/logrotate $logrotate_conf >/dev/null 2>&1
     else
	 logrotate $logrotate_conf >/dev/null 2>&1
     fi
elif [ -f $pam_manager_log ]
then
     size=$(stat -c "%s" $pam_manager_log)
     if [ $size -gt 1000000 ]
     then
	 gzip -f $pam_manager_log > /dev/null 2>&1 &
     fi
fi
