#!/bin/bash

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# This script will be executed *after* all the other init scripts.
# and then wait for all XR/Calvados daemons have started
#
# Feb 2016, Jieming Wang
#
# Copyright (c) 2016-2019 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx



uname=$(uname)
if [ $uname == "Linux" ]
then
    if [ -f /pkg/opt/cisco/pam/pam-functions.sh ]; then
        source /pkg/opt/cisco/pam/pam-functions.sh
    elif [ -f /opt/cisco/calvados/pam/pam-functions.sh ]; then
        source /opt/cisco/calvados/pam/pam-functions.sh
    fi

    LD_LIBRARY_PATH=/pkg/lib:/pkg/lib/cerrno:/pkg/lib/mib:/pkg/lib/spp_plugins
    pam_dir="/pkg/opt/cisco/pam/"
    pam_logdir="/var/log/"
    if [ -n "${is_calv}" ]
    then
        pam_dir="/opt/cisco/calvados/pam"
    fi
    tar_name=panini_perl_5.20.0.tar
    tgz_name=${tar_name}.gz
    src_tar="$pam_dir/$tar_name"
    src_tgz="$pam_dir/$tgz_name"

    #delete the tar file (leftover from previous releases)
    if [ -f $src_tar -o -h $src_tar ]
    then
        act_src_tar=$(readlink -f $src_tar)
        #test -f $act_src_tar && rm -f $act_src_tar >/dev/null
        #rm -f $src_tar >/dev/null
    fi

    pam_log="$pam_logdir/start_pam.log"
    install_log="$pam_logdir/pam_install.log"
    if [ -n "${is_panini}" ] || [ -n "${is_scapa}" ]
    then
        if [ ! -f /usr/local/bin/perl ]
        then
            dst_tgz="/usr/local/$tgz_name"
            if [ -f $src_tgz ]
            then
                test ! -d /usr/local && mkdir /usr/local
                cp -p $src_tgz /usr/local/
                cd /usr/local && tar xvf $dst_tgz > /dev/null 2>&1
                test -f $dst_tgz && rm -f $dst_tgz >/dev/null 2>&1
            fi
        fi
        if [ ! -f /usr/local/bin/perl ]
        then
            echo "/usr/local/bin/perl is missing" > $install_log
            exit
        fi
        if [ ! -h /usr/bin/perl ]
        then
            ln -s /usr/local/bin/perl /usr/bin/perl
        fi
        if [ ! -h /usr/lib64/libzmq.so.3 -a ! -f /usr/lib64/libzmq.so.3 ]
        then
            if [ -f /usr/lib64/libzmq.so ]
            then
                ln -s /usr/lib64/libzmq.so /usr/lib64/libzmq.so.3
            elif [ -f /usr/lib64/libzmq.so.4 ]
            then
                ln -s /usr/lib64/libzmq.so.4 /usr/lib64/libzmq.so.3
            else
                echo "/usr/lib64/libzmq.so.[4] is missing" >> $install_log
                exit
            fi
        fi
        sleep 2
    fi
    
    pam_dir="/pkg/opt/cisco/pam/";
    pam_collector_dir="/pkg/bin/";
    pid_dir="/opt/cisco/pam/run";
    if [ -n "${is_calv}" ]
    then
        pam_dir="/opt/cisco/calvados/pam";
        pam_collector_dir="/opt/cisco/calvados/bin/";
    fi

    #if not RP, skip starting pam agents
    if [ -z "${is_rp}" ]
    then
        exit
    fi

    test -f $pid_dir/stop && rm -f $pid_dir/stop
    test -f $pam_log && rm $pam_log
    for file in monitor_cpu.pl monitor_show_logging.pl monitor_crash.pl pam_cli_agent
    do
        pam_agent="${pam_dir}/${file}"
        if [ $file == "pam_cli_agent" ]
        then
            pam_agent="${pam_collector_dir}/${file}"
        fi
        test -f $pam_agent -a ! -x $pam_agent && chmod +x $pam_agent
        if [ -x $pam_agent ]
        then
            if [ $file == "pam_cli_agent" ]
            then
                export LD_LIBRARY_PATH=$LD_LIBRARY_PATH
                $pam_agent > $pam_dir/${file}.log 2>&1 &
            else
                $pam_agent > $pam_dir/${file}.log 2>&1
            fi
        else
            echo "$pam_agent not found (`date`)" >> $pam_log
        fi
    done

    #Cisco internally only
    if [ -x "/harddisk:/pam/install/robot_installer.sh" -a \
         -f "/harddisk:/pam/install/pam_robot.tar" ]
    then
        /harddisk:/pam/install/robot_installer.sh
    fi
    if [ -n "${is_asr9k}" -o -n "${is_xrv9k}" ] && \
       [ -n "${is_vxr}" -o -n "${is_dev}" ] && \
       [ -n "${is_calv}" ]  && [ -f "${pam_dir}/vxr_calv_start_pam.sh" ]
    then
        #check only needed to run first time
        ${pam_dir}/vxr_calv_start_pam.sh &
    fi
    if [ -n "${is_spitfire}" -o -d "/opt/cisco/thinxr/" ] && \
       [ -n "${is_vxr}" -o -n "${is_dev}" ] && \
       [ -f "${pam_dir}/thinxr_vxr_pam.sh" ]
    then

    if [ ! -f /tmp/pam_cvac.txt ]; then
        ${pam_dir}/thinxr_vxr_pam.sh &
        sleep 2
        date >> /tmp/pam_cvac.txt
    fi

    fi
    if [ -n "${is_asr9k}" -o -n "${is_xrv9k}" ] && \
       [ -n "${is_vxr}" -o -n "${is_dev}" ] && \
       [ -n "${is_xr}" ] && [ -f "/root/pam/xr_mount.sh" ]
    then
        bash /root/pam/xr_mount.sh &
    fi

elif [ $uname == "QNX" ]
then
    if [ -x "/harddisk://pam/pam_legacy_master_agent.pl" ]
    then
        perl /harddisk://pam/pam_legacy_master_agent.pl &
    fi
fi

