#!/usr/bin/perl

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# Script to disable PAM
#
# Jul 2017, Jieming Wang
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

use lib qw ( /pkg/opt/cisco/pam/ /opt/pam/ /opt/cisco/calvados/pam/ );

use pam;

use strict;
use warnings;

my $sys_info = &getOsType();
my $osType = $sys_info->{hostType};
my $platform = $sys_info->{platform};
my $vf1_3073_ip = $sys_info->{vf1_3073_ip};

my $node = "";
if ( -f "/pkg/bin/uname" ) {
    $node = `/pkg/bin/uname -n`;
} else {
    $node = `uname -n`;
}
my $chassis_id = get_chassis_id($sys_info);
if ($chassis_id !~ /^\d+$/) {
    print "Invalid chassis ID: $chassis_id (expect integer).\n";
    exit(1);
}

my $node_info = get_active_rp_nodes_by_chassis_id($sys_info, $chassis_id);
my ($startup_file, $actual_startup);
if ($osType =~ /xr/i) {
    $startup_file = "/pkg/startup/pam_manager.startup";
    #to enable, run find a,d create link:
    #my @files = `find /opt/cisco/ -name pam_manager.startup`;
    #$actual_startup = @files[0];
    #`ln -s $actual_startup $startup_file`;
    #
} elsif ($osType =~ /calvados/i) {
    $startup_file = "/opt/cisco/calvados/etc/startup/pam_manager.startup";
}

if ($osType =~ /calvados/i) {
    my $first_calv_ip = get_first_calv_ip($node_info);
    if ($vf1_3073_ip ne $first_calv_ip) {
        print "Not active RP. Ignore.\n";
        exit(0);
    }
}

if (!$node_info->{isActive}) {
    print "Not active RP. Ignore.\n";
    exit(0);
}

my $chvrf = "";
if (($osType =~ /calv/i) &&
    ($platform =~ /(ncs(4|6)k|panini|scapa)/i)) {
    $chvrf = "/sbin/chvrf 0 ";
}

my $ssh_o = "-q -o UserKnownHostsFile=/dev/null ";
$ssh_o .= "-o StrictHostKeyChecking=no ";
my $err_no = 0;
foreach my $node (@{$node_info->{nodeList}}) {
    my $ip = $node_info->{$node}->{IP};
    next if ($node !~ /R[S]?P|B\d+\/CB\d+/);
    next if (($platform =~ /nsc4k|scapa/i) && ($node =~ /VM2/));
    `$chvrf /usr/bin/ssh $ssh_o $ip "test -f $startup_file && rm -f $startup_file"`;
    my $output = `$chvrf /usr/bin/ssh $ssh_o $ip "ls -ld $startup_file 2>/dev/null"`;
    if ($output =~ /pam_manager/) {
        print "Failed to remove $startup_file on $node: $!\n";
        $err_no++;
    }
}

if ($err_no) {
    print "Failed to disable PAM.\n";
    exit(1);
} else {
    print "PAM has been disabled from startup during boot. Please execute \"processes shutdown pam_manager location <location>\" to stop PAM\n";
    #print "Note: PAM can still be started by executing \"processes start pam_manager\" until reload\n";
    print "After PAM is disabled and RP reload, PAM can be enabled by executing enable-pam and then reload\n";
    exit(0);
}


