#!/usr/bin/perl

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# Script to enable PAM
#
# Jul 2017, Jieming Wang
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

use lib qw ( /pkg/opt/cisco/pam/ /opt/pam/ /opt/cisco/calvados/pam/ );

use pam;
use strict;
use warnings;

my $sys_info = &getOsType();
my $osType = $sys_info->{hostType};
my $platform = $sys_info->{platform};
my $vf1_3073_ip = $sys_info->{vf1_3073_ip};

my $node = "";
if ( -f "/pkg/bin/uname" ) {
    $node = `/pkg/bin/uname -n`;
} else {
    $node = `uname -n`;
}
my $chassis_id = get_chassis_id($sys_info);
if ($chassis_id !~ /^\d+$/) {
    print "Invalid chassis ID: $chassis_id (expect integer).\n";
    exit(1);
}

my $node_info = get_active_rp_nodes_by_chassis_id($sys_info, $chassis_id);
my ($startup_file, $actual_startup);
my @startup_files = ();
if ($osType =~ /xr/i) {
    $startup_file = "/pkg/startup/pam_manager.startup";
    #run find and create link:
    @startup_files = `find /opt/cisco/XR/packages -name pam_manager.startup 2>/dev/null`;
} elsif ($osType =~ /calvados/i) {
    $startup_file = "/opt/cisco/calvados/etc/startup/pam_manager.startup";
    #run find and create link:
    @startup_files = `find /opt/cisco/calvados/packages -name pam_manager.startup 2>/dev/null`;
}
if (!@startup_files) {
    print "Cannot find original startup files\n";
    exit(1);
} else {
    $actual_startup = $startup_files[0];
    $actual_startup =~ s/[\r\n]//g;
    if (! -f $actual_startup) {
        print "Cannot find original startup file\n";
        exit(1);
    }
}

if ($osType =~ /calvados/i) {
    my $first_calv_ip = get_first_calv_ip($node_info);
    if ($vf1_3073_ip ne $first_calv_ip) {
        print "Not active RP. Ignore.\n";
        exit(0);
    }
}

if (!$node_info->{isActive}) {
    print "Not active RP. Ignore.\n";
    exit(0);
}

my $chvrf = "";
if (($osType =~ /calv/i) &&
    ($platform =~ /(ncs(4|6)k|panini|scapa)/i)) {
    $chvrf = "/sbin/chvrf 0 ";
}

my $ssh_o = "-q -o UserKnownHostsFile=/dev/null ";
$ssh_o .= "-o StrictHostKeyChecking=no ";
my $err_no = 0;
foreach my $node (@{$node_info->{nodeList}}) {
    my $ip = $node_info->{$node}->{IP};
    next if ($node !~ /R[S]?P|B\d+\/CB\d+/);
    next if (($platform =~ /nsc4k|scapa/i) && ($node =~ /VM2/));
    `$chvrf /usr/bin/ssh $ssh_o $ip "test ! -f $startup_file && ln -s $actual_startup $startup_file"`;
    my $output = `$chvrf /usr/bin/ssh $ssh_o $ip "ls -ld $startup_file 2>/dev/null"`;
    if ($output !~ /pam_manager/) {
        print "Failed to restore $startup_file on $node: $!\n";
        $err_no++;
    }
}

if ($err_no) {
    print "Failed to enable PAM\n";
    exit(1);
} else {
    print "PAM has been enabled for startup during boot. Please reload active RP to take effect (PAM cannot be started until reload)\n";
    print "After enabled and RP reload, PAM can be disabled by executing disable-pam and RP reload.\n";
    exit(0);
}


