import argparse
import crypt
import datetime
import fcntl
import hashlib
import json
import os
from   os import path as PATH
import re
import subprocess
from   subprocess import Popen, PIPE, call
import sys
import time


ROUTER_EDCD_PATH    = '/misc/scratch/pam/'
CISCO_SUPPORT_PATH  = '/misc/disk1/cisco_support/'
PAM_EEM_SYSLOG_JSON = '/misc/scratch/pam/pam_eem_syslog.json'
PAM_EEM_SYSLOG_LOG  = '/misc/disk1/cisco_support/pam_eem_syslog.log'
PAM_CMD_JSON        = '/misc/scratch/pam/pam_cmd.json'
PAM_EVENT_JSON      = '/misc/scratch/pam/pam_event.json'
PAM_PATTERN_JSON    = '/misc/scratch/pam/pam_pattern.json'
PAM_THROTTLE_JSON   = '/misc/scratch/pam/eem_throttle.json'

PLATFORMS             = {'all':'All', 'xrv9k':'Sunstone',
                         'sunstone':'Sunstone', 'asr9k':'ASR9K',
                         'ncs6k':'Panini', 'fretta':'Fretta',
                         'ncs5.5k':'Fretta', 'zermatt':'Fretta',
                         'ncs5k':'Skywarp', 'ncs4k':'Scapa',
                         'ncs1k':'Rosco',
                         'iosxrwb-xgs':'iosxrwb-xgs'}

modes               = ['eem', 'pam', 'ondemand']
operations          = ['add-and-trigger',
                       'add-replace',
                       'add-update',
                       'collection-status',
                       'delete',
                       'delete-all',
                       'display',
                       'display-all',
                       'display-all-event',
                       'display-all-pattern',
                       'display-eem-log',
                       'trigger']
on_lindt         = False

def IsIdentifierExist(json_data, identifier):
    for k, v in json_data.iteritems():
        if k == identifier:
            return True
    return True

def VerifyInputs(args, json_data):
    json_data = {}
    mode = getattr(args, 'mode')
    operation = getattr(args, 'operation')

    if mode not in modes:
        print('Please specify select eem|pam|ondemand')
        return False

    if operation not in operations:
        print("Please specify type of operation: -oper|--operation <%s>" % '|'.join(operations))
        return False

    if mode == 'eem':
        keyword = getattr(args, 'keyword', '')
        subpattern = getattr(args, 'subpattern', '')
        identifier = getattr(args, 'identifier', '')

        if operation == 'add-update' or \
           operation == 'add-and-trigger' or \
            operation == 'delete' or \
            operation == 'display':
            if (keyword is None):
                print('For %s %s operation, keyword is needed' % (mode, operation))
                return False

        if operation == 'add-update':
            if (subpattern == '' or subpattern is None):
                print('For %s %s operation, subpattern is needed' % (mode, operation))
                return False

            elif (identifier is None):
                print('For %s %s, identifier is needed' % (mode, operation))
                return False

            elif not IsIdentifierExist(json_data, identifier):
                print('For %s %s operation, identifier is not defined in EDCD command databse' % (mode, operation))
                return False

            elif not IsIdentifierExist(json_data, identifier):
                print('For %s %s operation, identifier is not defined in EDCD command databse' % (mode, operation))
                return False

        if operation == 'delete':
            if (identifier is not None):
                print('For %s %s operation, identifier is not needed' % (mode, operation))
                return False

        if operation == 'delete-all' or \
             operation == 'display-all':
            if (keyword is not None) or \
               (subpattern is not None) or \
               (identifier is not None):
                print("For %s %s operation, none of keyword, sub-pattern or identifier is not needed" % (mode,operation))
                return False

        if operation == 'display':
            if (subpattern is None) and \
                (identifier is not None):
                print('For %s %s operation, subpattern is needed when identifier is specified' % (mode, operation))
                return False

        if operation == 'trigger' or \
           operation == 'add-and-trigger':
            syslog = getattr(args, 'syslog', '')
            if (keyword is None):
                print('For %s trigger operation, --keyword is needed' % mode)
                return False

            if (syslog is None):
                print('For %s trigger operation, --syslog is needed' % mode)
                return False
            return True

    elif mode == 'ondemand':
        identifier = getattr(args, 'identifier', '')
        exec_commands = getattr(args, 'exec_commands', '')
        #collection_status = getattr(args, 'collection-status', False)

        if operation == 'add-update' or \
           operation == 'add-and-trigger':
            if exec_commands is None:
                print('For %s %s operation, commands (-cmd|--exec_commands) is needed' % (mode, operation))
                return False

        if operation == 'add-update' or \
           operation == 'add-and-trigger' or \
           operation == 'delete' or \
           operation == 'display':
            if identifier is None:
                print('For %s %s operation, identifier is needed' % (mode, operation))
                return False

        if operation == 'delete-all' or \
              operation == 'display-all' or \
              operation == 'collection-status':
            if (identifier is not None) or\
               (exec_commands is not None):
                print("For %s %s operation, neither identifier nor commands is needed" % (mode,operation))
                return False

        if operation == 'trigger':
            if (identifier is None):
                print("For %s %s operation, identifier is needed" % (mode,operation))
                return False
            if (exec_commands is not None):
                print("For %s %s operation, commands is not needed" % (mode,operation))
                return False

    elif mode == 'pam':
        identifier = getattr(args, 'identifier', '')
        event = getattr(args, 'event', '')
        process = getattr(args, 'process', '')
        pattern = getattr(args, 'pattern', '')

        if process is not None and \
           pattern is not None:
            print("For %s %s operation, '-p <process>' and '-t <pattern>' are mutually exclusive" % (mode, operation))
            return False

        if operation == 'add-update':
            if identifier is None:
                print('For %s %s operation, specify identifier (-i)' % (mode, operation))
                return False

        if operation == 'add-update' or \
           operation == 'delete':
            if (event != 'syslog') and \
               (pattern is not None):
                print("For %s %s operation, '-e syslog' is needed if -pattern is specified'" % (mode, operation))
                return False
            elif (event == 'syslog') and \
                 (pattern is None):
                print("For %s %s operation, '-pattern' is needed if -e syslog is specified'" % (mode, operation))
                return False
            elif (process is not None or \
                  pattern is not None) and \
                  (event == ''):
                print("For %s %s operation, '-e <event>' is needed if -p <process> or -t <pattern> is specified'" % (mode, operation))
                return False

        if operation == 'add-update':
            if event == '':
                print("For %s %s operation, '-e <event> is needed" % (mode, operation))
                return False

            elif (process is None) and \
                 (pattern is None): 
                print("For %s %s operation, specify '-p <process>' or '-t <pattern>'" % (mode, operation))
                return False

        if operation == 'delete-all' or \
             operation == 'display-all':
            if (identifier is not None) or \
               (event != '') or \
               (process is not None) or \
               (pattern is not None):
                print("For %s %s operation, -i, -e, -p, or -t is not needed" % (mode,operation))
                return False

    return True

def InitializeArgs():
    opt_debug = argparse.ArgumentParser(add_help = False)

    ###################
    #eem mode operations
    ###################
    opt_eem_oper = argparse.ArgumentParser(add_help = False)
    opt_eem_oper.add_argument('--operation',
                           help    = 'eem mode operations',
                           choices = [ 'add-and-trigger',
                                       'add-update',
                                       #'add-replace',
                                       'delete',
                                       'delete-all',
                                       'display',
                                       'display-all',
                                       'display-eem-log',
                                       'trigger'],
                           default = '')

    ###################
    #ondemand mode operations
    ###################
    opt_ondemand_oper = argparse.ArgumentParser(add_help = False)
    opt_ondemand_oper.add_argument('--operation',
                           help    = 'ondemand mode operations',
                           choices = [ 'add-update',
                                       'add-and-trigger',
                                       #'add-replace',
                                       'collection-status',
                                       'delete',
                                       'delete-all',
                                       'display',
                                       'display-all',
                                       'trigger'],
                           default = '')

    ###################
    #pam mode operations
    ###################
    opt_pam_oper = argparse.ArgumentParser(add_help = False)
    opt_pam_oper.add_argument('--operation',
                           help    = 'pam mode operations',
                           choices = [ 'add-update',
                                       #'add-replace',
                                       'delete',
                                       'delete-all',
                                       'display',
                                       'display-all',
                                       'display-all-event',
                                       'display-all-pattern'],
                           default = '')

    ###################
    #common options
    ###################
    opt_debug.add_argument('-d', '--debug',
                           help    = 'run with debug enabled',
                           action  = 'store_true')
    opt_os = argparse.ArgumentParser(add_help = False)

    opt_identifier = argparse.ArgumentParser(add_help = False)
    opt_identifier.add_argument('-i', '--identifier',
                             help    = 'An identifier to link to CLIs',
                             metavar = '<identifier>')

    ###################
    #eem mode options
    ###################
    opt_eem_syslog_json = argparse.ArgumentParser(add_help = False)
    opt_eem_syslog_json.add_argument('--eem_syslog_json_file',
                             help    = 'override default location (default: ' + \
                                        PAM_EEM_SYSLOG_JSON + ')',
                             metavar = '<eem_syslog_json_file>',
                             default = PAM_EEM_SYSLOG_JSON)

    opt_eem_thottle_json = argparse.ArgumentParser(add_help = False)
    opt_eem_thottle_json.add_argument('--eem_throttle_json',
                             help    = 'override default location ((default: ' + \
                                        PAM_THROTTLE_JSON + ')',
                             metavar = '<eem_throttle_json>',
                             default = PAM_THROTTLE_JSON)

    opt_eem_log = argparse.ArgumentParser(add_help = False)
    opt_eem_log.add_argument('--eem_log_file',
                             help    = 'override default location ((default: ' + \
                                        PAM_EEM_SYSLOG_LOG + ')',
                             metavar = '<eem_log_file>',
                             default = PAM_EEM_SYSLOG_LOG)

    opt_keyword = argparse.ArgumentParser(add_help = False)
    opt_keyword.add_argument('--keyword',
                             help    = 'keyword (primary syslog pattern )',
                             metavar = '<keyword>')

    opt_subpat = argparse.ArgumentParser(add_help = False)
    opt_subpat.add_argument('--subpattern',
                             help    = 'sub-pattern (secondary syslog pattern )',
                             metavar = '<subpattern>')

    opt_syslog = argparse.ArgumentParser(add_help = False)
    opt_syslog.add_argument('--syslog',
                             help    = 'syslog message (used to search for CLI)',
                             metavar = '<syslog>')

    opt_throttle = argparse.ArgumentParser(add_help = False)
    opt_throttle.add_argument('-throttle', '--throttle_window',
                            help     = 'A throttle_window to control CLI\
                                        execution rate, --mode eem only',
                            metavar  = '<throttle_window>',
                            default  = 60)

    opt_eem_trigger = argparse.ArgumentParser(add_help = False)
    opt_eem_trigger.add_argument('--trigger',
                             help    = 'trigger CLI execution (via EEM agent)',
                             action  = 'store_true',
                             default = False)

    ###################
    #ondemand mode options
    ###################
    opt_cmd = argparse.ArgumentParser(add_help = False)
    opt_cmd.add_argument('-cmd', '--exec_commands',
                           help   = "A list of commands, separated by ';'",
                          metavar = '<exec_commands>')

    opt_ondemand_json = argparse.ArgumentParser(add_help = False)
    opt_ondemand_json.add_argument('--cmd_json_file',
                             help    = 'override default location (default: ' + \
                                        PAM_CMD_JSON + ')',
                             metavar = '<cmd_json_file>',
                             default = PAM_CMD_JSON)

    opt_trigger = argparse.ArgumentParser(add_help = False)
    opt_trigger.add_argument('-tr', '--trigger',
                             help    = 'Trigger CLI execution (or data collection)',
                             action  = 'store_true',
                             default = False)

    ###################
    #pam mode options:
    ###################
    opt_event = argparse.ArgumentParser(add_help = False)
    opt_event.add_argument('-e', '--event',
                             help    = 'event name (used by built-in PAM agent)',
                             choices = [ 'cpuhog',
                                         'crash',
                                         'memleak',
                                         'syslog',
                                         'traceback'],
                             default = '')

    opt_event_json = argparse.ArgumentParser(add_help = False)
    opt_event_json.add_argument('--event_json_file',
                             help    = 'override default location (default: ' +\
                                        PAM_EVENT_JSON + ')',
                             metavar = '<event_json_file>',
                             default = PAM_EVENT_JSON)

    opt_logdir = argparse.ArgumentParser(add_help = False)
    opt_logdir.add_argument('--logdir',
                             help    = 'override Bazel-to-Jam out file',
                             metavar = '<logdir>',
                             default = '/misc/disk1/cisco_support/')

    opt_pattern = argparse.ArgumentParser(add_help = False)
    opt_pattern.add_argument('--pattern',
                             help    = 'syslog name (used by built-in PAM agent)\
                                        (used with pam -e syslog)',
                             metavar = '<pattern>')

    opt_pattern_json = argparse.ArgumentParser(add_help = False)
    opt_pattern_json.add_argument('--pattern_json_file',
                             help    = 'override default location (default: )' +\
                                        PAM_PATTERN_JSON + ')',
                             metavar = '<pattern_json_file>',
                             default = PAM_PATTERN_JSON)

    opt_process = argparse.ArgumentParser(add_help = False)
    opt_process.add_argument('--process',
                             help    = 'process name',
                             metavar = '<process>')

    ###################
    #misc options
    ###################
    opt_async = argparse.ArgumentParser(add_help = False)
    opt_async.add_argument('--do_async',
                           help   = "Run all CLIs in parallel (default: False,\
                                     only show tech run in parallel)",
                           action = 'store_true')

    opt_edcd_path = argparse.ArgumentParser(add_help = False)
    opt_edcd_path.add_argument('--edcd_path',
                             help    = 'override default location (default: ' + \
                                        ROUTER_EDCD_PATH + ')',
                             metavar = '<edcd_path>',
                             default = ROUTER_EDCD_PATH)

    opt_noRetainLogs = argparse.ArgumentParser(add_help = False)
    opt_noRetainLogs.add_argument('--noRetainLogs',
                          help    = "A list of files to be collected, the original\
                                     copies will be deleted after data collection,\
                                     separated by ';', e.g.,\
                                     /misc/disk/bgp_triage1.log;/misc/disk/bgp_triage2.log",
                          metavar = '<noRetainLogs>')

    opt_retainLogs = argparse.ArgumentParser(add_help = False)
    opt_retainLogs.add_argument('--retainLogs',
                          help    = "A list of files to be collected,\
                                     the original copies will be kept.\
                                     separated by ';', e.g.,\
                                     /etc/show_version.txt;/etc/build-info.txt",
                          metavar = '<retainLogs>')

    opt_tag = argparse.ArgumentParser(add_help = False)
    opt_tag.add_argument('--tag',
                           help   = 'A tag which is included in the tgz file',
                          metavar = '<tag>')

    opt_tgz = argparse.ArgumentParser(add_help = False)
    opt_tgz.add_argument('--do_tgz',
                            help     = 'Create tgz file (default: true)',
                            action   = 'store_true',
                            default  = True)

    ###################
    # Primary arg parser
    ###################
    ap  = argparse.ArgumentParser(parents = [ opt_debug ])
    sub = ap.add_subparsers(dest = 'mode')

    ###################
    # 'eem' sub-command
    ###################
    eem = sub.add_parser('eem',
                         parents = [ opt_async,
                                     opt_debug,
                                     opt_edcd_path,
                                     opt_eem_oper,
                                     opt_eem_log,
                                     opt_eem_syslog_json,
                                     opt_eem_thottle_json,
                                     opt_eem_trigger,
                                     opt_identifier,
                                     opt_keyword,
                                     opt_logdir,
                                     opt_noRetainLogs,
                                     opt_ondemand_json,
                                     opt_retainLogs,
                                     opt_subpat,
                                     opt_syslog,
                                     opt_tag,
                                     opt_throttle,
                                     opt_tgz ],
                         help    = 'create metadata for EEM operations')

    ###################
    # 'ondemand' sub-command
    ###################
    ondemand = sub.add_parser('ondemand',
                         parents = [ opt_async,
                                     opt_debug,
                                     opt_edcd_path,
                                     opt_cmd,
                                     opt_identifier,
                                     opt_logdir,
                                     opt_noRetainLogs,
                                     opt_ondemand_json,
                                     opt_ondemand_oper,
                                     opt_retainLogs,
                                     opt_trigger,
                                     opt_tag,
                                     opt_tgz ],
                         help    = 'create commands EDCD metadata, and/or trigger execution')

    ###################
    # 'pam' sub-command
    ###################
    pam = sub.add_parser('pam',
                         parents = [ opt_async,
                                     opt_debug,
                                     opt_edcd_path,
                                     opt_event,
                                     opt_event_json,
                                     opt_identifier,
                                     opt_logdir,
                                     opt_noRetainLogs,
                                     opt_ondemand_json,
                                     opt_pam_oper,
                                     opt_pattern,
                                     opt_pattern_json,
                                     opt_process,
                                     opt_retainLogs,
                                     opt_syslog,
                                     opt_tag,
                                     opt_tgz ],
                         help    = 'create EDCD metadata for built-in PAM function')

    return ap.parse_args()

def get_os_type():
    cmdline = ReadCommandLine()
    operSys = 'XR'
    if 'vmtype' in cmdline:
        if cmdline['vmtype'] == 'xr-vm':
            operSys = 'XR'
        elif cmdline['vmtype'] == 'sysadmin-vm':
            operSys = 'Calvados'
    if "spitfire" in cmdline or \
           "ncs540l" in cmdline:
        operSys = 'XR'
    return operSys

def get_platform():
    cmdline = ReadCommandLine()
    if 'platform' in cmdline:
        platform = cmdline['platform'].lower()
        if platform in PLATFORMS:
            platform = PLATFORMS[platform]
    return platform

def VerifyCommand(command, on_lindt=False):
    if on_lindt:
        #print("Unable to verify command before adding since parser_helper is not working on spitfire")
        return True
    valid_optional_arguments = ['location', 'pid', 'jid', 'process']
    #skip admin shell command
    AdminShellRegex = r'(?i)^\s*admin\s+shell\s+'
    AdminShellMatches = re.match(AdminShellRegex, command)
    if AdminShellMatches != None:
        print("Admin shell command '%s' is not supported" % command)
        return False
    #skip danderous command that contains 'rm'
    shellRmRegex = r'(?i)\s*(^|(.*&&|;?))\s*rm\s+'
    shellRmMatches = re.match(shellRmRegex, command)
    if shellRmMatches != None:
        print("Command '%s' not allowed" % command)
        return False
    ShellRegex = r'(?i)^\s*shell\s+[\/]*\w+'
    ShellMatches = re.match(ShellRegex, command)
    if ShellMatches != None:
        return True

    regex = r'<(.*?)>'
    matches = re.findall(regex, command)
    if len(matches) > 0:
        for entry in matches:
            if entry not in valid_optional_arguments:
                print("Invalid optional argument '%s'. Valid options are: %s" % (entry, str(valid_optional_arguments)) )
                return False
        print("Warning: Accepting '%s' as valid command without verifying since it has optional arguments" % command)
        return True
    devnull = open(os.devnull, 'w')
    describe_command = 'describe ' + command
    try:
        out = subprocess.call(['/pkg/bin/parser_helper', describe_command], stdout=devnull, stderr=devnull)
        if out != 0:
            print("Rejecting command: %s" % command)
            return False
        return True
    except:
        print("Rejecting command: %s" % command)
        return False

def ReadJsonFile(filePath):
    if os.path.isfile(filePath):
        f = open(filePath, 'r')
        try :
            data = f.read()
            if not data or data == "undefined":
                data = "{}"
            #else:
            #data = json.dumps(data)
            data = data.replace('\'', '\\\'')
        finally:
            f.close()
    else :
        data = "{}"
    return json.loads(data)

def GetEemLog(eem_log_file, keyword, subpattern, syslog):
    """Get specific log entry and return in json format
       If all keys are empty, it will the last valid entry.
       Otherwise it will return any matched one.
       Search starts from latest entry.
    """
    empty_log_data = "{}"
    search_keys = ['keyword', 'subpattern', 'syslog']
    if os.path.exists(eem_log_file):
        with open(eem_log_file) as fd:
            for line in reversed(list(open(eem_log_file))):
                time_data = json.loads(line.strip())
                for k, log_data in time_data.iteritems():
                    if not any([kk in log_data for kk in search_keys]):
                        continue
                    if keyword != '':
                        if keyword != log_data['keyword']:
                            continue
                        elif subpattern != '' and \
                           subpattern != log_data['subpattern']:
                            continue
                        elif syslog != '' and \
                           syslog != log_data['syslog']:
                            continue
                        fd.close()
                        return log_data
                    elif subpattern != '':
                        if subpattern != log_data['subpattern']:
                            continue
                        elif syslog != '' and \
                           syslog != log_data['syslog']:
                            continue
                        fd.close()
                        return log_data
                    elif syslog != '':
                        if syslog != log_data['syslog']:
                            continue
                        fd.close()
                        return log_data
                    else:
                        fd.close()
                        return log_data
            fd.close()
            return json.loads(empty_log_data)
    else:
        return json.loads(empty_log_data)
    return json.loads(empty_log_data)

def ReadCommandLine():
    data = ''
    with open("/proc/cmdline", 'r') as f:
        data = f.read()
    data = data.split()
    out = {}
    for string in data:
        if '=' in string:
            stuff = string.split('=')
            key = stuff[0]
            value = stuff[1]
            out[key] = value
    return out

def GetVmIP():
    os.environ["PATH"] = "/pkg/bin:/pkg/sbin/:/usr/bin:/bin/:/usr/sbin:/sbin"
    os.environ["LD_LIBRARY_PATH"] = "/pkg/lib:/pkg/lib/cerrno:/pkg/lib/mib:/pkg/lib/spp_plugins"
    command = "show_platform_sysdb"
    p = subprocess.Popen([command, "-v"], stdout=subprocess.PIPE)
    vm_ip_out, err = p.communicate()
    regex = re.compile('\n+')
    buffer = re.sub(regex, '\n', vm_ip_out)
    regex = re.compile('[\x08\r\t]')
    buffer = re.sub(regex, '', buffer)
    lines = buffer.splitlines()
    to_ip=[]
#TODO
#Use LC for testing:   or "LC" in line:
    for line in lines:
        if "RSP" in line or "RP" in line:
            cols = line.split()
            to_ip.append(cols[6])
    command = '''/sbin/ifconfig | grep \"inet addr\" |grep \"Bcast:192.255.255.255\"'''
    p = subprocess.Popen(command, stdout=subprocess.PIPE, shell=True)
    ifconfig_out, err = p.communicate()
    index= [i for i, ip in enumerate(to_ip) if ip in ifconfig_out]
    to_ip.remove(to_ip[index[0]])
    return to_ip

def ScpFiles(to_ip, path, json_file):
    for ip in to_ip:
        command="mkdir -p %s" % path
        p=subprocess.Popen(["ssh", "%s" % ip, command], stdout=subprocess.PIPE,
                                          shell=False,stderr=subprocess.STDOUT)
        scp_cmd = "/usr/bin/scp {json_file} {ip}:{path}".format(json_file=json_file, path=path,ip=ip)
        p=subprocess.Popen(scp_cmd, stdout=subprocess.PIPE, shell=True)

def get_pam_event_data(args, platform, os, event, process):
    pam_json_file = getattr(args, 'event_json_file')
    pam_json_data = ReadJsonFile(pam_json_file)

    new_data    = {}
    cmd_json_data = ReadJsonFile(getattr(args, 'cmd_json_file'))
    cmd_identifiers = cmd_json_data.keys()
    if len(cmd_identifiers) == 0:
        return new_data

    process_data = {}
    prev_match_cnt = 0
    for _plt, v in pam_json_data.iteritems():
        match_cnt = 0
        if _plt not in ('All', 'ALL', platform):
            continue
        match_cnt += 2 if _plt == platform else match_cnt + 1
        for _os, vv in v.iteritems():
            if _os not in ('All', 'ALL', os):
                continue
            for _evt, vvv in vv.iteritems():
                if _evt not in ('All', 'ALL', event):
                    continue
                for _pr, vvvv in vvv.iteritems():
                    if _pr not in ('All', 'ALL', process):
                        continue
                    match_cnt += 4 if _pr == process else match_cnt + 3
                    #take the closest match
                    #      process match overrides 'All' process,
                    #      process match overrides platform,
                    #      platform match overrides 'All' platform,
                    if match_cnt > prev_match_cnt:
                        prev_match_cnt = match_cnt
                        process_data = vvvv

    if not process_data:
        return new_data

    out         = {}
    for k, v in process_data.iteritems():
        if k == 'identifier':
            continue
        out[k] = v
    if 'throttle_window' not in out:
        out['throttle_window'] = getattr(args, 'throttle_window')

    out['process'] = process
    new_data[identifier] = out
    if getattr(args, 'debug'):
        print json.dumps(new_data,indent=1)
    #print json.dumps(new_data,indent=1)
    return new_data
    #exit()

def get_pam_pattern_data(args, platform, os, syslog):
    new_data    = {}
    pam_json_file = getattr(args, 'pattern_json_file')
    pam_json_data = ReadJsonFile(pam_json_file)

    cmd_json_data = ReadJsonFile(getattr(args, 'cmd_json_file'))
    cmd_identifiers = cmd_json_data.keys()
    if len(cmd_identifiers) == 0:
        return new_data

    pam_identifiers = {}
    patList =[]
    pat_data = {}
    prev_pat_len = 0
    pat = ''
    for _plt, v in pam_json_data.iteritems():
        if _plt not in ('All', 'ALL', platform):
            continue
        for _os, vv in v.iteritems():
            if _os not in ('All', 'ALL', os):
                continue
            for _pat, vvv in vv.iteritems():
                _regex = r'' + _pat
                _matches = re.findall(_regex, syslog)
                if len(_matches) == 0:
                    continue
                #take the longest match
                if len(_pat) > prev_pat_len:
                    pat == _pat
                    prev_pat_len = len(_pat)
                    pat_data = vvv

    if not pat_data:
        return new_data

    out         = {}
    for k, v in pat_data.iteritems():
        if k == 'identifier':
            continue
        out[k] = v
    if 'throttle_window' not in out:
        out['throttle_window'] = getattr(args, 'throttle_window')

    out['pattern'] = pat
    new_data[identifier] = out
    if getattr(args, 'debug'):
        print json.dumps(new_data,indent=1)
    #print json.dumps(new_data,indent=1)
    return new_data
    #exit()

def get_eem_syslog_data(args, eem_json_data, keyword, syslog):
    new_data    = {}
    cmd_json_data = ReadJsonFile(getattr(args, 'cmd_json_file'))
    identifier = getattr(args, 'identifier')
    cmd_identifiers = cmd_json_data.keys()
    if len(cmd_identifiers) == 0:
        return new_data

    out         = {}
    commands    = []
    pat         = ""
    #print json.dumps(eem_json_data,indent=1)
    if keyword not in eem_json_data:
        return new_data
    data     = eem_json_data[keyword]
    patList  = data.keys()
    #take the longest match
    patList.sort(key=len, reverse=True)
    default_commands = ''
    match_pat = 'default'
    for pat in patList:
        if pat == "default":
            if 'throttle_window' in data[pat] and \
                       isinstance(data[pat]['throttle_window'], int):
                default_throttle_window = data[pat]['throttle_window']
            id = data[pat]['identifier']
            if id in cmd_identifiers:
                _cmds = cmd_json_data[id]['commands']
                default_commands = cmd_json_data[id]['commands']
                identifier = id
            continue
        _regex = r'' + pat
        _matches = re.findall(_regex, syslog)
        if len(_matches) == 0:
            continue
        match_pat = pat
        id = data[match_pat]['identifier']
        _commands = ''
        if id in cmd_identifiers:
            _commands = cmd_json_data[id]['commands']
            for cmd in _commands.split("\n"):
                if cmd not in commands:
                    commands.append(cmd)
            identifier = id
        if len(commands) > 0:
            break

    for cmd in default_commands.split("\n"):
        if cmd not in commands:
            commands.append(cmd)
    if len(commands) == 0:
        return new_data

    if type(data) != dict or \
             len(data) == 0:
        return new_data

    if match_pat == 'default' and \
             match_pat not in data:
        return new_data

    for k, v in data[match_pat].iteritems():
        if k in ('do_async', 'do_tgz'):
            #to make GO code happy:
            out[k] = str(v).lower()
        else:
            out[k] = v

    if getattr(args, 'tag', ''):
        out['tag'] = getattr(args, 'tag', '')
    if getattr(args, 'do_tgz', False):
        out['do_tgz'] = "true"
    if getattr(args, 'do_async', False):
        out['do_async'] = "true"
    if getattr(args, 'logdir', ''):
        logdir = getattr(args, 'logdir', '')
        _regex = r'^(/misc/disk1/|\s*[/]?harddisk:)'
        _matches = re.findall(_regex, logdir)
        if len(_matches) == 0:
            print("\nInvalid path (it must start with /misc/disk1/ - default is /misc/disk1/cisco_support/.\n")
            exit()
        out['logdir'] = logdir
    if getattr(args, 'retainLogs', ''):
        out['retainLogs'] = getattr(args, 'retainLogs', '')
    if getattr(args, 'noRetainLogs', ''):
        out['noRetainLogs'] = getattr(args, 'retainLogs', '')
    if getattr(args, 'debug'):
        for k in ONDEMAND_ATTRS:
            print("field[k=%s]=%s" % (k, out[k]))

    if 'throttle_window' not in out:
        out['throttle_window'] = default_throttle_window

    out['commands'] = ""
    out['shell_commands'] = ""
    for cmd in commands:
        if out['commands'] == "":
            out['commands'] += cmd
            out['shell_commands'] += 'xr_cli ' + cmd
        else:
            out['commands'] += '\n' + cmd
            out['shell_commands'] += '\nxr_cli ' + cmd

    out['keyword'] = keyword
    out['sub_pattern'] = match_pat
    new_data[identifier] = out
    if getattr(args, 'debug'):
        print json.dumps(new_data,indent=1)
    #print json.dumps(new_data,indent=1)
    #exit()
    return new_data

def check_throtle(args, eem_data, eem_throttle_file_path):
    _commands = ""
    if getattr(args, 'debug'):
        print json.dumps(eem_data,indent=1)
    keyword = getattr(args, 'keyword')
    throttle_window = getattr(args, 'throttle_window')
    sub_pattern = ""
    for k, v in eem_data.iteritems():
        if 'commands' in eem_data[k]:
            _commands = eem_data[k]['commands']
        if 'throttle_window' in eem_data[k] and \
                    isinstance(eem_data[k]['throttle_window'], int):
            throttle_window = eem_data[k]['throttle_window']
        if 'sub_pattern' in eem_data[k]:
            sub_pattern = eem_data[k]['sub_pattern']
    if _commands == "":
        return -1

    commands = _commands.split("\n")
    commands.sort()
    _commands = ""
    for cmd in commands:
        _commands =  _commands + ";" + cmd if _commands else cmd

    throttled = 0
    for file in (eem_throttle_file_path, PAM_EEM_SYSLOG_LOG):
        dir = os.path.dirname(file)
        if not os.path.exists(dir):
            try:
                os.mkdir(dir, 0o777)
            except:
                print("Unabl to create '%s'" % dir)

    if not os.path.isfile(eem_throttle_file_path):
        """ throttle log """
        sha = hashlib.sha1()
        sha.update(_commands)
        hexdigest = sha.hexdigest()
        hash_data = {}
        cur_time = time.time()

        hash_data[hexdigest] = int(cur_time)
        f = open(eem_throttle_file_path, 'w')
        fcntl.lockf(f, fcntl.LOCK_EX)
        f.write(json.dumps(hash_data, sort_keys=True, indent=1, separators=(',', ': ')))
        fcntl.lockf(f, fcntl.LOCK_UN)
        f.close()

        to_ip = GetVmIP()
        if not on_lindt and len(to_ip) > 0:
            try:
                ScpFiles(to_ip, ROUTER_EDCD_PATH, eem_throttle_file_path)
            except ValueError as verr:
                print("Copy %s to other RPs failed (error: %s)" % (eem_throttle_file_path, verr))
        throttled = 0

        """ update eem log """
        timestamp = datetime.datetime.now()
        timestamp_str = timestamp.strftime("%Y-%m-%d-%H:%M:%S.%f")
        syslog = getattr(args, 'syslog', '').strip().replace("\"", "\\\"")
        line = "{\"" + timestamp_str + "\": {\"keyword\": \"" + keyword + "\", "
        line += "\"subpattern\": \"" + sub_pattern.replace("\"", "\\\"") + "\", "
        line += "\"throttle_window\": \"" + str(throttle_window) + "\", "
        line += "\"commands\": \"" + _commands.replace("\"", "\\\"") + "\", "
        line += "\"syslog\": \"" + syslog + "\"}}"

        fd = open(PAM_EEM_SYSLOG_LOG, 'a')
        fcntl.lockf(fd, fcntl.LOCK_EX)
        fd.write(line + "\n")
        fcntl.lockf(fd, fcntl.LOCK_UN)
        fd.close()

        if not on_lindt and len(to_ip) > 0:
            try:
                ScpFiles(to_ip, CISCO_SUPPORT_PATH, PAM_EEM_SYSLOG_LOG)
            except ValueError as verr:
                print("Copy %s to other RPs failed (error: %s)" % (PAM_EEM_SYSLOG_LOG, verr))

    else:
        f = open(eem_throttle_file_path, 'r')
        try :
            data = f.read()
            if not data or data == "undefined":
                return 0
            data = data.replace('\'', '\\\'')
        finally:
            f.close()

        sha = hashlib.sha1()
        sha.update(_commands)
        hexdigest = sha.hexdigest()
        hash_data = json.loads(data)
        cur_time = time.time()
        throttle_window = int(throttle_window) * 60
        for k, v in hash_data.iteritems():
            if k == hexdigest:
                delta = int(cur_time) - int(v)
                if delta < int(throttle_window):
                   throttled = 1
                break

        """ eem log """
        to_ip = GetVmIP()
        if throttled:
            remaining_delta = throttle_window - int(delta)
            timestamp = datetime.datetime.now()
            timestamp_str = timestamp.strftime("%Y-%m-%d-%H:%M:%S.%f")
            syslog = getattr(args, 'syslog', '').strip().replace("\"", "\\\"")
            line = "{\"" + timestamp_str + "\": {\"keyword\": \"" + keyword + "\", "
            line += "\"subpattern\": \"" + sub_pattern.replace("\"", "\\\"") + "\", "
            line += "\"throttle_window\": \"" + str(throttle_window) + "\", "
            line += "\"remaining_window\": \"" + str(remaining_delta) + "\", "
            line += "\"skipped_commands\": \"" + _commands.replace("\"", "\\\"") + "\", "
            line += "\"syslog\": \"" + syslog + "\"}}"

            fd = open(PAM_EEM_SYSLOG_LOG, 'a')
            fcntl.lockf(fd, fcntl.LOCK_EX)
            fd.write(line + "\n")
            fcntl.lockf(fd, fcntl.LOCK_UN)
            fd.close()
            if not on_lindt and len(to_ip) > 0:
                try:
                    ScpFiles(to_ip, CISCO_SUPPORT_PATH, PAM_EEM_SYSLOG_LOG)
                except ValueError as verr:
                    print("Copy %s to other RPs failed (error: %s)" % (PAM_EEM_SYSLOG_LOG, verr))
            return throttled
        else:
            timestamp = datetime.datetime.now()
            timestamp_str = timestamp.strftime("%Y-%m-%d-%H:%M:%S.%f")
            syslog = getattr(args, 'syslog', '').strip().replace("\"", "\\\"")
            line = "{\"" + timestamp_str + "\": {\"keyword\": \"" + keyword + "\", "
            line += "\"subpattern\": \"" + sub_pattern.replace("\"", "\\\"") + "\", "
            line += "\"throttle_window\": \"" + str(throttle_window) + "\", "
            line += "\"commands\": \"" + _commands.replace("\"", "\\\"") + "\", "
            line += "\"syslog\": \"" + syslog + "\"}}"

            fd = open(PAM_EEM_SYSLOG_LOG, 'a')
            fcntl.lockf(fd, fcntl.LOCK_EX)
            fd.write(line + "\n")
            fcntl.lockf(fd, fcntl.LOCK_UN)
            fd.close()
            if not on_lindt and len(to_ip) > 0:
                try:
                    ScpFiles(to_ip, CISCO_SUPPORT_PATH, PAM_EEM_SYSLOG_LOG)
                except ValueError as verr:
                    print("Copy %s to other RPs failed (error: %s)" % (PAM_EEM_SYSLOG_LOG, verr))

        """ update throttle log """
        hash_data[hexdigest] = cur_time
        f = open(eem_throttle_file_path, 'w')
        fcntl.lockf(f, fcntl.LOCK_EX)
        f.write(json.dumps(hash_data, indent=1))
        fcntl.lockf(f, fcntl.LOCK_UN)
        f.close()

        if not on_lindt and len(to_ip) > 0:
            try:
                ScpFiles(to_ip, ROUTER_EDCD_PATH, eem_throttle_file_path)
            except ValueError as verr:
                print("Copy %s to other RPs failed (error: %s)" % (eem_throttle_file_path, verr))

    return throttled

