#! /usr/bin/env python
# Copyright (c) 2015 by cisco Systems, Inc.
# All rights reserved.
#

import sys
import commands

SMU = ["SMU"]
rpm_conflict_list = list()
rpm_set = list()
#first argument in argv is binary name
def sanitize(argv):
    for rpm in argv[1:]:
        diff = 0
        is_smu = 0
        pkg_type    = commands.getoutput("rpm -qp --qf %{packagetype} " + (rpm))

        if (pkg_type in SMU):
            is_smu = 1

        if is_smu != 1:
            pkg_name  = commands.getoutput("rpm -qp --qf %{name} " + (rpm))
            if (pkg_name in rpm_set): 
                rpm_conflict_list.append(pkg_name)
            else :
                rpm_set.append(pkg_name)


def main(argv):
    sanitize(argv)

if __name__ == '__main__':
    main(sys.argv)    
    print ' '.join(rpm_conflict_list)
    
