##------------------------------------------------------------------
 # context_lib.tcl
 #
 # Copyright (c) 2000-2007, 2009 by Cisco Systems, Inc.
 # All rights reserved.
##------------------------------------------------------------------

namespace eval ::cisco::eem {
    namespace export context_save context_retrieve
}

namespace eval ::cisco::eem {
    namespace export context_save context_retrieve
}

proc ::cisco::eem::context_save {ctxt {pattern *}} {
    return [::cisco::eem::context_save $ctxt $pattern]
}
proc ::cisco::eem::context_retrieve {ctxt {var ""} {index_if_array ""}} {
    return [::cisco::eem::context_retrieve $ctxt $var $index_if_array]
}

# ::cisco::eem::context_save(ctxt, pattern)
# save Tcl variables in current and global namespaces
proc ::cisco::eem::context_save {ctxt {pattern *}} {
    global _cerrno _cerr_sub_num _cerr_sub_err _cerr_posix_err _cerr_str

    foreach a [uplevel info vars $pattern] {
    	if {[uplevel array exists $a]} {
	    set is_array($a)  1
	    set var_arr($a)  [uplevel array get $a]
    	} else {	
	    set is_array($a)  0
            set var_arr($a)  [uplevel set $a] 
    	}
    }

    appl_setinfo key var_arr_$ctxt data [array get var_arr] 
    if {$_cerrno != 0} {
        set msg [format "component=%s; subsys err=%s; posix err=%s;\n%s" $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
        return -code error $msg
    }

    appl_setinfo key is_array_$ctxt data [array get is_array]
    if {$_cerrno != 0} {
        set msg [format "component=%s; subsys err=%s; posix err=%s;\n%s" $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
        return -code error $msg
    }
}

# ::cisco::eem::context_retrieve(ctxt, var, index_if_array)
# get saved Tcl variables in current and global namespaces
proc ::cisco::eem::context_retrieve {ctxt {var ""} {index_if_array ""}} {
    global _cerrno _cerr_sub_num _cerr_sub_err _cerr_posix_err _cerr_str

    array set arr_info [appl_reqinfo key var_arr_$ctxt]
    if {$_cerrno != 0} {
        set msg [format "component=%s; subsys err=%s; posix err=%s;\n%s" $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
        return -code error $msg
    }

    set var_arr_strlist $arr_info(data)
    array set arr_info [appl_reqinfo key is_array_$ctxt]    
    if {$_cerrno != 0} {
        set msg [format "component=%s; subsys err=%s; posix err=%s;\n%s" $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
        return -code error $msg
    }

    set is_array_strlist $arr_info(data)
    array set var_arr $var_arr_strlist
    array set is_array $is_array_strlist

    if {$var == ""} {
        # case 1: retrieve the whole var table
	return $var_arr_strlist
    }

    # check if var is in context
    set varlist [array names var_arr]
    set index [lsearch -exact $varlist $var]
    if {$index == -1} {
        return -code error "var is not in context"
    }

    if {$is_array($var) == 1 && $index_if_array != ""} {
	# case 2: retrieve an array element
        array set vararr $var_arr($var)
        return $vararr($index_if_array)
    } else {
	# case 3: retrieve a scalar var or a whole array
    	return $var_arr($var)
    }
}
