::cisco::eem::event_register_timer cron name diag_cmds cron_entry $_cron_entry_diag maxrun_sec 900

#------------------------------------------------------------------
# HA modeling policies in EEM
#
# Jan, 2004, Joel Luth
#
# Copyright (c) 2004-2005, 2009-2010 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

# register for cron timer using user-defined cron entry

#
# errorInfo gets set by namespace if any of the auto_path directories do not
# contain a valid tclIndex file.  It is not an error just left over stuff.
# So we set the errorInfo value to null so that we don't have left
# over errors in it.
#
set errorInfo ""

#
# Hardcode a few options so they don't need to be configured in the router env
#
if {![info exists _email_server]} {
    # MX records for cisco.com
    set _email_server "128.107.250.141"
    # sj-inbound-0 is pref 10, others are pref 20
    # sj-inbound-0.cisco.com  internet address = 128.107.250.141
    # proxy5.cisco.com        internet address = 64.103.36.137
    # proxy6.cisco.com        internet address = 64.104.252.245
    # proxy9.cisco.com        internet address = 192.135.250.71
    # sj-inbound-1.cisco.com  internet address = 128.107.250.142
    # sj-inbound-2.cisco.com  internet address = 128.107.250.143
    # sj-inbound-3.cisco.com  internet address = 128.107.250.144
    # sj-inbound-4.cisco.com  internet address = 128.107.250.145
}
if {![info exists _email_from]} {
    set _email_from "customer@cisco.com"
}
if {![info exists _email_to]} {
    set _email_to "q-field-report@cisco.com"
}
if {![info exists _email_cc]} {
    set _email_cc ""
}
if {![info exists _domainname]} {
    set _domainname "cisco.com"
}

# This is only used in the e-mail subject line
# We run commands by looping through the cmd_list list
set _show_cmd "Diagnostic Commands"

# Set the list of commands to run
set cmd_list [list \
		"sh proc blocked" \
		"sh version" \
		"sh hfr" \
		"sh event manager environment" \
		"sh event manager policy available" \
		"sh event manager policy registered" \
		"sh interfaces" \
		"sh controllers" \
		"sh filesystem" \
		"sh lpts ifib brief" \
		"sh lpts pifib brief" \
		"sh context all location all" \
		"sh environment all" \
		"sh redundancy detail" \
		"sh proc abort location all" \
		"sh event manager metric hardware location all" \
		"sh memory summary location all" \
		"run top_procs -M -n20 -D -i1 -l all" \
		"run top_procs -n20 -D -i1 -l all" \
		"sh proc blocked" \
		]

### running-config includes usernames and passwords, security risk to include it here
###		"sh running-config" \
### proc mem loc all sometimes binds up when memory leaks encountered, replaced with top_procs -M
###		"sh process memory location all" \

# check if all the env variables we need exist
# If any of them do not exist, print out an error msg and quit
#if {![info exists _email_server]} {
#    set result \
#	"Policy cannot be run: variable _email_server has not been set"
#    error $result $errorInfo
#}
#if {![info exists _email_from]} {
#    set result \
#	"Policy cannot be run: variable _email_from has not been set"
#    error $result $errorInfo
#}
#if {![info exists _email_to]} {
#    set result \
#	"Policy cannot be run: variable _email_to has not been set"
#    error $result $errorInfo
#}
#if {![info exists _email_cc]} {
#    set result \
#	"Policy cannot be run: variable _email_cc has not been set"
#    error $result $errorInfo
#}
#if {![info exists _show_cmd]} {
#    set result \
#        "Policy cannot be run: variable _show_cmd has not been set"
#    error $result $errorInfo
#}


namespace import ::cisco::eem::*
namespace import ::cisco::lib::*

#
# errorInfo gets set by namespace if any of the auto_path directories do not
# contain a valid tclIndex file.  It is not an error just left over stuff.
# So we set the errorInfo value to null so that we don't have left
# over errors in it.
#
set errorInfo ""

#query the event info and log a message
array set arr_einfo [event_reqinfo]

if {$_cerrno != 0} {
    set result [format "component=%s; subsys err=%s; posix err=%s;\n%s" \
        $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
    error $result 
}

global timer_type timer_time_sec 
set timer_type $arr_einfo(timer_type)
set timer_time_sec $arr_einfo(timer_time_sec)

#log a message
set msg [format "timer event: timer type %s, time expired %s" \
        $timer_type [clock format $timer_time_sec]]

action_syslog priority info msg $msg
if {$_cerrno != 0} {
    set result [format "component=%s; subsys err=%s; posix err=%s;\n%s" \
	$_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
    error $result 
}

# Open a CLI FD
if [catch {cli_open} result] {
	error $result $errorInfo
} else {
	array set cli1 $result
}

# Loop through the command list (cmd_list), executing each command
foreach command $cmd_list {

	# 1. execute the show command
	#if [catch {cli_exec $cli1(fd) "en"} result] {
	#	error $result $errorInfo
	#}
	set msg [format "FM executing command \"%s\"..." $command]
	action_syslog priority info msg $msg
	if {$_cerrno != 0} {
		set result [format "component=%s; subsys err=%s; posix err=%s;\n%s" \
		$_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
		error $result
	}

	if [catch {cli_exec $cli1(fd) $command} result] {
		error $result $errorInfo
	} else {
		# set cmd_output $result
		set tmp_cmd_output $result
	}
 
	# 2. log the success of the CLI command 
	# Need better error checking before we ca do this

	# 3. Drain the FD to be sure we got everything from the command output
	set drain_result [cli_read_drain $cli1(fd)]
	append tmp_cmd_output $drain_result

	append cmd_output "\nXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX "
	append cmd_output $command
	append cmd_output " XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n"
	append cmd_output $tmp_cmd_output

	# Add a slight pause between commands
	after 200
}
# End of loop through cmd_list

# Close the CLI
after 1000
if [catch {cli_close $cli1(fd) $cli1(tty_id)} result] {
	error $result $errorInfo
}

# 3. send the email out
set routername [info hostname]
if {[string match "" $routername]} {
    error "Host name is not configured"
}

if [catch {smtp_subst [file join $tcl_library email_template_cmd.tm]} result] {
    error $result $errorInfo
}

if [catch {smtp_send_email $result} result] {
    error $result $errorInfo
}
