::cisco::eem::event_register_timer cron name crontimer1 cron_entry "0 0 * * 0-6"

#------------------------------------------------------------------
# EEM policy which triggers every Midnight and emails a process crash
# history report to a user.
#
# July 2005, Cisco EEM team
#
# Copyright (c) 2005-2006, 2011 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

### The following EEM environment variables are used:
###
### _email_server (mandatory)          - A Simple Mail Transfer Protocol (SMTP)
###                                      mail server used to send e-mail.
### Example: _email_server               mailserver.customer.com
###
### _email_from (mandatory)            - The address from which e-mail is sent.
### Example: _email_from                 devtest@customer.com
###
### _email_to (mandatory)              - The address to which e-mail is sent.
### Example: _email_to                   engineering@customer.com
###
### _email_cc (optional)               - The address to which the e-mail must
###                                      be copied.
### Example: _email_cc                   manager@customer.com
###

# check if all the env variables we need exist
# If any of them doesn't exist, print out an error msg and quit
if {![info exists _email_server]} {
    set result \
	"Policy cannot be run: variable _email_server has not been set"
    error $result $errorInfo
}
if {![info exists _email_from]} {
    set result \
	"Policy cannot be run: variable _email_from has not been set"
    error $result $errorInfo
}
if {![info exists _email_to]} {
    set result \
	"Policy cannot be run: variable _email_to has not been set"
    error $result $errorInfo
}
if {![info exists _email_cc]} {
     #_email_cc is an option, must set to empty string if not set.
     set _email_cc ""
}

namespace import ::cisco::eem::*
namespace import ::cisco::lib::*

#query the event info and log a message
array set arr_einfo [event_reqinfo]

if {$_cerrno != 0} {
    set result [format "component=%s; subsys err=%s; posix err=%s;\n%s" \
        $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
    error $result 
}

global timer_type timer_time_sec 
set timer_type $arr_einfo(timer_type)
set timer_time_sec $arr_einfo(timer_time_sec)

#log a message
set msg [format "timer event: timer type %s, time expired %s" \
	$timer_type [clock format $timer_time_sec]] 
action_syslog priority info msg $msg
if {$_cerrno != 0} {
    set result [format "component=%s; subsys err=%s; posix err=%s;\n%s" \
	$_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
    error $result 
}

# query the crash history, 
array set arr1 [sys_reqinfo_crash_history] 

if {$_cerrno != 0} {
    set result [format "component=%s; subsys err=%s; posix err=%s;\n%s" \
        $_cerr_sub_num $_cerr_sub_err $_cerr_posix_err $_cerr_str]
    error $result 
}

# if query successful
# 0. add the crash info table header to email text
# For ION at this point leave out version: 
# set txt [format "%-10s%-12s%-10s%-30s%-10s%-s\n" "Jid" "Version" \
#        "Exit_stat" "Crash_time" "Restarts" "Name"]
set txt [format "%-10s%-10s%-30s%-10s%-s\n" "Jid" \
        "Exit_stat" "Crash_time" "Restarts" "Name"]

# 1. for each process record, if the process crashed during the past 
#    24 hours, append this process record to email text 
foreach rec $arr1(rec_list) {
    array set rec_arr $rec
	
    if {$rec_arr(crash_time_sec) < [clock scan "24 hours ago"]} {
	continue
    }
    
    append txt [format "%-10s%-10s%-30s%-10s%-s\n" $rec_arr(job_id) \
      $rec_arr(exit_status) \
      [clock format $rec_arr(crash_time_sec)] \
      $rec_arr(respawn_count) $rec_arr(name)]

     #append txt [format "%-10s%-12s%-10s%-30s%-10s%-s\n" $rec_arr(job_id) \
     # $rec_arr(version_id) $rec_arr(exit_status) \
     # [clock format $rec_arr(crash_time_sec)] \
     # $rec_arr(respawn_count) $rec_arr(name)]



}

# 2. send the email out as the daily process crash report
set routername [info hostname]
if {[string match "" $routername]} {
    error "Host name is not configured"
}

if [catch {smtp_subst [file join $tcl_library email_template_chs.tm]} result] {
    error $result $errorInfo
}
if [catch {smtp_send_email $result} result] {
    error $result $errorInfo
}
