#!/usr/bin/perl

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# script to parse metadata used by vxr
# 
# Dec 2017, Jieming Wang
# 
# Copyright (c) 2016-2019 by Cisco Systems, Inc.
# All rights reserved.
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

my $sample_input = <<END;
{
"mounts_communts": "<{\\"<path>\\": \\"<lab-server-name>\\"}",
"mounts": [
            {"/auto/tftpboot/": ""},
            {"/auto/auto_ng_auto/": ""},
            {"/auto/cafy/": "ott2lab-as3"}
           ],
"scripts": [
            {"/auto/tftpboot/script1": {
               "execution_order": 1,
               "execution_server": ""}
            },
            {"/auto/auto_ng_auto/script2": {
               "execution_order": 2,
               "execution_server": "ott2lab-as3"}
            }
           ]
}
END

use Cwd;
use strict;
use warnings;
use File::Basename;
use File::Copy;
use JSON::PP;
use Getopt::Std;
use vars qw/ %opt /;
getopts( "i:d:", \%opt );

sub parse_metadata($$) {
    my $input      = shift || "/root/pam/test_metadata.json";
    my $output_dir = shift || "/root/pam/";

    
    my $cmd_info;
    my %isSeen;
    if (!open(FD, "$input")) {
        return 0;
    }
    my $output = "";
    while (my $line = <FD>) {
        $line =~ s/\r//g;
        $output .= $line;
    }
    close(FD);

    #print "output=$output\n";
    my $dec = decode_json $output;
    #use Data::Dumper;
    #print Dumper($dec);

    if (defined($dec->{mounts})) {
        my $mounts = $dec->{mounts};
        if (open(WD, ">$output_dir/mounts.txt")) {
            foreach my $mnt_data (@{$mounts}) {
                my ($mnt, $server) = keys(%$mnt_data);
                print WD "$mnt,$mnt_data->{$mnt}\n";
            }
            close(WD);
        }
    }
    #print "Scripts-----\n";
    if (defined($dec->{scripts})) {
        my $scripts = $dec->{scripts};
        if (open(WD, ">$output_dir/scripts.txt")) {
            foreach my $script_data (@{$scripts}) {
                my ($script, $data) = keys(%$script_data);
                $data = $script_data->{$script};
                my $order = $data->{execution_order};
                my $server = $data->{execution_server};
                print WD "$script,$order,$server\n";
            }
            close(WD);
        }
    }
    return 1;
} ;# sub parse_metadata($$)

my $input      = $opt{i} || "/root/pam/test_metadata.json";
my $output_dir = $opt{d} || "/root/pam/";

if ((!defined($input)) || (! -f $input)) {
    exit(0);
}

my $ret = parse_metadata($input, $output_dir);

exit(0);

