#!/bin/sh

#A sample script to perform rsync from active RP to standby RP

src_dir=/misc/disk1/scripts/
dst_dir=/misc/disk1/scripts/

myname=$(/pkg/bin/hostname|sed '{s#.*_node##;}')

/pkg/bin/show_platform_sysdb -v|grep FINAL|awk '{print $1, $7}'|while read node ip
do
    _node=$(echo $node|sed '{s#/#_#g;}')
    is_rp=$(echo $node|egrep -i "R[S]*P")
    if [ -z "$is_rp" ]
    then
        continue
    fi
    if [ $_node != $myname ]
    then
        echo "Perform rsync from $mynode:$src_dir to $node:$dst_dir"
        rsync -arvz -e ssh $src_dir/* $ip:$dst_dir/
    fi
done
