#!/usr/bin/python

import argparse
import json
import os
import re
import subprocess
from   subprocess import Popen, PIPE, call
import sys

os.environ["PATH"] = "/pkg/bin:/pkg/sbin/:/usr/bin:/bin/:/usr/sbin:/sbin"
os.environ["LD_LIBRARY_PATH"] = "/pkg/lib:/pkg/lib/cerrno:/pkg/lib/mib:/pkg/lib/spp_plugins"

admin_command = "/pkg/bin/install_exec_sysadmin "
admin_cli_wrapper = "/harddisk:/scripts/admin_cli_wrapper.py"
xr_admin_cli = "/pkg/sbin/admin-cli-proxy-xr_run_cmd"

'''
There are two ways to import pam_edcd_utils:
1) export PYTHONPATH=/pkg/bin/"
2) using the following
'''
if '/pkg/bin/' not in sys.path:
    sys.path.append('/pkg/bin/')
import pam_edcd_utils


if __name__ == '__main__':
    parser  = argparse.ArgumentParser()
    parser.add_argument('-d', '--debug',
                        help    = "Enable debug",
                        action  = 'store_true')

    parser.add_argument('-m', '--mode',
                        help    = "Execution mode: config, exec, or shell command",
                        choices = ['config',
                                   'exec',
                                   'shell'],
                        default = '')

    parser.add_argument('-c', '--cli',
                          help    = 'CLI to be executed or configured',
                          metavar = '<cli>',
                          default = '')

    os.environ['USER'] = 'root'
    args = parser.parse_args()

    DEBUG = args.debug
    if args.mode is None:
        parser.print_help()
        sys.exit(2)
    mode = args.mode

    if args.cli == '':
        parser.print_help()
        sys.exit(2)
    cli = args.cli

    #invoke install_exec_admin to execute remotely
    if mode == "config":
        command = admin_command + " \"" + admin_cli_wrapper
        command += " -m config"
        command += " -c \\\""
        new_cli = ""
        for c in cli.split(";"):
            command += c + "\n"
        command += " \\\"\""

    elif mode == "exec":
        command = admin_command + " \"" + admin_cli_wrapper
        command += " -m exec "
        command += " -c \\\"" + cli + " \\\"\""

    elif mode == "shell":
        command = admin_command + " \"" + admin_cli_wrapper
        command += " -m shell "
        command += " -c \\\"" + cli + " \\\"\""

    if DEBUG:
        print("command = %s" % command)

    p = subprocess.Popen(command, stdout=subprocess.PIPE, shell=True)
    output, err = p.communicate()
    if err != None:
        print ("Failed to execute '%s', errro=%s" % (cli, err))
    else:
        for o in output.split("\n"):
            if re.findall("connected from 127", o):
                continue
            print("%s" % o)
    exit()

    '''
    example code to get last eem log:
    '''
    if 0:
      eem_log_file = "/misc/disk1/cisco_support/pam_eem_syslog.log"
      keyword = ''
      subpattern = ''
      syslog = ''
      '''This will retrive the last log'''
      log_data = pam_edcd_utils.GetEemLog(eem_log_file, keyword, subpattern, syslog)

