#!/pkg/bin/perl
#------------------------------------------------------------------
# compare_np_counters.pl - Script to collect and compare NP counters
#
# Copyright (c) 2013 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

my $num_iters = 3;
my $interval = 1;

my $which_node = "all";
my $which_np = "all";

my @prm_np_show_arg = ($ARGV[2]);
my ($num_iters, $interval) = ($ARGV[0], $ARGV[1]);

my $cur_iter = 1;

my @node_array;

my %node_hash;
my %np_hash;
my %counter_hash;
my @counter_value_array;
my @counter_rate_array;



my $node_name;
my $np_name;
my $counter_name;
my $counter_value;
my $counter_rate;

my $counter_index = 0;

my $max_counter_name_len = 0;

printf("\n");
$| = 1;  # auto-flush buffer
while ($cur_iter <= $num_iters) {
    print "Collecting counters for iteration $cur_iter of $num_iters.\n";
    open(PS, "prm_np_show counters @prm_np_show_arg |");
   
    $node_name = "";
    $np_name = "";
    $counter_name = "";

    my $check_np = 0;
    my $check_counter = 0;
    
    while (<PS>) {
    
        if (/^\s+Node: (.*):/) {
            # Node changed
	    $node_name = $1;
	    if ($node_name eq $which_node || $which_node eq "all") {
	        $check_np = 1;
	    } else {
	        $check_np = 0;
		$check_counter = 0;
	    }
        }

	if (/^\s*Show global stats counters for (.*),/ && $check_np == 1) {
	    # NP changed
	    $np_name = $1;
	    if ($np_name ne $which_np && $which_np ne "all") {
	        $check_counter = 0;
	    } else {
	        $check_counter = 1;
        	my @np_list = {};
          	    if (!exists $node_hash{$node_name}) {
        	        # Node not added to db
        	        @np_list = ($np_name);
        		push(@node_array, $node_name);
        		push(@{$node_hash{$node_name}}, $np_name);
        		#print "Node $node_name added to DB\n";
        		#print "NP $np_name added to $node_name\n";
        	    } else {
        	        my $np_hash_key = "${node_name}_${np_name}";
        		if (!exists $np_hash{$np_hash_key}) {
        		    # Node is present, but NP found for first time
        
        		    # Insert NP in node hash
        		    @np_list = ($node_hash{$node_name});
        		    push(@np_list, $np_name);
        		    push(@{$node_hash{$node_name}}, $np_name);
        
        		    # Initialize np hash
        		    @{$np_hash{$np_hash_key}} = ();
        		    #print "NP $np_name added to $node_name\n";
        
        		}
        	    }
        	    # Update the node hash
        	    #print "NP intermediate list: @{$node_hash{$node_name}}\n";
                 	    #@{$node_hash{$node_name}} = @np_list;
	    }
	}

	if (/^\s+(\d+)\s+(\w+)\s+(\d+)\s+(\d+)\s*$/ && $check_counter == 1) {
            #Counter
	    $counter_name = $2;
	    $counter_value = $3;
	    $counter_rate = $4;

	    #Check if counter already in hash
	    my $index;
	    my $counter_hash_key = "${node_name}_${np_name}_${counter_name}";
	    if (!exists $counter_hash{$counter_hash_key}) {
	        # Counter found for the first time.

		my $counter_len = length($counter_name);
		if ($counter_len > $max_counter_name_len) {
		    $max_counter_name_len = $counter_len;
		}

		# Add counter entry to np_hash
		my $np_hash_key = "${node_name}_${np_name}";
		push(@{$np_hash{$np_hash_key}}, $counter_name);

                # Allocate a free index in val/rate array and upate
		# the counter details
		$counter_hash{$counter_hash_key} = $counter_index;

		@{$counter_value_array[$counter_index]} = ();
		@{$counter_result_array[$counter_index]} = ();

		if ($cur_iter > 1) {
		    # This counter did not increment in previous iterations
		    my $i = 0;
		    for ($i = 1; $i < $cur_iter; $i++) {
		        push(@{$counter_value_array[$counter_index]}, 0);
			push(@{$counter_rate_array[$counter_index]}, 0);
		    }
		}

                $index = $counter_index;
		$counter_index++;
	    } else {
	        $index = $counter_hash{$counter_hash_key};
	    }
	    push (@{$counter_value_array[$index]}, $counter_value);
	    push(@{$counter_rate_array[$index]}, $counter_rate);
	    #print "Pushed value:$counter_value, rate:$counter_rate\n";
	}
    }
    close(PS);
    sleep($interval);
    $cur_iter = $cur_iter + 1;
    #print "\r";
}

# Now print the database
foreach $node_name (@node_array) {
    
    #print "################### $node_name ###############\n";

    my @np_array = @{$node_hash{$node_name}};
    foreach $np_name (@np_array) {

        print "\n\n############ $node_name - $np_name ###########\n";

        my $i = 0;
	# Print header line
	print("Name:  ");
	$i = length("Name");
	while ($i < $max_counter_name_len) {
	    print(" ");
	    $i++;
	}

        printf("%10s/%-4s", "Value", "Rate");

	my $i = 0;
	for ($i = 1; $i < $num_iters; $i++) {
	    printf("%10s/%-4s", "Diff", "Rate");
	}
	printf("%10s/%-4s", "Final", "Rate");
	printf("\n");

	my $np_key = "${node_name}_${np_name}";
	my @counter_array = @{$np_hash{$np_key}};
	foreach $counter_name (@counter_array) {

	    my $counter_key = "${np_key}_${counter_name}";
	    my $index = $counter_hash{$counter_key};

	    print "$counter_name:  ";
	    
	    my $counter_len = length($counter_name);
	    while ($counter_len < $max_counter_name_len) {
	        print " ";
		$counter_len++;
	    }

	    my @values_array = @{$counter_value_array[$index]};
	    my @rates_array = @{$counter_rate_array[$index]};

	    my $cur_value = 0;
	    for ($i = 0; $i < $num_iters; $i++) {
	        if ($values_array[$i] > $cur_value) {
		    printf("%10d/%-4d", ($values_array[$i] - $cur_value), $rates_array[$i]);
		    $cur_value = $values_array[$i];
		} else {
		    printf("%10s/%-4s", "--", "--");
		}

		if ($i == ($num_iters - 1)) {
		    # Last column. Display total results
		    printf("%10d/%-4d", $values_array[$i], $rates_array[$i]);
		}
	    }
	    print "\n";
	}
    }
}
