#/bin/sh
#
#------------------------------------------------------------------
# instcommon_rpm.sh:
#
# April 2014, Jithesh J
#
# Copyright (c) 2014-2015 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
#

if [ $# -lt 1 ]
then
    echo "Invalid script type"
    exit 1
fi

MIN_TS=0
MAX_TS=0
MIN_TS_FILE=''
MAX_TS_FILE=''

get_min_max_files() {
    file_path=$1
    lst_file_name=$2

    MIN_TS=0
    MAX_TS=0
    MIN_TS_FILE=''
    MAX_TS_FILE=''

    echo "$file_path" $lst_file_name

    tmp_file_1=/tmp/LATEST_FILE_1.$$.$RANDOM

    ls $file_path > $tmp_file_1

    if [ "$?" != "0" ]
    then
        echo "instcommon_rpm.sh: no files in $file_path"
        return 101
    fi

    cat $tmp_file_1 | sed 's/.*/&;&/' | sed 's/;.*_/;/' | sed 's/.x[m|s][l|d]//2' | sort -t';' -k2n > $lst_file_name

    if [ "$?" != "0" ]
    then
        echo "instcommon_rpm.sh: Error! Invalid file name format"
        cat $tmp_file_1
        rm -f $tmp_file_1
        return 102
    fi

    rm -f $tmp_file_1

    min_ts_file_tmp=`cat $lst_file_name | head -n1 | sed 's/;.*//'`
    min_ts_tmp=`cat $lst_file_name | head -n1 | sed 's/.*;//'`
    max_ts_file_tmp=`cat $lst_file_name | tail -n1 | sed 's/;.*//'`
    max_ts_tmp=`cat $lst_file_name | tail -n1 | sed 's/.*;//'`

    valid_ts_pattern="^[0-9]+$"
    if ! [[ $min_ts_tmp =~ $valid_ts_pattern ]] ; then
        echo "Invalid min time stamp"
        cat $lst_file_name
        return 103
    fi

    if ! [[ $max_ts_tmp =~ $valid_ts_pattern ]] ; then
        echo "Invalid max time stamp"
        cat $lst_file_name
        return 104
    fi

    MIN_TS_FILE=$min_ts_file_tmp
    MIN_TS=$min_ts_tmp
    MAX_TS_FILE=$max_ts_file_tmp
    MAX_TS=$max_ts_tmp

    return 0
}

script_type=$1

if [ "$script_type" == "LATEST_FILE" ]
then
    echo "Entry LATEST_FILE"

    if [ $# -ne 3 ]
    then
        echo "Invalid input path and destination folder"
        exit 2
    fi

    v1_compat_files_dir=$2
    dest_folder=$3

    echo "Folders $v1_compat_files_dir $dest_folder"

    v1_xml_min_ts=0
    v1_xml_min_ts_file=''
    v1_xsd_min_ts=0
    v1_xsd_min_ts_file=''

    v1_xml_max_ts=0
    v1_xml_max_ts_file=''
    v1_xsd_max_ts=0
    v1_xsd_max_ts_file=''

    v2_xml_min_ts=0
    v2_xml_min_ts_file=''
    v2_xsd_min_ts=0
    v2_xsd_min_ts_file=''

    v2_xml_max_ts=0
    v2_xml_max_ts_file=''
    v2_xsd_max_ts=0
    v2_xsd_max_ts_file=''

    get_min_max_files "$v1_compat_files_dir/compat_mdata*.xml" $dest_folder/v1_xml_list

    ret=$?
    if [ $ret -ne 0 ]; then
        echo "Failed in v1 xml min max calculation"
        cat $dest_folder/v1_xml_list
        exit 3
    fi

    echo "V1 xml min max"
    echo $MIN_TS $MIN_TS_FILE $MAX_TS $MAX_TS_FILE

    v1_xml_min_ts=$MIN_TS
    v1_xml_min_ts_file=$MIN_TS_FILE
    v1_xml_max_ts=$MAX_TS
    v1_xml_max_ts_file=$MAX_TS_FILE

    get_min_max_files "$v1_compat_files_dir/compat_mdata*.xsd" $dest_folder/v1_xsd_list

    ret=$?
    if [ $ret -ne 0 ]; then
        echo "Failed in v1 xsd min max calculation"
        cat $dest_folder/v1_xsd_list
        exit 4
    fi

    echo "V1 xsd min max"
    echo $MIN_TS $MIN_TS_FILE $MAX_TS $MAX_TS_FILE

    v1_xsd_min_ts=$MIN_TS
    v1_xsd_min_ts_file=$MIN_TS_FILE
    v1_xsd_max_ts=$MAX_TS
    v1_xsd_max_ts_file=$MAX_TS_FILE


    get_min_max_files "$dest_folder/V2_files/compat_mdata*.xml" $dest_folder/v2_xml_list

    ret=$?
    if [ $ret -ne 0 ]; then
        echo "Failed in v2 xml min max calculation"
        cat $dest_folder/v2_xml_list
    else
        echo "V2 xml min max"
        echo $MIN_TS $MIN_TS_FILE $MAX_TS $MAX_TS_FILE

        v2_xml_min_ts=$MIN_TS
        v2_xml_min_ts_file=$MIN_TS_FILE
        v2_xml_max_ts=$MAX_TS
        v2_xml_max_ts_file=$MAX_TS_FILE
    fi

    get_min_max_files "$dest_folder/V2_files/compat_mdata*.xsd" $dest_folder/v2_xsd_list

    ret=$?
    if [ $ret -ne 0 ]; then
        echo "Failed in v2 xsd min max calculation"
        cat $dest_folder/v2_xsd_list
    else
        echo "V2 xsd min max"
        echo $MIN_TS $MIN_TS_FILE $MAX_TS $MAX_TS_FILE

        v2_xsd_min_ts=$MIN_TS
        v2_xsd_min_ts_file=$MIN_TS_FILE
        v2_xsd_max_ts=$MAX_TS
        v2_xsd_max_ts_file=$MAX_TS_FILE
    fi
 
    xml_file_to_pick=''
    xsd_file_to_pick=''

    if [ $v2_xml_min_ts -lt $v1_xml_min_ts ] ; then
        xml_file_to_pick=$v1_xml_max_ts_file
        xsd_file_to_pick=$v1_xsd_max_ts_file
    else
        xml_file_to_pick=$v2_xml_max_ts_file
        xsd_file_to_pick=$v2_xsd_max_ts_file
    fi

    echo "xml and xsd files to copy"
    echo $xml_file_to_pick $xsd_file_to_pick

    cp $xml_file_to_pick $xsd_file_to_pick $dest_folder

    ret=$?
    if [ $ret -ne 0 ]; then
        echo "Failed to copy latest file exiting"
        exit 7
    fi

    echo "Exiting LATEST_FILE" 
    exit 0
fi

if [ "$script_type" == "COMPAT_FILES_FRM_ISO" ]
then
    
    echo "Entry COMPAT_FILES_FRM_ISO"

    if [ $# -ne 3 ]
    then
        echo "Invalid parameter to COMPAT_FILES_FRM_ISO" 
        exit 2
    fi

    EXTRACT_COMPAT_INFO_MNT="/tmp/Compat_Validation_Mnt_Point"
    image_path=$2
    dest_folder=$3

    echo "Params: $image_path $dest_folder"

    umount $EXTRACT_COMPAT_INFO_MNT > /dev/null 2>&1
    rm -rf $EXTRACT_COMPAT_INFO_MNT

    mkdir -p $EXTRACT_COMPAT_INFO_MNT

    if [ "$?" != "0" ]
    then
        echo "Canot create mount directory $EXTRACT_COMPAT_INFO_MNT"
        exit 3
    fi

    mount -o loop $image_path $EXTRACT_COMPAT_INFO_MNT

    if [ "$?" != "0" ]
    then
        echo "Mount command failed to mount iso $image_path "
        echo "mount point $EXTRACT_COMPAT_INFO_MNT"
        exit 4
    fi

    mkdir -p $dest_folder/V2_files

    if [ "$?" != "0" ]
    then
        echo "Canot create mount directory $dest_folder/V2_files"
        exit 5
    fi

    cp $EXTRACT_COMPAT_INFO_MNT/compat_mdata*.xml $dest_folder/V2_files/

    if [ "$?" != "0" ]
    then
        echo "Copy xml file $EXTRACT_COMPAT_INFO_MNT/compat_mdata*.xml failed"
        echo "Dest folder $dest_folder/V2_files"
        exit 6
    fi

    cp $EXTRACT_COMPAT_INFO_MNT/compat_mdata_*.xsd $dest_folder/V2_files/

    if [ "$?" != "0" ]
    then
        echo "Copy xsd file $EXTRACT_COMPAT_INFO_MNT/compat_mdata_*.xsd failed"
        echo "Dest $dest_folder/V2_files"
        exit 7
    fi

    umount $EXTRACT_COMPAT_INFO_MNT

    if [ "$?" != "0" ]
    then
        echo "Unmount failed on $EXTRACT_COMPAT_INFO_MNT"
        exit 8
    fi

    echo "Exit COMPAT_FILES_FRM_ISO"

fi


if [ "$script_type" == "COMPAT_FILES_FRM_NON_ISO" ]
then
    echo "Entry COMPAT_FILES_FRM_NON_ISO"

    if [ $# -ne 3 ]
    then
        echo "Invalid parameter to COMPAT_FILES_FRM_ISO"
        exit 2
    fi

    image_path=$2
    dest_folder=$3

    echo "Params: $2 $3"

    mkdir -p $dest_folder/V2_files

    if [ "$?" != "0" ]
    then
        echo "Cannot create destination dir $dest_folder/V2_files"
        exit 3
    fi

    tar --wildcards -C $dest_folder/V2_files -xvf $image_path compat_mdata_*.xml compat_mdata_*.xsd

    if [ "$?" != "0" ]
    then
        echo "Untar of compat mdata failed image: $image_path"
        echo "Dest Folder: $dest_folder/V2_files"
        exit 4
    fi

    echo "Exit COMPAT_FILES_FRM_NON_ISO"
fi


