##
 # dataplane_lc_config.pl
 #
 #------------------------------------------------------------------
 # Copyright (c) 2012 by Cisco Systems, Inc.
 # All rights reserved.
 # Author: Joshua Jodrey
 #------------------------------------------------------------------
 ##

# Interface arrays for each EP
# Format for each interface is: (type)(inteface #), e.g. TenGig2 (Note: GigE is used instead of GigabitEthernet for consistency)
@EP_20X1_interface_array =  ("GigE0",  "GigE1",  "GigE2",  "GigE3",  "GigE4",
                             "GigE5",  "GigE6",  "GigE7",  "GigE8",  "GigE9",
                             "GigE10", "GigE11", "GigE12", "GigE13", "GigE14",
                             "GigE15", "GigE16", "GigE17", "GigE18", "GigE19");
							
@EP_8X10_interface_array = ("TenGigE0", "TenGigE1", "TenGigE2", "TenGigE3",
							"TenGigE4",	"TenGigE5",	"TenGigE6", "TenGigE7");
@EP_4X10_EP_interface_array = ("TenGigE0", "TenGigE1", "TenGigE2", "TenGigE3");
@EP_2X10_EP_interface_array = ("TenGigE0", "TenGigE1");

@EP_2X40_interface_array = ("FortyGigE0", "FortyGigE1");
@EP_1X40_interface_array = ("FortyGigE0");

# This maps the "show platform" string to the matching linecard mapping
%LC_string_map = (
	"A9K-24x10GE-SE" => \%colossus_map,
	"A9K-24x10GE-TR" => \%colossus_map,
	
	"A9K-36x10GE-SE" => \%supercolossus_map,
	"A9K-36x10GE-TR" => \%supercolossus_map,

	"A9K-2x100GE-SE" => \%juggernaut_map,
	"A9K-2x100GE-TR" => \%juggernaut_map,
	
	# Two Network Processors (NP) on the card
	"A9K-MOD80-SE" => \%weaponx_2NP_map,
	"A9K-MOD80-TR" => \%weaponx_2NP_map,
	
	# Four Network Processors (NP) on the card
	"A9K-MOD160-SE" => \%weaponx_4NP_map,
	"A9K-MOD160-TR" => \%weaponx_4NP_map,
	
	"ASR9001-LC" => \%ironman_map
);

# This maps the "show platform" string to the matching ether-plug mapping
%EP_string_map = (
	"A9K-MPA-20X1GE" => \@EP_20X1_interface_array,
                        
	"A9K-MPA-8X10GE" => \@EP_8X10_interface_array,
	"A9K-MPA-4X10GE" => \@EP_4X10_EP_interface_array,
    "A9K-MPA-2X10GE" => \@EP_2X10_EP_interface_array,
	                    
    "A9K-MPA-2X40GE" => \@EP_2X40_interface_array,
    "A9K-MPA-1X40GE" => \@EP_1X40_interface_array
);

%weaponx_2NP_map = (
	"NAME" => "2NP Weapon-X",

	#Interface mappings for each supported interface type per NP (PORT_NUMS order is important!)
	#Each EP is connected to one NP, so all of the interfaces feed into that one NP
	#                                                               GigE0 GigE1 ...
	"20_GigE_EP"		=> {"IF_TYPE" => "QSGMII", "PORT_NUMS" => [ '16', '17', '18', '19', '40', '41', '42', '43', '20', '21', '24', '25', '26', '27', '48', '49', '50', '51', '28', '29' ]},
	#8x10GE not supported on 2NP card
	"4_TenGigE_EP" 		=> {"IF_TYPE" => "RXAUI",  "PORT_NUMS" => [ '4', '5', '6', '7' ]},
	"2_TenGigE_EP" 		=> {"IF_TYPE" => "RXAUI",  "PORT_NUMS" => [ '4', '5' ]},
	#2x40GE not supported on 2NP card
	"1_FortyGigE_EP" 	=> {"IF_TYPE" => "XLAUI",  "PORT_NUMS" => [ '0' ]},
	
	"NP0" => {"IF_TYPE" => "INTERLAKEN",  "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA0", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '0' ]},
	"NP1" => {"IF_TYPE" => "INTERLAKEN",  "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA1", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '2' ]},
	
	"FIA0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '3', '4' ]},
	"FIA1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '24', '0' ]},
	
	"XBAR0" =>  {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '9', '12', '14', '16', '7', '11', '15', '17' ], "CONNECTS_TO" => "RSP"}
);

%weaponx_4NP_map = (
	"NAME" => "4NP Weapon-X",

	#Interface mappings for each supported interface type per NP (PORT_NUMS order is important!)
	#Each EP is connected to two NPs, so the interfaces are split across each NP
	#                                                               GigE0 GigE1  ...
	#                                                              GigE10 GigE11 ...
	"20_GigE_EP"		=> {"IF_TYPE" => "QSGMII", "PORT_NUMS" => [ '16', '17', '18', '19', '40', '41', '42', '43', '20', '21' ]},
	"8_TenGigE_EP" 		=> {"IF_TYPE" => "XAUI",   "PORT_NUMS" => [ '4', '5', '6', '7' ]},
	"4_TenGigE_EP" 		=> {"IF_TYPE" => "XAUI",   "PORT_NUMS" => [ '4', '5' ]},
	"2_TenGigE_EP" 		=> {"IF_TYPE" => "XAUI",   "PORT_NUMS" => [ '4' ]},
	"2_FortyGigE_EP"   => {"IF_TYPE" => "XLAUI",   "PORT_NUMS" => [ '0' ]},
	"1_FortyGigE_EP"   => {"IF_TYPE" => "XLAUI",   "PORT_NUMS" => [ '0' ]},
	
	"NP0" => {"IF_TYPE" => "INTERLAKEN",  "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA0", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '0' ]},
	"NP1" => {"IF_TYPE" => "INTERLAKEN",  "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA1", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '1' ]},
	"NP2" => {"IF_TYPE" => "INTERLAKEN",  "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA2", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '2' ]},
	"NP3" => {"IF_TYPE" => "INTERLAKEN",  "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA3", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '3' ]},
	                                                    
	"FIA0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '3', '4' ]},
	"FIA1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '8', '5' ]},
	"FIA2" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '24', '0' ]},
	"FIA3" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '2', '1' ]},
	
	"XBAR0" =>  {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '9', '12', '14', '16', '7', '11', '15', '17' ], "CONNECTS_TO" => "RSP"}
);

%juggernaut_map = (
	"NAME" => "Juggernaut",
	
	"HundredGigE0_0" => {"IF_TYPE" => "INTERLAKEN", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '10' ]},
	"NP3" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '10' ], "CONNECTS_TO" => "BRIDGE1_INGRESS", "PORT_IN" => [ '' ]},
	"BRIDGE1_INGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '' ], "CONNECTS_TO" => "FIA_COMPLEX_2_3_INGRESS", "PORT_IN" => [ '0', '1' ]},
	"FIA_COMPLEX_2_3_INGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0_PORT_1", "PORT_IN" => [ '3', '4', '2', '1' ]},
	"XBAR0_PORT_1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '3', '4', '2', '1' ], "CONNECTS_TO" => "FIA_COMPLEX_2_3_EGRESS", "PORT_IN" => [ '0', '1' ]},
	"FIA_COMPLEX_2_3_EGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "BRIDGE1_EGRESS", "PORT_IN" => [ '' ]},
	"BRIDGE1_EGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '' ], "CONNECTS_TO" => "NP2", "PORT_IN" => [ '10' ],},
	"NP2" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '10' ], "CONNECTS_TO" => "HundredGigE0_0"},

	
	"HundredGigE0_1" => {"IF_TYPE" => "INTERLAKEN", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '10' ]},
	"NP1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '10' ], "CONNECTS_TO" => "BRIDGE0_INGRESS", "PORT_IN" => [ '' ]},
	"BRIDGE0_INGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '' ], "CONNECTS_TO" => "FIA_COMPLEX_0_1_INGRESS", "PORT_IN" => [ '0', '1' ]},
	"FIA_COMPLEX_0_1_INGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0_PORT_0", "PORT_IN" => [ '8', '5', '24', '0' ]},
	"XBAR0_PORT_0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '8', '5', '24', '0' ], "CONNECTS_TO" => "FIA_COMPLEX_0_1_EGRESS",  "PORT_IN" => [ '0', '1' ]},
	"FIA_COMPLEX_0_1_EGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "BRIDGE0_EGRESS", "PORT_IN" =>[]},
	"BRIDGE0_EGRESS" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [], "CONNECTS_TO" => "NP0", "PORT_IN" => [ '10' ],},
	"NP0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '10' ], "CONNECTS_TO" => "HundredGigE0_1"}
);

%colossus_map = (
	"NAME" => "Colossus",
	
	# Interfaces to NPs
	"TenGigE0_0"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '6' ]},
	"TenGigE0_1"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '5' ]},
	"TenGigE0_2"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '4' ]},
	"TenGigE0_3"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '6' ]},
	"TenGigE0_4"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '5' ]},
	"TenGigE0_5"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '4' ]},
	"TenGigE0_6"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '6' ]},
	"TenGigE0_7"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '5' ]},
	"TenGigE0_8"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '4' ]},
	"TenGigE0_9"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '6' ]},
	"TenGigE0_10" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '5' ]},
	"TenGigE0_11" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '4' ]},
	"TenGigE0_12" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '6' ]},
	"TenGigE0_13" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '5' ]},
	"TenGigE0_14" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '4' ]},
	"TenGigE0_15" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '6' ]},
	"TenGigE0_16" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '5' ]},
	"TenGigE0_17" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '4' ]},
	"TenGigE0_18" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP6", "PORT_IN" => [ '6' ]},
	"TenGigE0_19" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP6", "PORT_IN" => [ '5' ]},
	"TenGigE0_20" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP6", "PORT_IN" => [ '4' ]},
	"TenGigE0_21" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP7", "PORT_IN" => [ '6' ]},
	"TenGigE0_22" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP7", "PORT_IN" => [ '5' ]},
	"TenGigE0_23" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP7", "PORT_IN" => [ '4' ]},
	                                                                    
	# NPs to FIA and FIA Port
	"NP0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA0", "PORT_IN" => [ '0' ], "PUNT_PORT" => [ '0' ]},
	"NP1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA0", "PORT_IN" => [ '1' ], "PUNT_PORT" => [ '1' ]},
	"NP2" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA1", "PORT_IN" => [ '1' ], "PUNT_PORT" => [ '2' ]},
	"NP3" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA1", "PORT_IN" => [ '0' ], "PUNT_PORT" => [ '3' ]},
	"NP4" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA2", "PORT_IN" => [ '0' ], "PUNT_PORT" => [ '4' ]},
	"NP5" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA2", "PORT_IN" => [ '1' ], "PUNT_PORT" => [ '5' ]},
	"NP6" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA3", "PORT_IN" => [ '1' ], "PUNT_PORT" => [ '6' ]},
	"NP7" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA3", "PORT_IN" => [ '0' ], "PUNT_PORT" => [ '7' ]},
	
	# FIAs to XBAR and XBAR Ports
	"FIA0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '3', '4' ]},
	"FIA1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '2', '1' ]},
	"FIA2" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '24', '0' ]},
	"FIA3" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '8', '5' ]},
	
	# End of Map
	"XBAR0" =>  {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '9', '12', '14', '16', '7', '11', '15', '17' ], "CONNECTS_TO" => "RSP"}
);

%supercolossus_map = (
	"NAME" => "SuperColossus",
	
	# Interfaces to NPs
	"TenGigE0_0"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '4' ]},
	"TenGigE0_1"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '8' ]},
	"TenGigE0_2"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '7' ]},
	"TenGigE0_6"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '6' ]},
	"TenGigE0_7"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '5' ]},
	"TenGigE0_8"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '9' ]},
	
	"TenGigE0_3"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '4' ]},
	"TenGigE0_4"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '8' ]},
	"TenGigE0_5"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '7' ]},
	"TenGigE0_9"  => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '6' ]},
	"TenGigE0_10" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '5' ]},
	"TenGigE0_11" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '9' ]},
	
	"TenGigE0_12" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '4' ]},
	"TenGigE0_13" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '8' ]},
	"TenGigE0_14" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '7' ]},
	"TenGigE0_18" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '6' ]},
	"TenGigE0_19" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '5' ]},
	"TenGigE0_20" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP2", "PORT_IN" => [ '9' ]},
	
	"TenGigE0_15" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '4' ]},
	"TenGigE0_16" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '8' ]},
	"TenGigE0_17" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '7' ]},
	"TenGigE0_21" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '6' ]},
	"TenGigE0_22" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '5' ]},
	"TenGigE0_23" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP3", "PORT_IN" => [ '9' ]},
	
	"TenGigE0_24" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '4' ]},
	"TenGigE0_25" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '8' ]},
	"TenGigE0_26" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '7' ]},
	"TenGigE0_30" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '6' ]},
	"TenGigE0_31" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '5' ]},
	"TenGigE0_32" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP4", "PORT_IN" => [ '9' ]},
	
	"TenGigE0_27" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '4' ]},
	"TenGigE0_28" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '8' ]},
	"TenGigE0_29" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '7' ]},	
	"TenGigE0_33" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '6' ]},
	"TenGigE0_34" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '5' ]},
	"TenGigE0_35" => {"IF_TYPE" => "XAUI", "CONNECTS_TO" => "NP5", "PORT_IN" => [ '9' ]},
	                                                                    
	# NPs to FIA and FIA Port
	"NP0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA5", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '0' ]},
	"NP1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA0", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '1' ]},
	"NP2" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA3", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '2' ]},
	"NP3" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA1", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '3' ]},
	"NP4" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA4", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '4' ]},
	"NP5" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11', '12' ], "CONNECTS_TO" => "FIA2", "PORT_IN" => [ '0', '1' ], "PUNT_PORT" => [ '5' ]},
	
	# FIAs to XBAR and XBAR Ports
	"FIA0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '3', '4' ]},
	"FIA1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '2', '1' ]},
	"FIA2" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '24', '0' ]},
	"FIA3" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '8', '5' ]},
	"FIA4" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '23', '25' ]},
	"FIA5" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '6', '10' ]},	
	
	# End of Map
	"XBAR0" =>  {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '9', '12', '14', '16', '7', '11', '15', '17' ], "CONNECTS_TO" => "RSP"}
);

%ironman_map = (
	"NAME" => "Ironman",
	
	#Interface mappings for each supported interface type per NP (PORT_NUMS order is important!)
	#Each EP is connected to two NPs, so the interfaces are split across each NP
	#                                                               GigE0 GigE1  ...
	"20_GigE_EP"		=> {"IF_TYPE" => "QSGMII", "PORT_NUMS" => [ '0', '1', '2', '3', '4', '5', '8', '9', '10', '11', '12', '13', '24', '25', '26', '27', '32', '33', '34', '35' ]},
	"4_TenGigE_EP" 		=> {"IF_TYPE" => "RXAUI",   "PORT_NUMS" => [ '4', '5', '6', '7' ]},
	"2_TenGigE_EP" 		=> {"IF_TYPE" => "RXAUI",   "PORT_NUMS" => [ '4', '6' ]},
	"1_FortyGigE_EP"   => {"IF_TYPE" => "XLAUI",   "PORT_NUMS" => [ '0' ]},
	
	# Interfaces to NPs
	"TenGigE0_0"  => {"IF_TYPE" => "RXAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '8' ]},
	"TenGigE0_1"  => {"IF_TYPE" => "RXAUI", "CONNECTS_TO" => "NP0", "PORT_IN" => [ '9' ]},
	"TenGigE0_2"  => {"IF_TYPE" => "RXAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '8' ]},
	"TenGigE0_3"  => {"IF_TYPE" => "RXAUI", "CONNECTS_TO" => "NP1", "PORT_IN" => [ '9' ]},
	
	# NPs to FIA and FIA Port
	"NP0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA0", "PORT_IN" => [ '0', '1' ]},
	"NP1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '11' ], "CONNECTS_TO" => "FIA1", "PORT_IN" => [ '0', '1' ]},
	
	# FIAs to XBAR and XBAR Ports
	"FIA0" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '3', '4' ]},
	"FIA1" => {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '0', '1' ], "CONNECTS_TO" => "XBAR0", "PORT_IN" => [ '2', '1' ]},
	
	# End of Map
	"XBAR0" =>  {"IF_TYPE" => "INTERLAKEN", "PORT_OUT" => [ '9', '12', '14', '16', '7', '11', '15', '17' ], "CONNECTS_TO" => "RSP"}
);
