#!/router/bin/python3

import sys
import os
import re
import time
import argparse
import struct
import socket


parser = argparse.ArgumentParser()
parser.add_argument('-i', '--intf', dest='intf', action='store', help='Source interface for the ping', required=True)
parser.add_argument('-a', '--addr', dest='addr', action='store', help='Destination IP address', required=True)

args = parser.parse_args()
destination_ip = args.addr
interface_name = args.intf

print (destination_ip)
print (interface_name)

interface = interface_name.replace('/','_')

lre = re.compile("([0-9].*)").split(interface_name)

if lre[0] == 'Bundle-Ether':
    short_intf = 'BE' 
elif lre[0] == 'TenGigE':
    short_intf = 'Te' 
elif lre[0] == 'GigabitEthernet':
    short_intf = 'Ge' 
elif lre[0] == 'BVI':
    short_intf = 'BV' 
elif lre[0] == 'HundredGigE':
    short_intf = 'Hu' 
elif lre[0] == 'FastEthernet':
    short_intf = 'Fa' 
elif lre[0] == 'MgmtEth':
    short_intf = 'Mg' 
elif lre[0] == 'PW-Ether':
    short_intf = 'PE' 
elif lre[0] == 'FourHundredGigE':
    short_intf = 'FH' 
elif lre[0] == 'TwoHundredGigE':
    short_intf = 'TH' 

short_intf = short_intf+lre[1]
print (short_intf)




print ("Converting Interface...................................................[OK]")
ping_success = False

ipv6_nd_entry_string = "show_ipv6_neighbors -I "+interface
ipv6_nd_idb_string = 'show_ipv6_idbinfo -I '+interface+' -d -N'
ipv6_interface_string = 'show_ipv6_interface -I '+interface+' -v default'

#### FOR EXR 
get_nodes_string = "im_show database -a | grep -E Node"
nodes = []
node_names = os.popen(get_nodes_string).read()
print (node_names)
node_names = node_names.split('\n')
for i in range(len(node_names)-1):
    node_names[i] = node_names[i].split(' ')[1]
    node_names[i] = 'node'+node_names[i].replace('/','_')
    nodes.append(os.popen('node_conversion -i '+node_names[i]).read())
    print (node_names[i])
	
print ("Getting Node Names.....................................................[OK]")
###############################################################################

print
print ('############')
print ('Checking IDB')
print ('############')

###############################################################################

count = len(nodes)
for i in range(len(nodes)):
    print
    print ("Location: "+node_names[i])
    ipv6_nd_idb = os.popen(ipv6_nd_idb_string+nodes[i]).read()
    print
    if "IDB" in ipv6_nd_idb:
        print ("Checking IPv6 ND IDB...................................................[OK]")
        count = count-1
        if (re.findall("IPV6 Interface: (Enabled|Disabled), IPV6: (Enabled|Disabled)", ipv6_nd_idb) != [('Enabled', 'Enabled')]):
            print ("IPv6 Enabled in ND IDB.................................................[ERROR]")
            print ("IPv6 Interface in ND IDB...............................................[ERROR]")
            print ("IPv6 State or Interface "+interface+", is Down, Please check if ipv6 is enabled/configured and interface is up !!!")
            print
            exit()
        else:
            print ("IPv6 Enabled in ND IDB.................................................[OK]")
            print ("IPv6 Interface in ND IDB...............................................[OK]")
#            print ("IDB found for "+interface+" and passed all the checks [OK]")

if count == len(nodes):
    print
    print ("IDB for "+interface+" not found at any location, check configuration !!!")
    exit()

## DAD ##


ipv6_interface  = os.popen(ipv6_interface_string).read()
#print ipv6_interface
if "ipv6 protocol is Up" not in ipv6_interface:
    print ("Ipv6 protocol is up....................................................[ERROR]")
    exit()
else:
    print ("IPv6 protocol is up....................................................[OK]")

if "[DUPLICATE][ND-DAD]" in ipv6_interface:
    ipv6_dad_failed = 'show_ipv6_nd_dadfail'
    res = os.popen(ipv6_dad_failed).read()
    print ("Ipv6 infterface DAD....................................................[ERROR]")
    print (res)
    exit()
else:
    print ("IPv6 interface DAD.....................................................[OK]")

###############################################################################

print
print ('########################')
print ('Checking MCAST entry')
print ('########################')

###############################################################################

ipv6_nd_entry = os.popen(ipv6_nd_entry_string).read()
res = re.findall(r'(.*)[Mcast adjacency].*REACH', ipv6_nd_entry)
if not res:
    print ("IPv6 ND Mcast Entry....................................................[ERROR]")
    print ("Interface Mcase entry not present for "+interface+" [FAIL]")
else:
    print ("IPv6 ND Mcast Entry....................................................[OK]")

###############################################################################

print
print ('####################')
print ('Analysing ND Packets ')
print ('####################')

clear_string = 'clear_ipv6_neighbors'
res = os.popen(clear_string).read()
print (res)
print ("Clearing ipv6 neighbors................................................[OK]")

clear_pack_string = 'clear_ipv6_packets -S all'
res = os.popen(clear_pack_string).read()
print ("Clearing ipv6 Packets..................................................[OK]")


###############################################################################
print
print ('####################')
print ('Ping the destination')
print ('####################')


ping_string = 'ping6 -p 0xf -z 0xa '+destination_ip
res = os.popen(ping_string).read()
print (res)
if re.findall('U', res):
    print ("IP not in subnet check config !!!")
    print
    exit()
if re.findall('!', res):
    ping_success = True
    print ("Ping successful........................................................[OK]")
    print ("\nPing is working fine !!!")
    exit()

####################################################################################

packet_string = 'show_ipv6_nd_packets -L all'
res = os.popen(packet_string).read()
print ("Getting packet output..................................................[OK]")
#print (res)

res1 = res.splitlines()
#print (res1)
pack_count = len(res1)
i = 0
NS_count = 0
NA_count = 0

####################################################################################

packet_string = 'show_ipv6_nd_packets -L all'
res = os.popen(packet_string).read()
print ("Getting packet output..................................................[OK]")
#print (res)

res1 = res.splitlines()
#print (res1)
pack_count = len(res1)
i = 0
NS_count = 0
NA_count = 0

while i < pack_count:
    line1 = (res1[i].split())
    i = i+1
    if (len(line1) > 4):
        if line1[1] == short_intf and line1[2] == 'NS' and line1[3] == 'SENT' and line1[8] == destination_ip :
            print ('Packet Entry Found')
#            print (line1)
            NS_count += 1
	          
if NS_count > 0:
    print ('Sent NS found')
    print ("Sent NS packets........................................................[OK]")
else:
    print ("Sent NS packets.........................................................[FAILED]")

i = 0
while i < pack_count:
    line2 = (res1[i].split())
    i = i+1
    if (len(line2) > 4):
        if line2[1] == short_intf and line2[2] == 'NA' and line2[3] == 'RECV' and line2[6] == destination_ip:
#            print (line2)
            NA_count += 1


if NA_count > 0:
    print ('Recieved NA found')
    print ("Recieved NA packets.....................................................[OK]")
else:
    print ("Recieved NA packets....................................................[FAILED]")

success_failure = 1
if NS_count > 0 and NA_count == 0 :
    print ('There is no response of NS packet sent to peer, Please check peer side if its receving NS and sending NA back')
    success_failure = 0 

if success_failure: 
    ipv6_nd_entry = os.popen(ipv6_nd_entry_string).read()
    print (ipv6_nd_entry)
    str = destination_ip+".*REACH.*" 
    res = re.findall(str, ipv6_nd_entry)
    if res:
        print ("Dynamic Entry for "+destination_ip+" added successfully [OK]")
        print
        exit()
    else:
        print ("Entry was not installed even after NA was received, contact ND team !!!")

###############################################################################
