proc get_linecards {} {

    set output [exec "show_platform"]
    set retList {}
    set lc 0
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]

    foreach line $lines {

        
        if {[regexp {PRP\((\S+)\)} [lindex $line 1] - string] && [regexp {IOS XR RUN} $line]} {
            if { [regexp -nocase "active" $string] } {
                 set arr(rp,active) [lindex $line 0]
            } else {
                set arr(rp,standby) [lindex $line 0]
            }
        }
        
        # ENXR 
        if {[regexp {(\S+) +RP +(\S+) +IOS XR RUN} $line - rp status ] } {
            # 0/0/CPU0        RP              N/A             IOS XR RUN      PWR,NSHUT,MON
            if {[regexp -nocase "active" $status]} {
                regsub -all "/" $rp "_" rp
                set rp "node$rp"
                set rp [exec node_conversion -i $rp]
                set arr(rp,active) $rp
            } elseif { [regexp -nocase "N/A" $status] } {
                regsub -all "/" $rp "_" rp
                set rp "node$rp"
                set rp [exec node_conversion -i $rp]
                set arr($rp,active) $rp
            } else {
                regsub -all "/" $rp "_" rp
                set rp "node$rp"
                set rp [exec node_conversion -i $rp]
                set arr($rp,standby) $rp
            }
        }

        if {[regexp {(\S+) +LC +(\S+) +IOS XR RUN} $line - lineCard status]} {
            # 0/2/CPU0        LC              GE              IOS XR RUN      PWR,NSHUT,MON
            regsub -all "/" $lineCard "_" lineCard
            set lineCard "node$lineCard"
            set lineCard [exec node_conversion -i $lineCard]
            set arr(linecards,$lc) $lineCard
            incr lc
        }
                
        # CRS
        if { [regexp {(\S+) +RP\(([a-zA-Z]+)\) +(\S+) +IOS XR RUN} $line - rp status] } {
            if {[regexp -nocase "active" $status]} {
                set arr(rp,active) $rp
            } else {
                set arr(rp,standby) $rp
            }
        }

        # 0/5/CPU0      MSC               Jacket Card        IOS XR RUN      PWR,NSHUT,MON
        if { [regexp {(\S+) +MSC +Jacket +Card +IOS XR RUN} $line - lineCard ] } {
            set arr(linecards,$lc) $lineCard
            incr lc
        }
            

        
        #C12k-LC 
        if {[regexp {L3LC} [lindex $line 1]] && [regexp {IOS XR RUN} $line]} {
            set arr(linecards,$lc) [lindex $line 0]
            ats_log -info " Line card $lc is [lindex $line 0]"
            incr lc
        }
        # ASR9000
        if {[regexp {(A9K-\S+)} [lindex $line 1] - string] && [regexp {IOS XR RUN} $line]} {
            if {[regexp -nocase "RSP" $string]} {
                if { [regexp -nocase "active" $string] } {
                    set arr(rp,active) [lindex $line 0]
                } else {
                    set arr(rp,standby) [lindex $line 0]
                }
            } else {
                set arr(linecards,$lc) [lindex $line 0]
            }
            ats_log -info " ASR Line card $lc is [lindex $line 0]"
            incr lc
        }

	# ASR9001  
        if {[regexp -- {(ASR9001-\S+)} [lindex $line 1] - string] && [regexp {IOS XR RUN} $line]} {
             # 0/RSP0/CPU0     ASR9001-RP(Active)        IOS XR RUN       PWR,NSHUT,MON
            if {[regexp -nocase "RP|RSP" $string]} {
                if {[regexp -nocase "active" $string]} {
                    set arr(rp,active) [lindex $line 0] 
                } else {
                    set arr(rp,standby) [lindex $line 0] 
                }
            }
        }
            
        if {[regexp -- {ASR9001-LC} [lindex $line 1]] && [regexp -- {IOS XR RUN} $line]} {
            set arr(linecards,$lc) [lindex $line 0]
            ats_log -info " ASR9001 Line card $lc is [lindex $line 0]"
            incr lc
        }
    }

    set arr(lc,count) $lc
    return [array get arr]

}

proc showVrfAll {} {
    set output [exec mpls_vpn_show -a]
    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 1 
    set saved_line ""
    set lVrf [list default]
    foreach line $lines {
        if {[regexp -- {^VRF +RD +RT +AFI +SAFI$} $line]} {
            # VRF                  RD                  RT                         AFI   SAFI     
            continue
        }
        if {[regexp -- {^(\S+) +(\d+:\d+)} $line - vrf_name rd]} {
            # blue                 965:2              
            incr idx
            set arr(vrf,$idx,name) $vrf_name
            lappend lVrf $vrf_name
            set arr(vrf,$idx,rd) $rd
        }
        if {[regexp -- {^ +(import|export) +(\d+\:\d+) +IPV4 +Unicast} $line - imp_exp rt_import]} {
            #                                 import  100:3               IPV4  Unicast  
            #                                 export  100:3               IPV4  Unicast  
            if {$imp_exp == "import"} {
                set arr(vrf,$idx,import_rt) $rt_import
            } else {
                set arr(vrf,$idx,export_rt) $rt_import
            }
        }
    }
    set arr(vrf,$idx) $idx
    return $lVrf
}

proc checkPrefVrf {lVrf pref} {
    set hexpref [ipToHex $pref]
    set ret 0
    set retVrf {}
    foreach vrf $lVrf {
        set output [exec show_ipv4_rib -X 0x1 -Y 0x1 -Z $vrf -V ________ -p $hexpref ipv4 $vrf ]
        if {[regexp -- {Routing entry for} $output]} {
            set ret 1
            lappend retVrf $vrf
        } 
    }
    
    if {$ret} {
        return $retVrf
    } else {
        return $ret
    }
}

proc ipToHex {ip} {
    # Convert ip address to hex   
    set lList {}
    foreach x [split $ip "."] {
        lappend lList [format %2.2x $x]
    }
    set hex [join $lList]
    regsub -all " " $hex "" hex
    return $hex
}

proc showMplsLsdForwarding {lbl loc bDet} {
    set lbl "0x[format %4.2x $lbl]"
    set output [exec mpls_lsd_fwd_show -b $lbl -e $lbl -Z ]
    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show mpls lsd forwarding labels $lbl    "
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }


    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 1 
    set saved_line ""
    set re(IPv6)    {(?:(?::|[[:xdigit:]]{1,4})+)}
    set re(IPv4)    {(?:\d+\.\d+\.\d+\.\d+)}
    set re(IP)      "(?:$re(IPv4)|$re(IPv6))"
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    set num_paths_found 0
    foreach line $lines {
        if {[regexp {([A-Za-z0-9/.]+), nh=(.*), lbl=(None|Unknown|[0-9]+)} $line \
                 match intf next_hop out_label]} {                 
            incr num_paths_found
            set ldp_fwd_array($prefix,out_labels) $out_label
            set ldp_fwd_array($prefix,next_hops) $next_hop
            set ldp_fwd_array($prefix,intfs)\
                $intf
        } 
        if {[regexp {^([0-9]+).*, ([.:[:xdigit:]]+)/([[:digit:]]+)\), (\d+) +Pa} $line match in_label prefix pfx_len paths] } {
            set prefix $prefix/$pfx_len
            set ldp_fwd_array(prefixes) $prefix
            set ldp_fwd_array($prefix,paths) $paths
            set ldp_fwd_array($prefix,in_label) $in_label
            if {$paths != 0} {
                lappend ldp_fwd_array(prefixes_with_paths) $prefix        
            }
        } else {
            # No prefix was found.  This probably means the end of the
            # output was found.  
        }
    }
    
    return [array get ldp_fwd_array]    
}

proc showRibIpv4 {vrf pref bDet} {

    set hex [ipToHex $pref]
    set output [exec show_ipv4_rib -X 0x1 -Y 0x1 -Z $vrf -V ________ -p $hex -3 ipv4 default]

    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show route vrf $vrf ipv4 $pref"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 0
    set saved_line ""
    set re(IPv6)    {(?:(?::|[[:xdigit:]]{1,4})+)}
    set re(IPv4)    {(?:\d+\.\d+\.\d+\.\d+)}
    set re(IP)      "(?:$re(IPv4)|$re(IPv6))"
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    foreach line $lines {
        # 200.12.1.2, from 102.0.0.1, via GigabitEthernet0/1/0/16
        if {[regexp -nocase {\[([0-9]+)/([0-9]+)\] via *([0-9a-f:]+), \
                                 *([0-9:]+), ([-a-z0-9\/\.:]+)} \
                 $line - distance metric fwd_addr age fwd_intf ] } {
            incr idx
            set arr($pref,$idx,fwd_addr) $fwd_addr
            set arr($pref,$idx,fwd_intf) $fwd_intf
            set arr($pref,$idx,metric) $metric
        }

        if {
            [regexp -nocase {via +"([0-9a-z\- _]+)", distance *(\d+), metric (\d+), type ([0-9a-z\- _]+)()} \
                 $line - id distance metric type tag] ||
            [regexp -nocase {via +"([0-9a-z\- _]+)", distance *(\d+), metric (\d+)()()} \
                 $line - id distance metric type tag] ||
            [regexp -nocase {tag +(\d+), +type +([0-9a-z\- _]+), +Traffic +Index +(\d+)} \
                 $line - tag type traffic_index] ||
            [regexp -nocase {tag *(\d+), type *([0-9a-z\- _]+)} \
                 $line - tag type] 
        } {
            set arr($pref,routing_protocol) $id
        }

        if {[regexp -nocase {^via ([0-9a-f:\.]+)} \
                 $line - fwd_addr] } {
            incr idx
            set arr($pref,$idx,fwd_addr) $fwd_addr
        }

        # not required ???
        #         if {[regexp -nocase {([0-9.]+), +from +([0-9.]+), +via (\S+)} $line - tunnel_ip router_id tunnel_id]} {
        #             incr idx
        #             set arr($pref,$idx,fwd_intf) $tunnel_id
        #         }
        
        if {[regexp -nocase {([0-9.]+), +from +([0-9.]+), +via +(\S+)} $line - ip rtr_id intf]} {
            incr idx
            set arr($pref,$idx,fwd_intf) $intf
            set arr($pref,$idx,via) $ip
            set arr($pref,$idx,router_id) $rtr_id
        }

        if {[regexp -nocase {([a-z]* +[a-z]*), via (\S+)} \
                 $line - type intf]} {
            incr idx
            set arr($pref,$idx,fwd_intf) $intf
        }
    }
    set arr($pref,idx) $idx
    return [array get arr]    
}


proc showCefIpv4BackUpDetail {vrf pref mask loc bDet} {
    # fib_show_command -t -O 0x0 -f default -P 03030303 -M 0x20 -T 0x2 -d -N 0 -b
    # show cef vrf def 3.3.3.3/32 backup detail location 0/0/CPU0
    set hexPref [ipToHex $pref]
    set hexMask "0x[format %2.2x $mask]"
    set arr(bNoBackUp) 0

    set output [exec fib_show_command -t -O 0x0 -f $vrf -P $hexPref -M $hexMask -d -N $loc -b]

    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show cef vrf $vrf ipv4 $pref backup detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    
    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 0 
    set src_idx 0
    set saved_line ""
    set re(IPv6)    {(?:(?::|[[:xdigit:]]{1,4})+)}
    set re(IPv4)    {(?:\d+\.\d+\.\d+\.\d+)}
    set re(IP)      "(?:$re(IPv4)|$re(IPv6))"
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    
    
    foreach line $lines {
        if {[regexp "No prefixes found" $line]} {
            set arr(bNoBackUp) 1 
        } 
        
        if {[regexp "($re(IP)|$re(IP)/\\d+), version (\\d+), priority (\\d+), flags (\\S+)(?:, flags2 (\\S+))?, source (\\S+)" $line - \
                 pfx ver prio flags1 flags2 src]} {
            # 3.3.3.3/32, version 54, priority 4294967295, flags 0x0, flags2 0x3, source lsd (5), ctx-flags 0xc1
            incr src_idx
            set arr($pfx,$src_idx,source) $src
            set arr(pfx) $pfx
        }

        if {[regexp  "via +(\\S+) \\($re(HEX_NUM)\\) $re(IP), weight (\\d+), class (\\d+)" $line - outIntf nh]} {
            # via  PO0/2/0/0 (0x1000500) 12.0.0.2, weight 0, class 0 [flags 0x400]
            incr idx
            set arr($pfx,$idx,outIntf) $outIntf
            set arr($pfx,$idx,nh) $nh
        }
        
        if {[regexp "Output labels {(\\S+)}" $line - out_lbl]} {
        # Output labels {24211}
            set ($pfx,$idx,out_label) $out_lbl
        }

        if {[regexp "Label count = (\\d+), src = (\\d+), label = (\\d+)" $line - lbl_count src lbl]} {
            #         Label count = 1, src = 5, label = 24112
            set arr($pfx,$src_idx,label_count) $lbl_count
            set arr($pfx,$src_idx,local_label) $lbl
        }
    }

    set arr($pfx,idx) $idx
    set arr($pfx,src_idx) $src_idx
    return [array get arr]

}    
proc showCefIpv4Detail {vrf pref mask loc bDet} {
    # fib_show_command -t -O 0x0 -P 66000001 -M 0x20 -T 0x2 -d 
    set hexPref [ipToHex $pref]
    set hexMask "0x[format %2.2x $mask]"

    
    
    set output [exec fib_show_command -t -O 0x0 -f $vrf -P $hexPref -M $hexMask -T 0x2 -d -N $loc]
    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show cef vrf $vrf ipv4 $pref detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 0 
    set saved_line ""
    set re(IPv6)    {(?:(?::|[[:xdigit:]]{1,4})+)}
    set re(IPv4)    {(?:\d+\.\d+\.\d+\.\d+)}
    set re(IP)      "(?:$re(IPv4)|$re(IPv6))"
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    set arr($pref,backup) 0
    foreach line $lines {
        if {[regexp {^\s*gateway array \((\S+)\) reference count\
                         (\d*), flags (\S+), source (\S+) \((\d+)\), (\d+) backups} $line - \
                 gateway_array ref_count flags source_type source_val bkup]} {
            # gateway array (0x71a4f790) reference count 1, flags 0x0, source rib (7), 0 backups
            set arr($pref,source) $source_type
            set arr($pref,backup) $bkup
        }
        
        if {[regexp {^(\d+.\d+.\d+.\d+|\d+.\d+.\d+.\d+/\d+), version (\d+), (attached)} $line \
                - prefix version source_type]} {
            #104.0.0.1/32, version 2395, attached, receive 
            set arr($pref,source) $source_type
        }

        if { [regexp "^ +via ($re(IP)|$re(IP)/\\d+), (\\S+), (\\d+) dependencies, weight (\\d+), class (\\d+|default)(?:, (backup|protected))?(?: \\\[flags (\\S+)\\\])?$" $line - via intf deps weight class type flags] } {
            # via 200.12.1.2/32, GigabitEthernet0/1/0/16, 4 dependencies, weight 0, class 0 [flags 0x0]
            incr idx
            set arr($pref,$idx,via) $via
            set arr($pref,$idx,outIntf) $intf
        }

        if { [regexp "^ +via ($re(IP)|$re(IP)/\\d+), (\\d+) dependencies, +(recursive)" $line - via deps type] } {
            # via 200.12.1.2/32, GigabitEthernet0/1/0/16, 4 dependencies, weight 0, class 0 [flags 0x0]
            set arr($pref,$idx,$idx,via) $via
            set arr($pref,$idx,dependencies) $deps
            set arr($pref,$idx,type) $type
        }

        if {[regexp "next hop ($re(IP)|$re(IP)/\\d+) via (\\d+)" $line - via lbl_loc]} {
            # next hop 101.0.0.1/32 via 24006/0/21
            set arr($pref,local_label) $lbl_loc
        }
        
        if {[regexp "next hop ($re(IP)|$re(IP)/\\d+) (\\S+) +labels imposed +\{(.*)\}" $line \
                 - next_hop outIntf labels_imposed]} {
            # next hop 200.24.2.1/32 Gi0/0/1/10   labels imposed {24004 24008}
            set arr($pref,$idx,labels_imposed) $labels_imposed
        }

        if {[regexp {local +label +(.*) +labels +imposed +\{(.*)\}} $line - local_label labels_imposed]} {
            set arr($pref,local_label) $local_label
            set arr($pref,$idx,labels_imposed) $labels_imposed
        }
        #local label 16016
        if {[regexp {^local +label +(.*)} $line - local_label labels_imposed]} {
            set arr($pref,local_label) $local_label
        }

        if {[regexp {(\d+) +([a-zA-Z]+) +(Unknown) +(drop)} $line - hash ok interface address]} {
            set arr($pref,drop_pfx) 1
        } else {
            set arr($pref,drop_pfx) 0
        }
    }
    
    set arr($pref,idx) $idx
    return [array get arr]
}

proc showMplsLdpForwarding {vrf pref mask  bDet} {
    set hexPref [ipToHex $pref]
    set hexMask "0x[format %2.2x $mask]"

    set output [exec mpls_ldp_show -t 0x8 -v $vrf 0x1 -Z false -u 0x8 -p $hexPref -m $hexMask]
    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show mpls ldp forwarding $pref detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }


    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 1 
    set i 0
    set saved_line ""
    set re(IPv6)    {(?:(?::|[[:xdigit:]]{1,4})+)}
    set re(IPv4)    {(?:\d+\.\d+\.\d+\.\d+)}
    set re(IP)      "(?:$re(IPv4)|$re(IPv6))"
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    foreach line $lines {
        set b_new_prefix [regexp -- {(\d+.\d+.\d+.\d+)/(\d+) +(\S+) +(\S+) +(\S+) +(\S+)} $line - prefix mask inLabel outLabel outIntf nh] 

        if {$b_new_prefix} {
            set i 1
        } else {
            if {[set b_old_prefix [regexp {^ +(\d+|ImpNull|ExpNullv4|Unlabelled) +(\S+) +(\d+.\d+.\d+.\d+)} \
                                       $line - outLabel outIntf nh]]} {
                incr i
            }
        }
        
        if {$b_new_prefix || $b_old_prefix } {
            set arr($pref,$i,inLabel) $inLabel
            set arr($pref,$i,outLabel) $outLabel
            set arr($pref,$i,outIntf) $outIntf
            set arr($pref,$i,nh) $nh
        }
    }
    return [array get arr]
}

proc showMplsLableTable {lbl bDet} {
    set lbl "0x[format %4.2x $lbl]"
    set output [exec mpls_lsd_show -t 0x0 -l $lbl -d ]

    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show mpls label table label $lbl detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 1 
    set saved_line ""
    set re(IPv6)    {(?:(?::|[[:xdigit:]]{1,4})+)}
    set re(IPv4)    {(?:\d+\.\d+\.\d+\.\d+)}
    set re(IP)      "(?:$re(IPv4)|$re(IPv6))"
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    set num_paths_found 0
    foreach line $lines {
        if { [regexp "^(\\d+) +(\\d+) +(\[\[:alnum:\]:()-\]+) +(\\w+) +(\\w+)$" $line - tbl Label Owner State Rewrite] } {
            # 0     0       LSD        InUse  Yes
            # 0     41      TE-Link    InUse  Yes
            # 0     42      LDP        InUse  Yes
            lappend arr(Tables) $tbl
            lappend arr($tbl,Labels) $Label
            set arr($tbl,$Label,Owner) $Owner
            if {
                ![regexp {^(\S+)\((A|S)\):(\S*)$} $Owner - OwnerApp Role Instance] &&
                ![regexp {^(\S+):(Active|Standby)()$} $Owner - OwnerApp Role Instance]
            } {
                set OwnerApp $Owner
                set Role "Active"
                set Instance ""
            } elseif { $Role == "A" } {
                set Role "Active"
            } elseif { $Role == "S" } {
                set Role "Standby"
            }
            set arr($Label,OwnerApp) $OwnerApp
            set arr($Label,Role) $Role
            set arr($Label,Instance) $Instance
            set arr($Label,State) $State
            set arr($Label,Rewrite) $Rewrite
            continue
        }
    }
    
    return [array get arr]
}

proc showIsisRoute {pref mask bDet} {
    set hexMask "0x[format %2.2x $mask]" 
    set output [exec isis_show -t -d -i $pref -m $hexMask -J 0x0 -K 0x0 -2________]
    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show isis route $pref detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 0 
    set saved_line ""
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    set num_paths_found 0
    foreach line $lines {
        #         L2 102.0.0.1/32 [10/115]
        # via 200.12.1.2, GigabitEthernet0/1/0/16, asr22, Weight: 0
        # via 200.14.2.2, GigabitEthernet0/0/1/9, asr14, SRGB Base: 25000, Weight: 0

        if {[regexp -- {(\S+) +(\d+.\d+.\d+.\d+)/(\d+) +\[\d+\/\d+\]} $line - level pref] } {
        }
        if {[regexp -- {via +(\d+.\d+.\d+.\d+), (\S+), (\S+)(?:, +SRGB Base: (\d+))?, Weight: *(\d+)} $line - nh outIntf nh_router srgb weight]} {
            incr idx
            set arr($pref,$idx,nh) $nh
            set arr($pref,$idx,nh_router) $nh_router
            set arr($pref,$idx,outIntf) $outIntf
            set arr($pref,$idx,weight) $weight
        }

        # src asr15.00-00, 105.0.0.1, prefix-SID index 354, R:0 N:1 P:0 E:0 V:0 L:0
        if {[regexp -- {prefix-SID index (\d+)} $line - pref_sid_idx]} {
            set arr($pref,prefix_sid_index) $pref_sid_idx
        }
    }

    set arr($pref,idx) $idx
    return [array get arr]
}

proc showBgpRoute {vrf pref mask bDet} {
    set hex [ipToHex $pref]
    set hexMask "0x[format %2.2x $mask]"
    set output [exec bgp_show -V $vrf -A 0x1 -W 0x1 -t -a $hex -instance default ]
    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show bgp $pref detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 1 
    set saved_line ""
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    set num_paths_found 0
    
    foreach line $lines {
        if { [regexp {^\s*Path \#(\d+)} $line - pathID ]} {
            set pathID [expr {$pathID -1}]
        }
        if {[regexp {^ *([0-9{}, ]+)$} $line - neiAS] } {
            set arr($pref,$pathID,neiAS) $neiAS
        }   
    }
    return [array get arr]
}

proc showOspfRoute {pref mask bDet} {
    set hexMask "0x[format %2.2x $mask]"
    set pref [ipToHex $pref]
    set output [exec ospf_show -T + -v + -l active -t -X 0x0 -Y 0x0 -f 0x0 -i $pref -m 0xffffffff -e 0x0 -P 0x0 -B 0x0 -d 0x0]
    if {$bDet} {
        puts "----------------------------------------------------------------------------------"
        puts "show ospf routes $pref detail"
        puts "----------------------------------------------------------------------------------"
        puts $output
        puts "----------------------------------------------------------------------------------"
    }

    set retList {}
    # Execute command on appropriate subsystem
    regsub -all \t $output " " output
    regsub -all \r $output " " output
    regsub -all {<} $output "" output
    regsub -all {>} $output "" output

    set lines [split $output "\n"]
    set idx 1 
    set saved_line ""
    set re(HEX_NUM) "\[\[:alnum:\]\]+"
    set viaIdx 0
    set lNumPaths {}
    set num_paths_found 0
    
    foreach line $lines {
        if {[regexp -- {O +(\S+) +($pref/\d+), metric (\d+) area (\d+.\d+.\d+.\d+|\d+)} $line - \
                 level prefix weight area]} {
            # O E2 130.1.1.0/24, metric 20 area 0.0.0.0 
            set arr($pref,area) $area
            set arr($pref,level) $level
        } 
        if {[regexp -- {(\d+.\d+.\d+.\d+), from (\d+.\d+.\d+.\d+), via (\S+)} $line - \
                 nh nh_router outIntf]} {
            incr num_paths_found
            lappend lNumPaths $num_paths_found
            # 200.12.1.1, from 101.0.0.1, via GigabitEthernet0/2/0/7
            # 200.12.2.1, from 101.0.0.1, via GigabitEthernet0/3/0/18
            set arr($pref,$num_paths_found,nh) $nh
            set arr($pref,$num_paths_found,nh_router) $nh_router
            set arr($pref,$num_paths_found,outIntf) $outIntf
            #set arr($pref,$num_paths_found,weight) $weight
        }
        
    }
    set arr($pref,lNumPaths) $lNumPaths
    return [array get arr]
}

# main {{{
# Run Show Cef ipv4 vrf detail to get the nh, out-intf.

array set lLc [get_linecards ]
set lLoc {}

for {set i 0} {$i < $lLc(lc,count)} {incr i} {
    lappend lLoc $lLc(linecards,$i)
}

if {[info exists lLc(0,active)]} {
    lappend lLoc $lLc(0,active)
}
if {[info exists lLc(0,standby)]} {
    lappend lLoc $lLc(0,standby)
}
# puts "The script will be run on the following Node-Ids: $lLoc"

set prefix [lindex $argv 0]
set mask [lindex $argv 1]
set lVrf [lindex $argv 2]

if {[lindex $argv 3] == "brief"} {
    set bDet 0 
} else {
    set bDet 1
}

if { $lVrf == ""} {
    puts "No VRF specified in the show command, \n so the script is trying to determine the list of VRFs configured on the router"
    set lVrf [showVrfAll ]
    puts "The list of VRFs: $lVrf"
}


if {[set vrf [checkPrefVrf $lVrf $prefix]] != "0"} {
    puts "Prefix $prefix is found on vrf $vrf"
    foreach loc $lLoc {
        array set arrCef [showCefIpv4Detail $vrf $prefix $mask $loc $bDet]
        if {[info exists arrCef([lindex $argv 0],source)]} {
            parray arrCef
            puts "-----------------------------------------------------------------------------"
            puts "Checking prefix $prefix vrf $vrf in CEF in location [exec node_conversion -n $loc]"
            puts "The source of this entry: $arrCef($prefix,source)"
            
            if { [info exists arrCef($prefix,type)] && 
                 $arrCef($prefix,type) == "recursive"
             } {
            } else {
                puts "-----------------------------------------------------------------------------"
                puts "The number of available paths      : $arrCef($prefix,idx)"
                puts "Checking prefix $prefix in CEF"
                for {set i 1} {$i <= $arrCef($prefix,idx)} {incr i} {
                    puts "The nexthop for path $i             : $arrCef($prefix,$i,via)"
                    puts "The out-interface  for path $i      : $arrCef($prefix,$i,outIntf)"
                    if {[info exists arrCef($prefix,$i,local_label)]} {
                        puts "The local label for path $i: $arrCef($prefix,$i,local_label)"
                    }
                    if {[info exists arrCef($prefix,$i,labels_imposed)]} {
                        puts "The label imposed for path $i       : $arrCef($prefix,$i,labels_imposed)"
                    }
                    
                }
                puts "-----------------------------------------------------------------------------"
            }
            
            if {$arrCef($prefix,drop_pfx) == "1"} {
                puts "The prefix $prefix is getting dropped in FIB"
                puts "Looking for entry in RIB"
                
                array set arrRib [showRibIpv4 $vrf $prefix $bDet]
                puts "Checking prefix $prefix vrf $vrf in RIB"
                puts "The source of this entry     : $arrRib($prefix,routing_protocol)"
                puts "Inconsistency detected between RIB and FIB"
            }
            
            if {$arrCef([lindex $argv 0],source) == "rib" } {
                array set arrRib [showRibIpv4 $vrf $prefix $bDet]
                parray arrRib
                puts "Checking prefix $prefix vrf $vrf in RIB"
                puts "The source of this entry     : $arrRib($prefix,routing_protocol)"
                if {[regexp "bgp|connected" $arrRib($prefix,routing_protocol)]} {
                    puts "The source of this route is      : $arrRib($prefix,routing_protocol)"
                } else {
                    for {set i 1} {$i <= $arrRib($prefix,idx)} {incr i} {
                        puts "The out-interface            : $arrRib($prefix,$i,fwd_intf)"
                        puts "The nexthop                  : $arrRib($prefix,$i,via)"
                        puts "The nh router                : $arrRib($prefix,$i,router_id)"
                    }
                }
                puts "-----------------------------------------------------------------------------"
                puts "Checking prefix $prefix, vrf $vrf in $arrRib($prefix,routing_protocol)"
                switch -regexp $arrRib([lindex $argv 0],routing_protocol) {
                    "isis" {
                        array set arrIsis [showIsisRoute "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                        for {set i 1} {$i <= $arrIsis($prefix,idx)} {incr i} {
                            puts "The nexthop for path $i            : $arrIsis($prefix,$i,nh)"
                            puts "The nh router for path $i          : $arrIsis($prefix,$i,nh_router)"
                            puts "The out-interface for path $i      : $arrIsis($prefix,$i,outIntf)"  
                        }
                        if {[info exists arrIsis($prefix,prefix_sid_index)]} {
                            puts "The prefix sid: $arrIsis($prefix,prefix_sid_index)"
                        }
                    }
                    "ospf" {
                        array set arrOSPF [showOspfRoute "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                        puts "known via OSPF"
                    }
                    "bgp" {
                        array set arrBGP [showBgpRoute $vrf "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                    }
                    "static" {
                    }
                    default {
                        puts "not known"
                    }
                }
            }
            
            # [info exists arrCef([lindex $argv 0],local_label)]
            if {$arrCef([lindex $argv 0],source) == "lsd" 
            } {
                if {[info exists arrCef([lindex $argv 0],local_label)]} {
                    puts "The prefix has a labeled path, checking LSD for more information"
                }
                set i 1
                array set arrLsd [showMplsLsdForwarding $arrCef([lindex $argv 0],local_label) $loc $bDet]
                
                array set arrLabel [showMplsLableTable $arrCef([lindex $argv 0],local_label) $bDet]
                # One level up
                regsub -all " " $arrCef([lindex $argv 0],local_label) "" local_label
                switch -regexp $arrLabel($local_label,OwnerApp) {
                    "LDP" {
                        puts "The source of this labeled prefix is LDP"
                        # Collect MPLS LDP Forwarding
                        array set arrLdp [showMplsLdpForwarding $vrf "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                    }
                    "BGP" {
                        puts "TBD"
                    } 
                    "TE" {
                        puts "TBD"
                    }
                    default {
                        puts "not a valid label source"
                    }
                }
            } 

            puts "-------------------------------------------------------------------"
            puts "Checking Backup path in CEF"
            if {$arrCef([lindex $argv 0],backup) == "0"} {
                puts "No backup path in CEF"
            } else {
                array set arrCefBkUp [showCefIpv4BackUpDetail $vrf $prefix [lindex $argv 1] $loc $bDet]
                set pfx $arrCefBkUp(pfx)
                for {set j 1} {$j <= $arrCefBkUp($pfx,src_idx)} {incr j} {
                    puts "-------------------------------------------------------------------"
                    if {$arrCefBkUp($pfx,$j,source) == "rib" } {
                        array set arrRib [showRibIpv4 $vrf $prefix $bDet]
                        puts "Checking prefix $prefix vrf $vrf in RIB"
                        puts "The source of this entry     : $arrRib($prefix,routing_protocol)"
                        if {[regexp "bgp" $arrRib($prefix,routing_protocol)]} {
                        } else {
                            for {set i 1} {$i <= $arrRib($prefix,idx)} {incr i} {
                                puts "The out-interface            : $arrRib($prefix,$i,fwd_intf)"
                                puts "The nexthop                  : $arrRib($prefix,$i,via)"
                                puts "The nh router                : $arrRib($prefix,$i,router_id)"
                            }
                        }
                        puts "-----------------------------------------------------------------------------"
                        puts "Checking prefix $prefix, vrf $vrf in $arrRib($prefix,routing_protocol)"
                        switch -regexp $arrRib([lindex $argv 0],routing_protocol) {
                            "isis" {
                                array set arrIsis [showIsisRoute "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                                for {set i 1} {$i <= $arrIsis($prefix,idx)} {incr i} {
                                    puts "The nexthop for path $i            : $arrIsis($prefix,$i,nh)"
                                    puts "The nh router for path $i          : $arrIsis($prefix,$i,nh_router)"
                                    puts "The out-interface for path $i      : $arrIsis($prefix,$i,outIntf)"  
                                }
                                if {[info exists arrIsis($prefix,prefix_sid_index)]} {
                                    puts "The prefix sid: $arrIsis($prefix,prefix_sid_index)"
                                }
                            }
                            "ospf" {
                                array set arrOSPF [showOspfRoute "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                                puts "known via OSPF"
                            }
                            "bgp" {
                                array set arrBGP [showBgpRoute $vrf "[lindex $argv 0]" "[lindex $argv 1]" $bDet]
                            }
                            "static" {
                            }
                            default {
                                puts "not known"
                            }
                        }
                    }

                    if {$arrCefBkUp($pfx,$j,source) == "lsd" 
                    } {
                        if {[info exists arrCefBkUp($pfx,$j,local_label)]} {
                            puts "The prefix has a labeled backup path, checking LSD for more information"
                        }
                        set i 1
                        array set arrLsd [showMplsLsdForwarding $arrCefBkUp($pfx,$j,local_label) $loc $bDet]
                        
                        array set arrLabel [showMplsLableTable $arrCefBkUp($pfx,$j,local_label) $bDet]
                        # One level up
                        regsub -all " " $arrCefBkUp($pfx,$j,local_label) "" local_label
                        switch -regexp $arrLabel($local_label,OwnerApp) {
                            "LDP" {
                                puts "The source of this labeled prefix is LDP"
                                # Collect MPLS LDP Forwarding
                                array set arrLdp [showMplsLdpForwarding $vrf [lindex $argv 0] "[lindex $argv 1]" $bDet]
                            }
                            "BGP" {
                                puts "TBD"
                            } 
                            "TE" {
                                puts "TBD"
                            }
                            default {
                                puts "not a valid label source"
                            }
                        }
                    } 
                }
            }
            
        } else {
            puts "No valid source info found in CEF in location [exec node_conversion -n $loc]"
        }
    }

} else {
    puts "Prefix not found in the given VRF"
}
# }}}
    
    