# ----------------------------------------------------------------------------
# ocifmgr_ifmgr_telemetry_oper.py 
#
# June 2018, Ujjaini Sengupta
 
# Created by applying the MDT Yang2Bag tool to
# pfi/im/cmd/src/openconfig-interfaces.yang
#
# This is a customized mapping file containing only state mappings
# for overlay_ocif_state, overlay_ocif_hold_time and
# overlay_ocif_subinterface bags.
# 
#


overlay_ocif_state = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name" : "overlay_ocif_state",
    "bag-file" : "ocifmgr_ifmgr_telemetry_oper.bag",
    "xr-path" : "/oper/overlays/gl/ocif/openconfig-interfaces/interfaces/interface__list_S/<>/state__bag_overlay_ocif_state",
    "sysdb-path" : "/oper/overlays/gl/ocif/openconfig-interfaces/interfaces/interface__list_S/*/state__bag_overlay_ocif_state",

    "naming-elements":
    [
      {
      "type" : "string",
      "index" : 0,
      }
,    ],
    "overlay-nodes" :
    [
      {
      "name" : "openconfig-interfaces:interfaces",
      "namespace" : "http://openconfig.net/yang/interfaces",
      "node-type" : "container__",
      "field-id" : 1,
      "overlay-nodes" :
      [
        {
        "name" : "interface",
        "node-type" : "list__",
        "field-id" : 1,
        "naming-element-nodes":
        [
          {
          "index" : 0,
          "name" : "name",
          "node-type" : "key-leaf__",
          "field-id" : 1,
          "type" : "string",
          "key" : True,
          },
        ],
        "overlay-nodes" :
        [
          {
          "name" : "state",
          "node-type" : "container-bag__",
          "field-id" : 1,
          "bag-mapping-nodes":
          [
            {
            "bag-field" : "Type",
            "bag-type" : "__yang2bag_string",
            "overlay-nodes" : 
            [
              {
              "name" : "type",
              "node-type" : "mandatory-leaf__",
              "field-id" : 1,
              "type" : "identityref",
              },
            ],
            },
            {
            "bag-field" : "Mtu",
            "bag-type" : "uint16_t",
            "overlay-nodes" : 
            [
              {
              "name" : "mtu",
              "node-type" : "leaf__",
              "field-id" : 2,
              "type" : "uint16",
              },
            ],
            },
            {
            "bag-field" : "Name",
            "bag-type" : "__yang2bag_string",
            "bag-mapping-nodes" : 
            [
              {
              "bag-field" : "value",
              "bag-type" : "string",
              "overlay-nodes" : 
              [
                {
                "name" : "name",
                "node-type" : "leaf__",
                "field-id" : 3,
                "type" : "string",
                },
              ],
              },
            ],
            },
            {
            "bag-field" : "Description",
            "bag-type" : "__yang2bag_string",
            "bag-mapping-nodes" : 
            [
              {
              "bag-field" : "value",
              "bag-type" : "string",
              "overlay-nodes" : 
              [
                {
                "name" : "description",
                "node-type" : "leaf__",
                "field-id" : 4,
                "type" : "string",
                },
              ],
              },
            ],
            },
            {
            "bag-field" : "Enabled",
            "bag-type" : "bool",
            "overlay-nodes" : 
            [
              {
              "name" : "enabled",
              "node-type" : "leaf__",
              "field-id" : 5,
              "type" : "boolean",
              },
            ],
            },
            {
            "bag-field" : "Ifindex",
            "bag-type" : "uint32_t",
            "overlay-nodes" : 
            [
              {
              "name" : "ifindex",
              "node-type" : "leaf__",
              "field-id" : 6,
              "type" : "uint32",
              },
            ],
            },
            {
            "bag-field" : "AdminStatus",
            "bag-type" : "openconfig_interfaces_admin_status_enum",
            "overlay-nodes" : 
            [
              {
              "name" : "admin-status",
              "node-type" : "mandatory-leaf__",
              "field-id" : 7,
              "type" : "enumeration",
              "enum-map" : {
                 0  : "UP",
                 1  : "DOWN",
                 2  : "TESTING",
              },
              },
            ],
            },
            {
            "bag-field" : "OperStatus",
            "bag-type" : "openconfig_interfaces_oper_status_enum",
            "overlay-nodes" : 
            [
              {
              "name" : "oper-status",
              "node-type" : "mandatory-leaf__",
              "field-id" : 8,
              "type" : "enumeration",
              "enum-map" : {
                 1  : "UP",
                 2  : "DOWN",
                 3  : "TESTING",
                 4  : "UNKNOWN",
                 5  : "DORMANT",
                 6  : "NOT_PRESENT",
                 7  : "LOWER_LAYER_DOWN",
              },
              },
            ],
            },
            {
            "bag-field" : "LastChange",
            "bag-type" : "uint32_t",
            "overlay-nodes" : 
            [
              {
              "name" : "last-change",
              "node-type" : "leaf__",
              "field-id" : 9,
              "type" : "ietf-yang-types:timeticks",
              },
            ],
            },
          ],
          },
        ],
        },
      ],
      },
    ],
}


overlay_ocif_hold_time = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name" : "overlay_ocif_hold_time",
    "bag-file" : "ocifmgr_ifmgr_telemetry_oper.bag",
    "xr-path" : "/oper/overlays/gl/ocif/openconfig-interfaces/interfaces/interface__list_S/<>/hold-time__bag_overlay_ocif_hold_time",
    "sysdb-path" : "/oper/overlays/gl/ocif/openconfig-interfaces/interfaces/interface__list_S/*/hold-time__bag_overlay_ocif_hold_time",

    "naming-elements":
    [
      {
      "type" : "string",
      "index" : 0,
      }
,    ],
    "overlay-nodes" :
    [
      {
      "name" : "openconfig-interfaces:interfaces",
      "namespace" : "http://openconfig.net/yang/interfaces",
      "node-type" : "container__",
      "field-id" : 1,
      "overlay-nodes" :
      [
        {
        "name" : "interface",
        "node-type" : "list__",
        "field-id" : 1,
        "naming-element-nodes":
        [
          {
          "index" : 0,
          "name" : "name",
          "node-type" : "key-leaf__",
          "field-id" : 1,
          "type" : "string",
          "key" : True,
          },
        ],
        "overlay-nodes" :
        [
          {
          "name" : "hold-time",
          "node-type" : "container-bag__",
          "field-id" : 2,
          "bag-mapping-nodes":
          [
            {
            "bag-field" : "State",
            "bag-type" : "state_type",
            "overlay-nodes" : 
            [
              {
              "name" : "state",
              "node-type" : "container__",
              "field-id" : 1,
              "bag-mapping-nodes":
              [
                {
                "bag-field" : "Up",
                "bag-type" : "uint32_t",
                "overlay-nodes" : 
                [
                  {
                  "name" : "up",
                  "node-type" : "leaf__",
                  "field-id" : 1,
                  "type" : "uint32",
                  },
                ],
                },
                {
                "bag-field" : "Down",
                "bag-type" : "uint32_t",
                "overlay-nodes" : 
                [
                  {
                  "name" : "down",
                  "node-type" : "leaf__",
                  "field-id" : 2,
                  "type" : "uint32",
                  },
                ],
                },
              ],
              },
            ],
            },
          ],
          },
        ],
        },
      ],
      },
    ],
}


overlay_ocif_subinterface = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name" : "overlay_ocif_subinterface",
    "bag-file" : "ocifmgr_ifmgr_telemetry_oper.bag",
    "xr-path" : "/oper/overlays/gl/ocif/openconfig-interfaces/interfaces/interface__list_S/<>/subinterfaces/subinterface__list_u__bag_overlay_ocif_subinterface/<>",
    "sysdb-path" : "/oper/overlays/gl/ocif/openconfig-interfaces/interfaces/interface__list_S/*/subinterfaces/subinterface__list_u__bag_overlay_ocif_subinterface/*",

    "naming-elements":
    [
      {
      "type" : "string",
      "index" : 0,
      }
,      {
      "type" : "uint32",
      "index" : 1,
      }
,    ],
    "overlay-nodes" :
    [
      {
      "name" : "openconfig-interfaces:interfaces",
      "namespace" : "http://openconfig.net/yang/interfaces",
      "node-type" : "container__",
      "field-id" : 1,
      "overlay-nodes" :
      [
        {
        "name" : "interface",
        "node-type" : "list__",
        "field-id" : 1,
        "naming-element-nodes":
        [
          {
          "index" : 0,
          "name" : "name",
          "node-type" : "key-leaf__",
          "field-id" : 1,
          "type" : "string",
          "key" : True,
          },
        ],
        "overlay-nodes" :
        [
          {
          "name" : "subinterfaces",
          "node-type" : "container__",
          "field-id" : 3,
          "overlay-nodes" :
          [
            {
            "name" : "subinterface",
            "node-type" : "list-bag__",
            "field-id" : 1,
            "naming-element-nodes":
            [
              {
              "index" : 1,
              "name" : "index",
              "node-type" : "key-leaf__",
              "field-id" : 1,
              "type" : "uint32",
              "key" : True,
              },
            ],
            "bag-mapping-nodes":
            [
              {
              "bag-field" : "State",
              "bag-type" : "subinterface_state_type",
              "overlay-nodes" : 
              [
                {
                "name" : "state",
                "node-type" : "container__",
                "field-id" : 1,
                "bag-mapping-nodes":
                [
                  {
                  "bag-field" : "Index",
                  "bag-type" : "uint32_t",
                  "overlay-nodes" : 
                  [
                    {
                    "name" : "index",
                    "node-type" : "leaf__",
                    "field-id" : 1,
                    "type" : "uint32",
                    },
                  ],
                  },
                  {
                  "bag-field" : "Name",
                  "bag-type" : "__yang2bag_string",
                  "bag-mapping-nodes" : 
                  [
                    {
                    "bag-field" : "value",
                    "bag-type" : "string",
                    "overlay-nodes" : 
                    [
                      {
                      "name" : "name",
                      "node-type" : "leaf__",
                      "field-id" : 2,
                      "type" : "string",
                      },
                    ],
                    },
                  ],
                  },
                  {
                  "bag-field" : "Description",
                  "bag-type" : "__yang2bag_string",
                  "bag-mapping-nodes" : 
                  [
                    {
                    "bag-field" : "value",
                    "bag-type" : "string",
                    "overlay-nodes" : 
                    [
                      {
                      "name" : "description",
                      "node-type" : "leaf__",
                      "field-id" : 3,
                      "type" : "string",
                      },
                    ],
                    },
                  ],
                  },
                  {
                  "bag-field" : "Enabled",
                  "bag-type" : "bool",
                  "overlay-nodes" : 
                  [
                    {
                    "name" : "enabled",
                    "node-type" : "leaf__",
                    "field-id" : 4,
                    "type" : "boolean",
                    },
                  ],
                  },
                  {
                  "bag-field" : "Ifindex",
                  "bag-type" : "uint32_t",
                  "overlay-nodes" : 
                  [
                    {
                    "name" : "ifindex",
                    "node-type" : "leaf__",
                    "field-id" : 5,
                    "type" : "uint32",
                    },
                  ],
                  },
                  {
                  "bag-field" : "AdminStatus",
                  "bag-type" : "openconfig_interfaces_admin_status_enum",
                  "overlay-nodes" : 
                  [
                    {
                    "name" : "admin-status",
                    "node-type" : "mandatory-leaf__",
                    "field-id" : 6,
                    "type" : "enumeration",
                    "enum-map" : {
                       0  : "UP",
                       1  : "DOWN",
                       2  : "TESTING",
                    },
                    },
                  ],
                  },
                  {
                  "bag-field" : "OperStatus",
                  "bag-type" : "openconfig_interfaces_oper_status_enum",
                  "overlay-nodes" : 
                  [
                    {
                    "name" : "oper-status",
                    "node-type" : "mandatory-leaf__",
                    "field-id" : 7,
                    "type" : "enumeration",
                    "enum-map" : {
                       1  : "UP",
                       2  : "DOWN",
                       3  : "TESTING",
                       4  : "UNKNOWN",
                       5  : "DORMANT",
                       6  : "NOT_PRESENT",
                       7  : "LOWER_LAYER_DOWN",
                    },
                    },
                  ],
                  },
                  {
                  "bag-field" : "LastChange",
                  "bag-type" : "uint32_t",
                  "overlay-nodes" : 
                  [
                    {
                    "name" : "last-change",
                    "node-type" : "leaf__",
                    "field-id" : 8,
                    "type" : "ietf-yang-types:timeticks",
                    },
                  ],
                  },
                ],
                },
              ],
              },
            ],
            },
          ],
          },
        ],
        },
      ],
      },
    ],
}


overlay_mappings = [
    overlay_ocif_state,
    overlay_ocif_hold_time,
    overlay_ocif_subinterface,
    ]

