LOGFILE=/misc/disk1/xr_down.log

echo "$(date): Starting.. " >> $LOGFILE

helpFunction()
{ 
   echo ""
   echo "Usage: $0 -d parameterA -s parameterB"
   echo -e "\t-d stop docker process "
   echo -e "\t-s shutdown node"
   exit 1 # Exit script after printing help
}

while getopts "d:s:" opt
do
   case "$opt" in
      d ) dockerkill="$OPTARG" ;;
      s ) shutdown="$OPTARG" ;;
      ? ) helpFunction ;; # Print helpFunction in case parameter is non-existent
   esac
done

# Print helpFunction in case parameters are empty
if [ -z "$dockerkill" ] && [ -z "$shutdown" ]
then
   echo "all of the parameters are empty";
   helpFunction
fi

if [ "$dockerkill" ]
then
    echo "$(date): killing docker process.." >> $LOGFILE
    kill -9 `pidof docker`
    echo "$(date): stoping docker .." >> $LOGFILE
    kill -9 `pgrep -f cisco_docker`
    echo "$(date): Completed operation." >> $LOGFILE
fi

if [ "$shutdown" ]
then
    echo "$(date): Doing shutdown.." >> $LOGFILE
    /bin/sync
    /sbin/shutdown -P now
fi

