#! /usr/bin/env python

import socket
import struct
import os
import sys
from logger_init import get_logger
try:
    import calv_instmgr_chkpt_pb2 as chkpt
    import instagt_chkpt_pb2 as agt_chkpt
except ImportError:
    pass

logger = get_logger()

instmgr_chkpt_file = 'instmgr_chkpt' 
instmgr_prep_chkpt_file = 'instmgr_prep_chkpt' 
instagt_chkpt_file = 'instagt_chkpt' 
xr_prep_chkpt_file = 'prepare_chkpt'

#----- Input list --------
OPID = 0
MiniBundleISO = 'mini'
XrBundleISO = 'XrISO'
CalBundleISO = 'CalIso'
HostBundleISO = 'HostIso'

# List of optional RPMS ( SMUs or optional XR packages )
XrRpms = []
CalRpms = []
HostRpms = []

# IP addrees as per show vm out put
CalIP  = []
XrIP  = []

# NBI path in case of nbi support
Cal_nbi_path = None
Cal_nbi_initrd_path = None
#----- Input list --------

def int_ip2str(int_ip):
    lst = []
    for i in xrange(4):
        shift_n = 8 * i
        lst.insert(0, str((int_ip >> shift_n) & 0xff))
    return ".".join(lst)

def str_ip2_int(s_ip):
    lst = [int(item) for item in s_ip.split('.')]
    int_ip = lst[3] | lst[2] << 8 | lst[1] << 16 | lst[0] << 24
    return int_ip 

def add_node_info(node_ip):
    ''' Populate nodeinfo data structure
    '''
    nodeinfo = chkpt.instmgr_node_info()
    nodeinfo.ip_addr = str_ip2_int(node_ip)
    nodeinfo.completed = False
    nodeinfo.op_rc = 0
    nodeinfo.participating = True
    nodeinfo.node_rc = 0
    return nodeinfo

def populate_wtba_nodeinfo(wtba,vm_type):
    ''' Populate nodeinfo in wtba of instmgr_prep_chkpt data 
    '''
    if vm_type == 3 : 
        # Add XR vm nodes
        for ip in CalIP :
            node_info = add_node_info(ip)
            wtba.node_info.extend([node_info])
    elif vm_type == 2 or vm_type == 1: 
        # Add cal and sysadmin vm nodes
        for ip in CalIP :
            node_info = add_node_info(ip)
            wtba.node_info.extend([node_info])

def populate_wtba_chkpt_data(prep_chkpt, vm_type, bundle = 'I will come to know'):
    ''' Populate wtba of instmgr_prep_chkpt data 
    '''
    wtba_op = prep_chkpt.instmgr_op()
    wtba_op.op_id = OPID
    wtba_op.op_type = 8
    wtba_op.vm_type = vm_type
    wtba_op.sdr_key = "default-sdr"
    wtba_op.iso_name = bundle
    wtba_op.iso_type = vm_type
    wtba_op.user = "root"
    wtba_op.msg_we_wait_for = 3 #'INSTCMD_PREP_DONE'
    wtba_op.prep_id = OPID 
    wtba_op.op_rc = 0
    wtba_op.is_abort = False
    wtba_op.is_seq_op = False
    wtba_op.cur_pkg_index = 0
    wtba_op.sdr_id = 2
    wtba_op.restart_type = 0
    wtba_op.op_stage = 0
    wtba_op.is_system_op = True
    wtba_op.issu_op = False
    wtba_op.is_crvm_op = False
    wtba_op.nbn_op = False
    wtba_op.is_backup_req_sent = False
    wtba_op.sub_op = False
    wtba_op.do_activate = False
    if vm_type == 3 :
        wtba_op.pkg_names.extend(XrRpms)
    if vm_type == 2 :
        wtba_op.pkg_names.extend(CalRpms)
    if vm_type == 1 :
        wtba_op.pkg_names.extend(HostRpms)
    # Add node info
    populate_wtba_nodeinfo(wtba_op,vm_type)

    return wtba_op

def create_xr_instagent_chkpt():

    part1 = "operation_id %d\n"%(OPID)
    part1 = part1+"base_iso %s\n"%(MiniBundleISO)
    part1 = part1+"restart_type 4\n"
    part1 = part1+"system_op 1\n"
    part1 = part1+"is_optim_prepare 1\n"
    part1 = part1+"prepare_only 1\n"
    part1 = part1+"rpm_cnt %d\n"%(PkgCount)
    part1 = part1+"%s\n"%(AllPkgs)
    part1 = part1+"is_host_iso_smu_present 0\n\n"
    part1 = part1+"node_cnt 2\n4096 4288\npkg_count %s\n\n"%(len(XrRpms))

    part2 = ''
    for p in XrRpms :
        part2 = "%sPackage_Name %s\n"%(part2,p)
        part2 = "%sPackage_type 8\n"%(part2)
        part2 = "%sRPM_count 1\n"%(part2)
        part2 = "%s%s\n"%(part2,p)

    part3 = '''crvm_smu_op 0\nsdr_upgrade 0\nSP_COUNT 0'''

    fd = open(xr_prep_chkpt_file,'w')
    fd.write(part1)
    fd.write(part2)
    fd.write(part3)
    fd.close()

def create_instmgr_prep_chkpt(dec = False):
    ''' Populate instmgr_prep_chkpt data 
    '''
    chkpt_profile = chkpt.instmgr_prep_chkpt()
    chkpt_profile.valid_on_reload = True
    chkpt_profile.bundle_iso_path = MiniBundleISO
    chkpt_profile.calv_prep_type = 3
    chkpt_profile.host_upgrade = False
    chkpt_profile.host_upgrade_stage = 0
    chkpt_profile.calculated_restart_type = 0
    chkpt_profile.system_op_prep_complete = True
    chkpt_profile.v2_is_new_pkg_format = True
    chkpt_profile.host_iso = os.path.basename(HostBundleISO)
    chkpt_profile.calvados_iso = os.path.basename(CalBundleISO)
    chkpt_profile.xr_iso = os.path.basename(XrBundleISO)
    chkpt_profile.host_iso_name = os.path.basename(HostBundleISO) # ??
    chkpt_profile.xr_pkg_list.extend(XrRpms)
    chkpt_profile.cal_pkg_list.extend(CalRpms)
    chkpt_profile.host_pkg_list.extend(HostRpms)
    if Cal_nbi_path and Cal_nbi_initrd_path:
        chkpt_profile.cal_nbi_path = Cal_nbi_path
        chkpt_profile.cal_nbi_initrd_path = Cal_nbi_initrd_path
    # Host data
    host_wtba = populate_wtba_chkpt_data(chkpt,1,os.path.basename(HostBundleISO))
    chkpt_profile.wtba_op.extend([host_wtba])

    # Cal data
    cal_wtba = populate_wtba_chkpt_data(chkpt,2,os.path.basename(CalBundleISO))
    chkpt_profile.wtba_op.extend([cal_wtba])

    # XR data only if XR vm is there on the node
    if XrIP :  
        xr_wtba = populate_wtba_chkpt_data(chkpt,3,os.path.basename(XrBundleISO))
        chkpt_profile.wtba_op.extend([xr_wtba])

    # Write to file
    f = open(instmgr_prep_chkpt_file, "wb")
    f.write(chkpt_profile.SerializeToString())
    f.close()
    if dec :
        logger.debug(chkpt_profile)
    return chkpt_profile
    

def create_instmgr_chkpt(dec = False):
    ''' Populate instmgr_chkpt data '''
    instmgr_chkpt_data = chkpt.instmgrchkpt()
    instmgr_chkpt_data.xr_op = False
    instmgr_chkpt_data.system_op = True
    instmgr_chkpt_data.xr_unlocked = True
    instmgr_chkpt_data.system_op_reload_timeout = False
    instmgr_chkpt_data.xr_unlocked_on_abort = False
    instmgr_chkpt_data.crvm_smu_op = False
    instmgr_chkpt_data.pkg_fmt_ver = "sysadmin" #its a joke :-)
    instmgr_chkpt_data.is_post_op_self_test_requested = True
    instmgr_chkpt_data.resume_state = 0
    instmgr_chkpt_data.reload_in_progress = False
    instmgr_chkpt_data.xr_op_type = 0

    # Node ID
    instmgr_chkpt_data.local_nodeid.rack_num = 0
    instmgr_chkpt_data.local_nodeid.slot_num = 32
    instmgr_chkpt_data.local_nodeid.instance = 0

    # Last Reply - No idea what this is 
    instmgr_chkpt_data.last_reply.op_id = OPID
    instmgr_chkpt_data.last_reply.sdr_id = 0
    instmgr_chkpt_data.last_reply.reply_type = 1
    instmgr_chkpt_data.last_reply.prep_lv_reply.errno = 0

    # Write to file
    f = open(instmgr_chkpt_file, "wb")
    f.write(instmgr_chkpt_data.SerializeToString())
    f.close()

    if dec :
        logger.debug(instmgr_chkpt_data)
    return instmgr_chkpt_data

def create_instagt_chkpt(dec = False):
    ''' Populate  instagt_chkpt data '''
    agent_chkpt = agt_chkpt.instagtchkpt()
    agent_chkpt.chkpt_loop_name = "/dev/loop16"
    agent_chkpt.last_operation.last_mgr_pid = 0
    agent_chkpt.last_operation.last_op_id = OPID
    agent_chkpt.last_operation.last_activate_seq_id = 0
    agent_chkpt.last_operation.last_op_type = 8
    agent_chkpt.last_operation.last_vm_type = 3
    agent_chkpt.last_operation.last_activate_type = 2
    agent_chkpt.last_operation.last_op_done_checksum = 2309737967
    agent_chkpt.last_operation.last_op_rc = 0
    agent_chkpt.biv_calv_prep_type = 0
    agent_chkpt.is_pkg_new_fmt = True
    agent_chkpt.inst_pkg_fmt_ver = "1.1"
    agent_chkpt.calv_backup_completed = False
    agent_chkpt.host_backup_completed = False
    agent_chkpt.image_backup_loc = True

    # Write to file
    f = open(instagt_chkpt_file, "wb")
    f.write(agent_chkpt.SerializeToString())
    f.close()
    if dec :
        logger.debug(agent_chkpt)
    return agent_chkpt

if __name__ == '__main__':
    #instmgr_prep_chkpt = create_instmgr_prep_chkpt()
    #instmgr_chkpt = create_instmgr_chkpt()
    #instagt_chkpt = create_instagt_chkpt()
    logger = get_logger()
    create_xr_instagent_chkpt()
    #print instmgr_chkpt
    #print instmgr_prep_chkpt
    #print instagt_chkpt 
