#! /usr/bin/python

import commands
import os
import re
import ConfigParser
import constants as C

platform_prefix = "/opt/cisco/calvados/bin/vrfch.sh CTRL_VRF"

class Inst_Create_Config:
    def __init__(self,cfgfile):
        self.cfgfile = cfgfile
        self.MiniImage = ""
        self.PkgList = ''
        self.OPID = 999
        self.calvmip = []
        self.xrvmip = []
        self.lcxrvmip = []
        self.CalRepo = "/install_repo/gl/calvados"
        self.calrpvms = []
        self.xrrpvms = []
        self.location_vm = {}
        self.get_vmip()

    def create_system_config(self):
        config = ConfigParser.ConfigParser()
        config.add_section (C.SYSTEMSECTION)

        config.set (C.SYSTEMSECTION, C.OPID, self.OPID)
        config.set (C.SYSTEMSECTION, C.ISO, os.path.join(self.CalRepo,self.MiniImage))
        config.set (C.SYSTEMSECTION, C.PKGLIST, self.PkgList)
        config.set (C.SYSTEMSECTION, C.CALVMS, ','.join(self.calvmip))
        config.set (C.SYSTEMSECTION, C.XRVMS, ','.join(self.xrvmip)) 
        config.set (C.SYSTEMSECTION, C.LCXRVMS, ','.join(self.lcxrvmip)) 
        config.set (C.SYSTEMSECTION, C.XRVMSRP, ','.join(self.xrrpvms))
        config.set (C.SYSTEMSECTION, C.CALVMSRP, ','.join(self.calrpvms))

        with open (self.cfgfile, 'wb') as cfg:
            config.write (cfg)
        
        return self.location_vm

    def get_vmip(self):
        location_vm = {}
        cmd1 = "/pkg/bin/install_exec_sysadmin \"source /opt/cisco/calvados/bin/install-functions.sh ; %s /opt/cisco/calvados/bin/show_cmd 'show vm'  \"" % (platform_prefix)
        cmd = commands.getoutput(cmd1)
        if not cmd:
            print("Failed to fetch VM Information")
            exit(-1)
        else:
            for line in cmd.split(os.linesep):
                if "Location" in line:
                    location = line.split()[1]
                    if location not in location_vm.keys():
                        location_vm[location] = {}
                if "running" in line:
                    vm_name = line.split()[0]
                    if "sysadmin" in vm_name:
                        vm_ip = re.findall(r'[0-9]+(?:\.[0-9]+){3}', line)
                        if ("RP" in location or "RSP" in location or "CB" in location):
                            self.calrpvms.append(vm_ip[0])
                        location_vm[location]['sysadmin'] = vm_ip
                    elif "default-sdr" in vm_name:
                        vm_ip = re.findall(r'[0-9]+(?:\.[0-9]+){3}', line)
                        if location_vm[location].has_key('XRVM'):
                            location_vm[location]['XRVM'] = 2
                        else :
                            if ("RP" in location or "RSP" in location or "CB" in location):
                                self.xrrpvms.append(vm_ip[0])
                            location_vm[location]['XRVM'] = 1
        
        for key in location_vm :
            self.calvmip.extend(location_vm[key]['sysadmin'])
            if location_vm[key].has_key('XRVM') and location_vm[key]['XRVM'] == 2:
                self.lcxrvmip.extend(location_vm[key]['sysadmin'])
                self.xrvmip.extend(location_vm[key]['sysadmin'])
            if location_vm[key].has_key('XRVM') and location_vm[key]['XRVM'] == 1:
                self.xrvmip.extend(location_vm[key]['sysadmin'])

        self.location_vm = location_vm
           
def main():
    inst = Inst_Create_Config()
    inst.create_system_config()

if __name__ == '__main__':
    main()

