#!/usr/bin/python
# ------------------------------------------------------------------
# logger utility
#
# Copyright (c) 2015-2019 by cisco Systems, Inc.
# All rights reserved.
# ------------------------------------------------------------------
#

import os
import sys
import logging
import logging.handlers

# How to use ?
# (1) In your program import it like - "import logger"
# (2) Pick a name with which your loggs will be differentiated from others
# (3) in begining of your program initializse loggin as :
#   instlogger = logger.init("name you picked in step #2")
#
# All your logs will be stored in /var/log/install/inst_update.log
# It will be compress if crosses 100 KB and only 5 latest compressed
# logs will be stored. All older loggs will be deleted.
#
# If you want logs to go to diffferent path and file of your choice , make
# sure that path exists and give that as second argument to init_logger like
#


# Initialise gicing a name to differentiate a caller
def init(callername, logfile='inst_update.log'):
    if not logfile:
        if os.path.exists("/router/bin"):
            ROOTFS = "/tmp"
        else:
            ROOTFS = "/"
        LOGPATH = os.path.join(ROOTFS, 'var/log/install')
        LOGFILE = os.path.join(LOGPATH, logfile)

        if not os.path.exists(LOGPATH):
            os.makedirs(LOGPATH)
    else:
        LOGFILE = logfile

    # create logger
    logger = logging.getLogger(callername)
    logger.setLevel(logging.DEBUG)
    formatter = logging.Formatter(
        '%(asctime)s::%(name)s:%(levelname)s:%(message)s', "%Y-%m-%d %H:%M:%S")

    # Console message
    ch = logging.StreamHandler(sys.stdout)
    ch.setLevel(logging.ERROR)
    logger.addHandler(ch)

    # Logs to logfile
    fh = logging.handlers.RotatingFileHandler(
        LOGFILE, maxBytes=(1024*100), backupCount=5)
    fh.setLevel(logging.DEBUG)
    fh.setFormatter(formatter)
    logger.addHandler(fh)
    return logger
