#!/bin/bash 

#------------------------------------------------------------------
# instcmd_cli_hook.sh
#
# Copyright (c) 2015-2019 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

set -o noglob
args=("$@")
logfile="/var/log/install/instcmd_cli_hook.log"

# Check for enxr in input package list.
# If enxr packages, go ahead with sdr_instcmd directly.
for pkg in ${args[@]}; do
    if [[ $pkg =~ "enxr-" ]]
    then
        tz=`date "+%Y-%m-%d %H:%M:%S",$LINENO`
        message="enxr in package name, continuing with traditional calls"
        echo "$tz ERROR $message" >> $logfile
        sdr_instcmd ${args[@]}
        exit
    fi
done

# Call instcmd_cli_hook to handle the incoming request.
# Upon failure or an abnormal exit, go with traditional calls.

python /pkg/bin/instcmd_cli_hook.py ${args[@]} 2>/dev/null
ret=$?
if [ $ret -ne 0 ]; then
    tz=`date "+%Y-%m-%d %H:%M:%S",$LINENO`
    message="Unable to run instcmd_cli_hook.py, continuing with traditional calls"
    echo "$tz ERROR $message" >> $logfile
    sdr_instcmd ${args[@]}
fi



