#!/bin/bash
#------------------------------------------------------------------------------
# xr_showtech_gatherer.sh                     
#
# July 2015
#
# Copyright (c) 2015 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------------------


while [ "$#" -gt "0" ]; do
    case "$1" in
        -T) trace_only="1"; shift 1;;
        -S) show_only="1"; shift 1;;
        -t) cardtype="$2"; shift 2;;
        -f) media_path="$2"; shift 2;;
        -n) nodename="$2"; shift 2;;
        -c) clean="1"; shift 1;;
        *) shift;;
    esac
done

# This script returns either a filename or an empty string to the
# caller. The caller, on receipt of a non-empty string, will
# attempt to scp the filename from the XR.

if [ -z "$nodename" ]; then
    exit 0
elif [ "$nodename" = "system" ]; then
    exit 0
fi
if [ -z "$media_path" ]; then
    exit 0
fi

nodename_plus_xr=`hostname`

# All logs etc will be accumulated into $fullpath
fullpath=$media_path/$nodename_plus_xr

if [ "$clean" = "1" ]; then
    rm ${fullpath}.tgz
    rmdir $media_path; RCX=$?
    exit 0
fi

mkdir -p $fullpath ; RC=$?
if [ $RC -ne 0 ]; then
    exit 0
fi

SHOWTECH_LOGFILE=$fullpath/xr_showtech_log

# media_path looks like:
# /misc/scratch/showtech/showtech-HBloss-admin-YYYY-month-dd.hhmmss.TZ
echo MEDIA_PATH $media_path >> $SHOWTECH_LOGFILE

# nodename looks like:
# 0_RP0, 0_LC
echo NODENAME $nodename >> $SHOWTECH_LOGFILE

# nodename_plus_xr looks like:
# 0_RP0_xr, 0_LC_xr
echo NODENAME_PLUS_XR $nodename_plus_xr >> $SHOWTECH_LOGFILE

# fullpath is media_path concatenated with nodename_plus_xr
echo FULLPATH $fullpath >> $SHOWTECH_LOGFILE

# cardtype - LC, RP, SC...
echo CARDTYPE $cardtype >> $SHOWTECH_LOGFILE

# Copy entire /var/log directory
echo "CMD: ln -s /misc/scratch/*.out $fullpath" 1>> $SHOWTECH_LOGFILE
ln -s /misc/scratch/*.out $fullpath 1>> $SHOWTECH_LOGFILE 2>&1


(   cd $media_path
    tar --dereference -czf $nodename_plus_xr.tgz $nodename_plus_xr 1>/dev/null 2>&1
    echo $fullpath.tgz
)

# This will remove the directory we accumlated into
# media_path + nodename_plus_xr
#
rm -fr $fullpath

exit 0
