<!-- Copyright (c) 2008-2009 by Cisco Systems, Inc. -->
// discover.js for c2350 devices - WS-C2350-48TD.


function WSC235048TD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2350_48.gif";

	drawLeds_withoutPoE_pixar(dev);
	//drawACOK_DCOKLEDs(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/49") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}

	if (interfaces.indexOf("0/51") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}

	if (interfaces.indexOf("0/49") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/51") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function addLabel( dev, label1, label2 )
{
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(617, 8, 7, 5, image1);
			if(dev.type.indexOf("WS-C3560E-12SD") != -1){
				image1 = "images/port_black_label_"+label1+".gif";
				portlbtl = new top.portLabel(585, 19, 7, 5, image1);
			}
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(617, 57, 7, 5, image1);
			if(dev.type.indexOf("WS-C3560E-12SD") != -1){
				image1 = "images/port_black_label_"+label1+".gif";
				portlbtl = new top.portLabel(584, 43, 7, 5, image1);
			}
        	portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 13:
				// Adding the top port label1
		        var portlbl = new top.portLabel(583, 19, 7, 5, image1);
	        	portlbl.id = "portlbl1";
		        dev.addPortLabel(portlbl);

		        // Adding the top port label2
		        var portlbl2 = new top.portLabel(647, 19, 7, 5, image2);
	        	portlbl2.id = "portlbl2";
		        dev.addPortLabel(portlbl2);
			break;
		case 15:
				// Adding the bottom port label1
		        var portlbl3 = new top.portLabel(584, 43, 7, 5, image1);
		        portlbl3.id = "portlbl3";
		        dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2
		        var portlbl4 = new top.portLabel(647, 43, 7, 5, image2);
		        portlbl4.id = "portlbl4";
		        dev.addPortLabel(portlbl4);
			break;
		case 25:
		case 49:
			// Adding the top port label1
				var portlbl = new top.portLabel(607, 8, 7, 5, image1);
				portlbl.id = "portlbl1";
				dev.addPortLabel(portlbl);

			 // Adding the top port label2
				var portlbl2 = new top.portLabel(629, 8, 7, 5, image2);
				portlbl2.id = "portlbl2";
				dev.addPortLabel(portlbl2);
			break;
		case 27:
		case 51:
		        // Adding the bottom port label1 
				var portlbl3 = new top.portLabel(607, 57, 7, 5, image1);
				portlbl3.id = "portlbl3";
				dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2 
				var portlbl4 = new top.portLabel(629, 57, 7, 5, image2);
				portlbl4.id = "portlbl4";
				dev.addPortLabel(portlbl4);
	}
}

function drawLeds_withoutPoE_pixar(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3580_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 29;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	//dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create Fa0 LED
	tempLed = new top.led(ledImages);
	tempLed.x = 69;
	tempLed.y = 67;
	tempLed.id = "fa_0";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
}

function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;

	switch(deviceType){
		case "WS-C2350-48TD":
			device = new WSC235048TD(int_status, media_type);
			break;
	} 

	if(device != null) {
		device.type = deviceType;
		device.family = "2350";
	}
			
	return device;
}
