<!-- Copyright (c) 2008-2010 by Cisco Systems, Inc. -->
// discover.js for c2360 devices - WS-C2360-48TD-S.


function WSC236048TD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2360_48.gif";

	drawLeds_duff(dev);
	//drawACOK_DCOKLEDs(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 51;//70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#"; 

	for (i=48;i<int_status.length;i++)
	{
		var code = 0;
		if(intNames[i].indexOf("0/49") != -1 || intNames[i].indexOf("Te0/1") != -1) code |=1;
		if(intNames[i].indexOf("0/50") != -1 || intNames[i].indexOf("Te0/2") != -1) code |=2;
		if(intNames[i].indexOf("0/51") != -1 || intNames[i].indexOf("Te0/3") != -1) code |=3;
		if(intNames[i].indexOf("0/52") != -1 || intNames[i].indexOf("Te0/4") != -1) code |=4;

		switch(code){
	
			case 1:
				portInd=48;
				xPortCoord = 563;//599;
				portWidth = 21;
				yPortCoord = 23;//15;
				if(intNames[i].indexOf("Te0/1") != -1) {
				port = new top.tenGbSFPport(int_status[i][6], portImages);
				port.width=21;
				addLabel(dev,1);
				}else{
				port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
				addLabel(dev,49);
				}
				port.index = portInd;
				port.x = xPortCoord;
				port.y = yPortCoord;
				port.id = "port_" + i;
				dev.addPort(port);
				break;
		case 2:
				portInd=49;
				xPortCoord = 563;//599;
				portWidth = 21;
				yPortCoord = 51;//15;
				if(intNames[i].indexOf("Te0/2") != -1){ 
				port = new top.tenGbSFPport(int_status[i][6], portImages);
				port.width=21;
				addLabel(dev,2);
				}else{
				port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
				addLabel(dev,50);
				}
				port.index = portInd;
				port.x = xPortCoord;
				port.y = yPortCoord;
				port.id = "port_" + i;
				dev.addPort(port);
				break;
		case 3:
				portInd=50;
				xPortCoord = 606;//599;
				portWidth = 21;
				yPortCoord = 23;//15;
				if(intNames[i].indexOf("Te0/3") != -1){
				port = new top.tenGbSFPport(int_status[i][6], portImages);
				port.width=21;
				addLabel(dev,3);
				}else{
				port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
				addLabel(dev,51);
				}
				
				port.index = portInd;
				port.x = xPortCoord;
				port.y = yPortCoord;
				port.id = "port_" + i;
				dev.addPort(port);
				break;
		case 4:
				portInd=51;
				xPortCoord = 606;//599;
				portWidth = 21;
				yPortCoord = 51;//15;
				if(intNames[i].indexOf("Te0/4") != -1){
				port = new top.tenGbSFPport(int_status[i][6], portImages);
				port.width=21;
				addLabel(dev,4);
				} else {
				port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
				addLabel(dev,52);
				}
				port.index = portInd;
				port.x = xPortCoord;
				port.y = yPortCoord;
				port.id = "port_" + i;
				dev.addPort(port);
				break;
			
		}
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function addLabel( dev, label1, label2 )
{
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(570, 42, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(570, 70, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 3:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(614, 42, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 4:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(614, 70, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 49:
			// Adding the top port label1
				var portlbl = new top.portLabel(570, 42, 7, 5, image1);
				portlbl.id = "portlbl1";
				dev.addPortLabel(portlbl);
			break;
		case 50:
			// Adding the top port label1
				var portlbl = new top.portLabel(570, 70, 7, 5, image1);
				portlbl.id = "portlbl1";
				dev.addPortLabel(portlbl);
			break;
		case 51:
		        // Adding the bottom port label1 
				var portlbl3 = new top.portLabel(614, 42, 7, 5, image1);
				portlbl3.id = "portlbl3";
				dev.addPortLabel(portlbl3);
				break;
		case 52:
		        // Adding the bottom port label1 
				var portlbl3 = new top.portLabel(614, 70, 7, 5, image1);
				portlbl3.id = "portlbl3";
				dev.addPortLabel(portlbl3);
				break;
		     
	}
}

function drawLeds_duff(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3580_mode.gif");
	modeBtn.x = 24;//30;
	modeBtn.y = 65;//63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 8;//16;
	tempLed.y = 24;//23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 8;
	tempLed.y = 30;//29;
	tempLed.id = "ps1_led";
	tempLed.device = dev;
	dev.sysleds["PS1"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 8;
	tempLed.y = 36;//29;
	tempLed.id = "ps2_led";
	tempLed.device = dev;
	dev.sysleds["PS2"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 8;//16;
	tempLed.y = 49;//37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 8;//16;
	tempLed.y = 55;//43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 8;//16;
	tempLed.y = 61;//49;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create FAN LED
	tempLed = new top.led(ledImages);
	tempLed.x = 8;//69;
	tempLed.y = 42;//67;
	tempLed.id = "fan_led";
	tempLed.device = dev;
	dev.sysleds["FAN"] = tempLed;
}

function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;

	switch(deviceType){
		case "WS-C2360-48TD-S":
			device = new WSC236048TD(int_status, media_type);
			break;
	} 

	if(device != null) {
		device.type = deviceType;
		device.family = "2360";
	}
			
	return device;
}
