/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SnmpString;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpIpAddress
extends SnmpString {
    public SnmpIpAddress(String string) {
        super("");
        this.Type = (byte)64;
        InetAddress inetAddress = null;
        try {
            if (string != null && !string.equals("0.0.0.0")) {
                inetAddress = InetAddress.getByName(string);
                this.value = new String(inetAddress.getAddress(), 0);
                return;
            }
            this.value = new String(new byte[4], 0);
            return;
        }
        catch (SecurityException securityException) {
            System.err.println("Security error creating SnmpIpAddress instance." + securityException);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Error creating SnmpIpAddress: invalid String arg." + unknownHostException);
            return;
        }
    }

    public SnmpIpAddress(byte[] byArray) {
        super("");
        if (byArray.length == 4) {
            this.value = new String(byArray, 0);
        } else {
            System.err.println("Error creating SnmpIpAddress: invalid byte arg.");
        }
        this.Type = (byte)64;
    }

    public String toString() {
        if (this.value.length() < 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        this.value.getBytes(0, 4, byArray, 0);
        return SnmpIpAddress.netbToString(byArray);
    }

    public String toTagString() {
        return new String("IpAddress: " + this.toString());
    }

    public String toHostName() {
        if (this.value.length() < 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        this.value.getBytes(0, 4, byArray, 0);
        try {
            return InetAddress.getByName(SnmpIpAddress.netbToString(byArray)).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return SnmpIpAddress.netbToString(byArray);
        }
    }

    byte[] encode() {
        int n = this.value.length();
        byte[] byArray = ASNTypes.build_header((byte)64, n);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.value.getBytes(0, n, byArray2, byArray.length);
        return byArray2;
    }

    public static String netbToString(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = ASNTypes.byteToInt(byArray[n]);
            ++n;
        }
        return new String(String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3]);
    }
}

