/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class HelpDialog
extends JDialog
implements ActionListener,
HyperlinkListener,
TreeSelectionListener,
TreeWillExpandListener,
PropertyChangeListener,
Runnable {
    private JApplet applet = null;
    protected String tocFileName = null;
    protected String codeBase = null;
    protected String docBase = null;
    protected AppletContext appContext = null;
    private JTree tocTree = null;
    private DefaultTreeModel tocTreeModel = null;
    protected DefaultMutableTreeNode tocRootNode = null;
    protected Hashtable tocUrlTable = new Hashtable();
    protected Hashtable tocTagTable = new Hashtable();
    private JEditorPane editorPane = null;
    protected Component glassPane;
    private boolean blockCursor;
    protected String inxFileName = null;
    private JTree inxTree = null;
    protected Hashtable inxUrlTable = new Hashtable();
    protected Hashtable inxTagTable = new Hashtable();
    private DefaultTreeModel inxTreeModel = null;
    protected DefaultMutableTreeNode inxRootNode = null;
    private int activeRow = 0;
    JTabbedPane tabs;
    private JTextField tfield;
    private JButton fButton;
    private JButton backButton;
    private JButton forwardButton;
    private Vector historyList;
    protected final int HISTORY_MAX = 10;
    private int historyInx = 0;
    private boolean revisiting = false;
    JCheckBox sensitiveCheck;
    JCheckBox matchAllCheck;
    private final int TOC = 0;
    private final int INX = 1;
    private int activeType = 0;
    private boolean sensitive = false;
    private boolean matchAll = false;
    protected final Color bgColor = Color.decode("#FAFAD2");
    private final String ONLINE_WINDOW = "CMS Online Help";
    private final String FEEDBACK_URL = "http://www.cisco.com/univercd/cc/td/doc/product/lan/c2900xl/helpsurv.htm";

    public HelpDialog(JApplet jApplet, String string) {
        this(jApplet, string, string);
    }

    public HelpDialog(JApplet jApplet, String string, String string2) {
        this.applet = jApplet;
        this.tocFileName = string;
        this.inxFileName = string2;
        this.codeBase = jApplet.getCodeBase().toString();
        this.appContext = jApplet.getAppletContext();
        this.docBase = jApplet.getDocumentBase().toString();
        this.docBase = this.docBase.substring(0, this.docBase.lastIndexOf("/"));
        if (!this.codeBase.endsWith("/")) {
            this.codeBase = String.valueOf(this.codeBase) + "/";
        }
        this.setTitle("Help Contents");
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(650, 550);
        ((Component)this).setVisible(false);
        this.buildTabPanel();
        JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
        this.editorPane = new JEditorPane(){

            protected InputStream getStream(URL uRL) throws IOException {
                URLConnection uRLConnection = uRL.openConnection();
                String string = uRLConnection.getContentType();
                if (string != null) {
                    this.setContentType(string);
                }
                InputStream inputStream = uRLConnection.getInputStream();
                return inputStream;
            }

            protected void scrollToReference(String string) {
                this.paintImmediately(this.getBounds());
                Document document = this.getDocument();
                if (document instanceof HTMLDocument) {
                    HTMLDocument hTMLDocument = (HTMLDocument)document;
                    HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
                    while (iterator.isValid()) {
                        AttributeSet attributeSet = iterator.getAttributes();
                        String string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                        if (string2 != null && string2.equals(string)) {
                            try {
                                Rectangle rectangle = this.modelToView(iterator.getStartOffset());
                                if (rectangle != null) {
                                    Rectangle rectangle2 = this.getVisibleRect();
                                    rectangle.height = rectangle2.height;
                                    this.scrollRectToVisible(rectangle);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                this.getToolkit().beep();
                            }
                            return;
                        }
                        iterator.next();
                    }
                }
            }
        };
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(this);
        this.editorPane.addPropertyChangeListener(this);
        this.editorPane.setBackground(this.bgColor);
        JScrollPane jScrollPane = new JScrollPane(this.editorPane, 22, 32);
        this.tabs.setPreferredSize(this.tabs.getMinimumSize());
        jScrollPane.setPreferredSize(new Dimension(390, 550));
        JSplitPane jSplitPane = new JSplitPane(1, this.tabs, jScrollPane);
        jSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.setDefaultCloseOperation(1);
        this.glassPane = this.getGlassPane();
        this.glassPane.addMouseListener(CommonApplet.gpMouseAdapter);
        this.glassPane.addKeyListener(CommonApplet.gpKeyAdapter);
        this.historyList = new Vector(10);
        this.pack();
        this.show();
        this.tocTree.setSelectionRow(0);
    }

    static /* synthetic */ int access$2(HelpDialog helpDialog) {
        return helpDialog.activeType;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fButton || actionEvent.getSource() == this.tfield) {
            this.setInputBlocked(true);
            System.out.println("find button clicked");
            String string = this.tfield.getText();
            if (string == null || string.length() == 0) {
                this.setInputBlocked(false);
                return;
            }
            TreePath treePath = this.searchInxTree(string);
            if (treePath != null) {
                this.inxTree.scrollPathToVisible(treePath);
                this.inxTree.setSelectionPath(treePath);
                System.out.println("at row: " + this.activeRow);
                this.setInputBlocked(false);
            } else {
                System.out.println("Search failed: No match found");
                this.setInputBlocked(false);
                JOptionPane.showMessageDialog(this, "Search reach the end.", "Search", 1);
                this.activeRow = 0;
            }
        } else if (actionEvent.getSource() == this.sensitiveCheck) {
            this.sensitive = this.sensitiveCheck.isSelected();
        } else if (actionEvent.getSource() == this.matchAllCheck) {
            this.matchAll = this.matchAllCheck.isSelected();
        }
    }

    private void addHistory(String string) {
        if (this.revisiting) {
            this.revisiting = false;
            return;
        }
        if (this.historyList.size() > 0) {
            System.out.println("last:" + (String)this.historyList.elementAt(this.historyInx) + "now: " + string);
            if (((String)this.historyList.elementAt(this.historyInx)).equals(string)) {
                return;
            }
        }
        int n = this.historyInx + 1;
        while (n < this.historyList.size()) {
            this.historyList.removeElementAt(n);
        }
        if (this.historyList.size() == this.historyList.capacity()) {
            this.historyList.removeElementAt(0);
        }
        this.historyList.addElement(string);
        this.historyInx = this.historyList.size() - 1;
        this.forwardButton.setEnabled(false);
        if (this.historyInx > 0) {
            this.backButton.setEnabled(true);
        }
        System.out.println("add history to " + this.historyInx + ": " + string);
    }

    private JPanel buildInxPanel() {
        this.inxRootNode = new DefaultMutableTreeNode(new SpecInfo(0, "CMS Help: INDEX", "", ""));
        this.inxTreeModel = new DefaultTreeModel(this.inxRootNode);
        this.inxTree = new JTree(this.inxTreeModel);
        this.activeRow = 0;
        SpecReader specReader = new SpecReader(1);
        try {
            specReader.readAndAddItems();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        specReader = null;
        this.inxTree.setRootVisible(false);
        this.inxTree.setShowsRootHandles(false);
        this.inxTree.setBackground(this.bgColor);
        this.inxTree.setScrollsOnExpand(true);
        this.inxTree.getSelectionModel().setSelectionMode(4);
        this.inxTree.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.inxTree);
        HelpTreeCellRenderer helpTreeCellRenderer = new HelpTreeCellRenderer(1);
        this.inxTree.setCellRenderer(helpTreeCellRenderer);
        int n = 0;
        while (n < this.inxRootNode.getChildCount()) {
            this.inxTree.collapsePath(new TreePath(((DefaultMutableTreeNode)this.inxRootNode.getChildAt(n)).getLastLeaf().getPath()));
            ++n;
        }
        this.inxTree.addTreeWillExpandListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.inxTree, 20, 30);
        jScrollPane.setBackground(this.bgColor);
        this.tfield = new JTextField(10);
        this.tfield.setEditable(true);
        this.tfield.addActionListener(this);
        this.fButton = new JButton("Find");
        this.fButton.setMnemonic('F');
        this.fButton.addActionListener(this);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(15);
        JPanel jPanel = new JPanel(borderLayout);
        jPanel.add((Component)this.tfield, "Center");
        jPanel.add((Component)this.fButton, "East");
        this.sensitiveCheck = new JCheckBox("Match Case", false);
        this.sensitiveCheck.addActionListener(this);
        this.matchAllCheck = new JCheckBox("Match Whole Word", false);
        this.matchAllCheck.addActionListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.sensitiveCheck, "West");
        jPanel2.add((Component)this.matchAllCheck, "East");
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel3.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add(Box.createRigidArea(new Dimension(10, 1)), "East");
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add(Box.createRigidArea(new Dimension(10, 1)), "West");
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel4.add(Box.createRigidArea(new Dimension(1, 10)), "South");
        return jPanel4;
    }

    private void buildTabPanel() {
        this.tabs = new JTabbedPane();
        this.tabs.setBorder(new BevelBorder(0));
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (((JTabbedPane)changeEvent.getSource()).getSelectedIndex() == 0) {
                    HelpDialog.this.activeType = 0;
                } else if (((JTabbedPane)changeEvent.getSource()).getSelectedIndex() == 1) {
                    HelpDialog.this.activeType = 1;
                }
            }
        });
        JPanel jPanel = this.buildTocPanel();
        this.tabs.addTab("Contents", null, jPanel, "Table of Contents of Help");
        JPanel jPanel2 = this.buildInxPanel();
        this.tabs.addTab("Index", null, jPanel2, "Indexes on Help");
    }

    private JPanel buildTocPanel() {
        this.tocRootNode = new DefaultMutableTreeNode(new SpecInfo(0, "CMS Help: TOC", "", ""));
        this.tocTreeModel = new DefaultTreeModel(this.tocRootNode);
        this.tocTree = new JTree(this.tocTreeModel);
        SpecReader specReader = new SpecReader(0);
        try {
            specReader.readAndAddItems();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        specReader = null;
        this.tocTree.setRootVisible(false);
        this.tocTree.setShowsRootHandles(true);
        this.tocTree.putClientProperty("JTree.lineStyle", "Angled");
        this.tocTree.setScrollsOnExpand(true);
        this.tocTree.setBackground(this.bgColor);
        this.tocTree.getSelectionModel().setSelectionMode(4);
        this.tocTree.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.tocTree);
        this.tocTree.setCellRenderer(new HelpTreeCellRenderer(0));
        JScrollPane jScrollPane = new JScrollPane(this.tocTree);
        jScrollPane.setBackground(this.bgColor);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)), "South");
        jPanel2.add(Box.createRigidArea(new Dimension(10, 1)), "West");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add(Box.createRigidArea(new Dimension(10, 1)), "East");
        return jPanel2;
    }

    protected void feedback() {
        try {
            int n = JOptionPane.showConfirmDialog(this, "You have chosen an external link.\nWould you like to open a browser window to view it?", "Warning: External Link", 0, 2);
            if (n == 0) {
                this.appContext.showDocument(new URL("http://www.cisco.com/univercd/cc/td/doc/product/lan/c2900xl/helpsurv.htm"), "FEEDBACK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private URL findURL(DefaultMutableTreeNode defaultMutableTreeNode) {
        SpecInfo specInfo = (SpecInfo)defaultMutableTreeNode.getUserObject();
        String string = specInfo.getUrl();
        if (string.equals("")) {
            return null;
        }
        try {
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                uRL = new URL(String.valueOf(this.codeBase) + string);
            }
            return uRL;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private JPanel getTopPanel() {
        JPanel jPanel = new JPanel();
        this.backButton = new JButton("Back");
        this.backButton.setMnemonic('B');
        this.backButton.setEnabled(false);
        jPanel.add(this.backButton);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog.this.goBack();
            }
        });
        this.forwardButton = new JButton("Forward");
        this.forwardButton.setMnemonic('F');
        this.forwardButton.setEnabled(false);
        jPanel.add(this.forwardButton);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog.this.goForward();
            }
        });
        JButton jButton = new JButton("Feedback");
        jButton.setMnemonic('F');
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog.this.feedback();
            }
        });
        return jPanel;
    }

    private void goBack() {
        --this.historyInx;
        if (this.historyInx < 0) {
            System.out.println("Nothing to go back");
            this.historyInx = 0;
            this.backButton.setEnabled(false);
            return;
        }
        System.out.println("go back to " + this.historyInx);
        this.revisiting = true;
        if (this.historyInx == 0) {
            this.backButton.setEnabled(false);
        }
        this.showUrl((String)this.historyList.elementAt(this.historyInx));
        this.forwardButton.setEnabled(true);
    }

    private void goForward() {
        ++this.historyInx;
        if (this.historyInx >= this.historyList.size()) {
            System.out.println("Nothing to go forward");
            this.historyInx = this.historyList.size() - 1;
            this.forwardButton.setEnabled(false);
            return;
        }
        this.revisiting = true;
        if (this.historyInx == this.historyList.size() - 1) {
            this.forwardButton.setEnabled(false);
        }
        this.showUrl((String)this.historyList.elementAt(this.historyInx));
        this.backButton.setEnabled(true);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getURL().toString();
            System.out.println("url" + string);
            System.out.println("codeBase" + this.codeBase);
            System.out.println("docBase" + this.docBase);
            if (string.indexOf(this.codeBase) > -1 || string.indexOf(this.docBase) > -1) {
                this.addHistory(string);
                this.showUrl(string);
            } else {
                int n = JOptionPane.showConfirmDialog(this, "You have chosen an external link.\nWould you like to open a browser window to view it?", "Warning: External Link", 0, 2);
                if (n == 0) {
                    this.appContext.showDocument(hyperlinkEvent.getURL(), "CMS Online Help");
                }
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        final PropertyChangeEvent propertyChangeEvent2 = propertyChangeEvent;
        String string = propertyChangeEvent2.getPropertyName();
        if (!string.equalsIgnoreCase("page")) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("event dispatch thread");
            this.setInputBlocked(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    this.propertyChange(propertyChangeEvent2);
                }
            });
        }
    }

    public void run() {
        this.setInputBlocked(true);
        DefaultMutableTreeNode defaultMutableTreeNode = this.activeType == 0 ? (DefaultMutableTreeNode)this.tocTree.getLastSelectedPathComponent() : (DefaultMutableTreeNode)this.inxTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            this.setInputBlocked(false);
            return;
        }
        SpecInfo specInfo = (SpecInfo)defaultMutableTreeNode.getUserObject();
        if (specInfo.getUrl().equals("")) {
            this.setInputBlocked(false);
            return;
        }
        try {
            URL uRL = this.getClass().getResource(specInfo.getUrl());
            if (uRL == null) {
                uRL = new URL(String.valueOf(this.codeBase) + specInfo.getUrl());
            }
            System.out.println("url to run: " + uRL.toString());
            URL uRL2 = this.editorPane.getPage();
            if (uRL != null && uRL2 != null && uRL.equals(uRL2)) {
                this.editorPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                this.setInputBlocked(false);
                if (this.revisiting) {
                    this.revisiting = false;
                } else {
                    this.addHistory(uRL.toString());
                }
            } else {
                this.editorPane.setPage(uRL);
                this.addHistory(uRL.toString());
                if (this.activeType == 1) {
                    this.activeRow = this.inxTree.getMinSelectionRow() + 1;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showFileNotFound(specInfo.getUrl());
            this.setInputBlocked(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private TreePath searchInxTree(String string) {
        while (this.activeRow < this.inxTree.getRowCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.inxTree.getPathForRow(this.activeRow).getLastPathComponent();
            String string2 = ((SpecInfo)defaultMutableTreeNode.getUserObject()).toString();
            ++this.activeRow;
            if (!this.sensitive && !this.matchAll) {
                if (string2.toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
                System.out.println("found");
                return new TreePath(defaultMutableTreeNode.getPath());
            }
            if (this.sensitive && this.matchAll) {
                if (!string2.equals(string)) continue;
                System.out.println("found");
                return new TreePath(defaultMutableTreeNode.getPath());
            }
            if (this.sensitive) {
                if (string2.indexOf(string) <= -1) continue;
                System.out.println("found");
                return new TreePath(defaultMutableTreeNode.getPath());
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            System.out.println("found");
            return new TreePath(defaultMutableTreeNode.getPath());
        }
        return null;
    }

    protected void setBlockCursor(boolean bl) {
        this.blockCursor = bl;
    }

    public void setCursor(Cursor cursor) {
        if (!this.blockCursor) {
            super.setCursor(cursor);
        }
    }

    public void setInputBlocked(boolean bl) {
        this.glassPane.setVisible(bl);
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setBlockCursor(true);
            System.out.println("blocking");
        } else {
            this.setBlockCursor(false);
            this.setCursor(Cursor.getPredefinedCursor(0));
            System.out.println("releasing blocking");
        }
    }

    public void setTooltipRenderer(JTree jTree) {
        jTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                this.setToolTipText(object.toString());
                return this;
            }
        });
    }

    public void showFileNotFound(String string) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(this, "Unknown help file: " + string, "Error", 0);
    }

    public void showTag(String string) {
        if (string == null || string.equals("")) {
            this.showUrl(string);
            return;
        }
        String string2 = this.activeType == 0 ? (String)this.tocTagTable.get(string) : (String)this.inxTagTable.get(string);
        if (string2 == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Unknown help tag: " + string, "Error", 0);
        }
        this.showUrl(string2);
    }

    public void showUrl(String string) {
        this.setInputBlocked(true);
        TreePath treePath = null;
        if (string == null || string.equals("")) {
            int[] nArray = this.activeType == 0 ? this.tocTree.getSelectionRows() : this.inxTree.getSelectionRows();
            if (nArray != null && nArray.length != 0 && nArray[0] == 0) {
                this.setInputBlocked(false);
            }
            if (this.activeType == 0) {
                this.tocTree.scrollRowToVisible(0);
                this.tocTree.setSelectionRow(0);
            } else {
                this.inxTree.scrollRowToVisible(0);
                this.inxTree.setSelectionRow(0);
            }
            return;
        }
        String string2 = string;
        String string3 = "!/";
        int n = string3.length();
        int n2 = string.lastIndexOf(string3);
        if (n2 > -1 && n2 + n < string.length()) {
            string2 = string.substring(n2 + n);
        } else if (string.indexOf(this.codeBase) > -1) {
            string2 = string.substring(this.codeBase.length());
        }
        System.out.println("url " + string2);
        DefaultMutableTreeNode defaultMutableTreeNode = this.activeType == 0 ? (DefaultMutableTreeNode)this.tocUrlTable.get(string2) : (DefaultMutableTreeNode)this.inxUrlTable.get(string2);
        if (defaultMutableTreeNode == null) {
            if (this.activeType == 0) {
                this.tocTree.clearSelection();
            } else {
                this.inxTree.clearSelection();
            }
            try {
                URL uRL = new URL(string);
                URL uRL2 = this.editorPane.getPage();
                System.out.println("from: " + uRL2.toString() + ":" + uRL2.getRef() + " to: " + uRL.toString() + ":" + uRL.getRef());
                if (uRL2.sameFile(uRL)) {
                    System.out.println("same url");
                }
                String string4 = uRL.getRef();
                if (uRL != null && uRL2 != null && uRL.equals(uRL2)) {
                    this.editorPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                    this.setInputBlocked(false);
                } else {
                    this.editorPane.setPage(uRL);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showFileNotFound(string);
                this.setInputBlocked(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        try {
            TreePath treePath2;
            if (this.activeType == 0) {
                treePath = new TreePath(this.tocTreeModel.getPathToRoot(defaultMutableTreeNode));
                treePath2 = this.tocTree.getSelectionPath();
            } else {
                treePath = new TreePath(this.inxTreeModel.getPathToRoot(defaultMutableTreeNode));
                treePath2 = this.inxTree.getSelectionPath();
            }
            if (treePath.equals(treePath2)) {
                this.setInputBlocked(false);
            }
            if (this.activeType == 0) {
                this.tocTree.setSelectionPath(treePath);
                this.tocTree.scrollPathToVisible(treePath);
            } else {
                this.inxTree.setSelectionPath(treePath);
                this.inxTree.scrollPathToVisible(treePath);
            }
        }
        catch (Exception exception) {}
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        throw new ExpandVetoException(treeExpansionEvent);
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.setInputBlocked(true);
        SwingUtilities.invokeLater(this);
    }

    protected class SpecInfo {
        private int level;
        private String title;
        private String url;
        private String tag;

        protected SpecInfo(int n, String string, String string2, String string3) {
            this.level = n;
            this.title = string;
            this.url = string2;
            this.tag = string3;
        }

        protected int getLevel() {
            return this.level;
        }

        protected String getTag() {
            return this.tag;
        }

        protected String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.title;
        }
    }

    protected class SpecReader {
        private StreamTokenizer spec = null;
        private int currentLevel = 0;
        private DefaultMutableTreeNode[] currNodeAtLevel = new DefaultMutableTreeNode[10];
        int type = 0;

        protected SpecReader(int n) {
            this.type = n;
            this.currNodeAtLevel[0] = n == 0 ? HelpDialog.this.tocRootNode : HelpDialog.this.inxRootNode;
        }

        private void addItem(SpecInfo specInfo) {
            String string;
            int n = specInfo.getLevel();
            if (n < 1) {
                System.out.println("ERROR: TOC item \"" + specInfo + "\" at invalid level: " + n);
                return;
            }
            if (n > this.currentLevel && n != this.currentLevel + 1) {
                System.out.print("ERROR: TOC item \"" + specInfo + "\"");
                System.out.println(" at level " + n + "; currLevel = " + this.currentLevel);
                return;
            }
            String string2 = specInfo.getTag();
            if (!string2.equals("") && (string = this.type == 0 ? (String)HelpDialog.this.tocTagTable.get(string2) : (String)HelpDialog.this.inxTagTable.get(string2)) != null) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(HelpDialog.this, "The tag \"" + string2 + "\" is not unique.\n" + "It already represents \"" + string + "\"", "Error", 0);
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.currNodeAtLevel[n - 1];
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(specInfo);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.currentLevel = n;
            this.currNodeAtLevel[this.currentLevel] = defaultMutableTreeNode2;
            string = specInfo.getUrl();
            if (this.type == 0) {
                HelpDialog.this.tocUrlTable.put(string, defaultMutableTreeNode2);
                HelpDialog.this.tocTagTable.put(string2, string);
            } else {
                HelpDialog.this.inxUrlTable.put(string, defaultMutableTreeNode2);
                HelpDialog.this.inxTagTable.put(string2, string);
            }
        }

        protected void readAndAddItems() throws IOException {
            URL uRL;
            int n = 0;
            SpecInfo specInfo = null;
            if (this.type == 0) {
                uRL = this.getClass().getResource(HelpDialog.this.tocFileName);
                if (uRL == null) {
                    uRL = new URL(String.valueOf(HelpDialog.this.codeBase) + HelpDialog.this.tocFileName);
                }
            } else {
                uRL = this.getClass().getResource(HelpDialog.this.inxFileName);
                if (uRL == null) {
                    uRL = new URL(String.valueOf(HelpDialog.this.codeBase) + HelpDialog.this.inxFileName);
                }
            }
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.spec = new StreamTokenizer(bufferedReader);
            while ((specInfo = this.readItem(++n)) != null) {
                this.addItem(specInfo);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }

        private SpecInfo readItem(int n) throws IOException {
            this.spec.nextToken();
            if (this.spec.ttype == -1) {
                return null;
            }
            if (this.spec.ttype != -2) {
                System.out.println("TOC level missing on line " + n);
                return null;
            }
            int n2 = (int)this.spec.nval;
            this.spec.nextToken();
            if (this.spec.ttype != 44) {
                System.out.println("Comma missing on line " + n);
                return null;
            }
            this.spec.nextToken();
            if (this.spec.ttype != 34) {
                System.out.println("TOC title missing on line " + n);
                return null;
            }
            String string = this.spec.sval.trim();
            this.spec.nextToken();
            if (this.spec.ttype != 44) {
                System.out.println("Comma missing on line " + n);
                return null;
            }
            this.spec.nextToken();
            if (this.spec.ttype != 34) {
                System.out.println("TOC URL missing on line " + n);
                return null;
            }
            String string2 = this.spec.sval.trim();
            this.spec.nextToken();
            if (this.spec.ttype != 44) {
                System.out.println("Comma missing on line " + n);
                return null;
            }
            this.spec.nextToken();
            if (this.spec.ttype != 34) {
                System.out.println("TOC tag missing on line " + n);
                return null;
            }
            String string3 = this.spec.sval.trim();
            SpecInfo specInfo = new SpecInfo(n2, string, string2, string3);
            return specInfo;
        }
    }

    public static class Factory {
        public static void showHelp(JApplet jApplet, String string) {
            HelpDialog helpDialog = ((CommonApplet)jApplet).getHelpDialog();
            helpDialog.showTag(string);
            helpDialog.setModal(false);
            helpDialog.show();
        }
    }

    class HelpTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private int treeType = 0;

        public HelpTreeCellRenderer(int n) {
            this.treeType = n;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (this.treeType == 1) {
                this.setIcon(null);
            }
            this.setBackgroundNonSelectionColor(HelpDialog.this.bgColor);
            this.setToolTipText(object.toString());
            return this;
        }
    }
}

