/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class DeviceComboDialog
extends DeviceDialog {
    protected CommonSwitch[] devices;
    protected CommonSwitch defaultDevice;
    protected DeviceListItem deviceListItem;
    protected CommonSwitch device;
    protected JLabel hostName;
    private JPanel devicePanel;
    private JLabel deviceLabel;
    private JComboBox deviceComboBox;

    public DeviceComboDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null);
    }

    public DeviceComboDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(jApplet);
        this.devices = commonSwitchArray;
        this.defaultDevice = commonSwitch;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deviceComboBox) {
            this.deviceComboBox_Action();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void deviceChanged() {
    }

    private void deviceComboBox_Action() {
        boolean bl;
        DeviceListItem deviceListItem = (DeviceListItem)this.deviceComboBox.getSelectedItem();
        if (deviceListItem == this.deviceListItem) {
            return;
        }
        if (this.uiChanged && !(bl = this.getDiscardConfirmation())) {
            this.deviceComboBox.setSelectedItem(this.deviceListItem);
            return;
        }
        this.setPreventUserOps(true);
        this.deviceListItem = deviceListItem;
        this.device = deviceListItem.device;
        this.deviceChanged();
        this.getConfig();
    }

    protected DeviceListItem getNewDeviceListItem(CommonSwitch commonSwitch) {
        return new DeviceListItem(commonSwitch);
    }

    public void hookupListeners() {
        super.hookupListeners();
        this.deviceComboBox.addActionListener(this);
    }

    public void initializeMembers() {
        super.initializeMembers();
        this.deviceListItem = null;
        this.device = null;
    }

    protected abstract boolean isDeviceSupported(CommonSwitch var1);

    protected void layoutWidgets() {
        super.layoutWidgets();
        this.deviceComboBox = new JComboBox();
        this.deviceLabel = new JLabel("Host Name:");
        this.devicePanel = new JPanel();
        this.devicePanel.add(this.deviceLabel);
        this.devicePanel.add(this.deviceComboBox);
        if (this.applet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.hostName = new JLabel("");
            this.devicePanel.add(this.hostName);
            this.deviceComboBox.setVisible(false);
            this.devicePanel.setBorder(BorderFactory.createTitledBorder(""));
        } else {
            this.devicePanel.setBorder(BorderFactory.createTitledBorder("Device List"));
        }
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.devicePanel, gridBagConstraints);
    }

    protected void populateDeviceList() {
        int n = 0;
        this.setPreventUserOps(true);
        int n2 = 0;
        while (n2 < this.devices.length) {
            CommonSwitch commonSwitch = this.devices[n2];
            if (!commonSwitch.statusCode.equals("Down") && this.isDeviceSupported(commonSwitch)) {
                this.deviceComboBox.insertItemAt(this.getNewDeviceListItem(commonSwitch), n);
                ++n;
                if (this.applet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
                    this.hostName.setText(commonSwitch.switchName);
                }
            }
            ++n2;
        }
        this.selectDefaultDevice();
    }

    protected void selectDefaultDevice() {
        if (this.defaultDevice == null) {
            this.deviceComboBox.setSelectedIndex(0);
        } else {
            DeviceListItem deviceListItem = this.getNewDeviceListItem(this.defaultDevice);
            this.deviceComboBox.setSelectedItem(deviceListItem);
        }
    }
}

