/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BaudRate
extends DeviceListDialog {
    protected JPanel gui;
    protected JComboBox speedCombo;

    public BaudRate(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null);
    }

    public BaudRate(JApplet jApplet, CommonSwitch[] commonSwitchArray, Vector vector) {
        super(jApplet, commonSwitchArray, vector);
        this.constructorInit();
        if (vector != null) {
            Object[] objectArray = new CommonSwitch[vector.size()];
            vector.copyInto(objectArray);
            if (vector.size() == 1) {
                String string = ((CommonSwitch)objectArray[0]).Cli.getBaudRate(((CommonSwitch)objectArray[0]).esn);
                this.speedCombo.setSelectedItem(string);
            }
        }
    }

    protected String getButtonsNeeded() {
        String string = "OK CANCEL HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        this.gui = new JPanel();
        this.speedCombo = new JComboBox<String>(new String[]{"    ", "2400", "9600", "19200", "38400", "57600", "115200"});
        this.gui.add(this.speedCombo);
        this.gui.setBorder(BorderFactory.createTitledBorder("Console Baud Rate"));
        return this.gui;
    }

    protected String getHelpUrl() {
        return "bdratedg";
    }

    protected void getMirrorObjects(Vector vector) {
        vector.addElement(new Speed());
    }

    protected String getWindowTitle() {
        return "Console Baud Rate";
    }

    protected boolean isDeviceSupported(CommonSwitch commonSwitch) {
        return Switch.type(commonSwitch.switchBoxName) != 0;
    }

    protected void isSelectionCompatible(int[] nArray) {
    }

    protected void listsChanged() {
        super.listsChanged();
        if (this.selectedListModel.getSize() > 1) {
            this.speedCombo.setSelectedItem("    ");
        }
        if (this.selectedListModel.getSize() == 1) {
            DeviceListItem deviceListItem = (DeviceListItem)this.selectedListModel.get(0);
            CommonSwitch commonSwitch = deviceListItem.device;
            String string = commonSwitch.Cli.getBaudRate(commonSwitch.esn);
            this.speedCombo.setSelectedItem(string);
        }
        if (this.selectedListModel.getSize() == 0) {
            this.speedCombo.setSelectedItem("    ");
        }
        boolean bl = this.selectedListModel.isEmpty();
        DeviceDialog.setContainerEnabled(this.gui, bl ^ true);
        this.enableOk = bl ^ true;
        this.uiChanged = bl ^ true;
        this.updateBottomButtons();
    }

    protected class Speed
    implements DeviceMirrorObject {
        protected String[] baudRate;

        protected Speed() {
        }

        public void hookupListeners() {
        }

        public void initializeMembers() {
            this.baudRate = new String[2];
            BaudRate.this.setOkButtonText("Set Baud Rate");
        }

        public void updateDeviceFromMirror() {
            int n = 0;
            while (n < BaudRate.this.selectedListModel.size()) {
                DeviceListItem deviceListItem = (DeviceListItem)BaudRate.this.selectedListModel.get(n);
                CommonSwitch commonSwitch = deviceListItem.device;
                String string = commonSwitch.Cli.setBaudRate(commonSwitch.esn, this.baudRate[1]);
                BaudRate.this.displayUserError(string);
                ++n;
            }
        }

        public void updateGuiFromMirror() {
        }

        public void updateMirrorFromDevice() {
        }

        public void updateMirrorFromGui() {
            this.baudRate[1] = (String)BaudRate.this.speedCombo.getSelectedItem();
        }
    }
}

