/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ManagementVLAN_JDialog
extends CustomMinimumSize_JDialog
implements ActionListener {
    private JApplet applet;
    private CommonSwitch[] switchMembers;
    private int switchIndex = 0;
    private MgmtVLAN_JListDataModel model = new MgmtVLAN_JListDataModel();
    private String prevMgmtVlanID;
    private boolean fromCM = true;
    boolean frameSizeAdjusted = false;
    JButton select_JButton;
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    Icon addIcon;
    JPanel availableVLANs_JPanel;
    JPanel currentMgmtVLAN_JPanel;
    JPanel actionButtons_JPanel;
    JLabel vlanID_JLabel;
    JLabel vlanIDData_JLabel;
    JLabel selectedID_JLabel;
    JList availableVLAN_JList;
    JScrollPane availableVLAN_JScrollPane;

    public ManagementVLAN_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        super(frame);
        this.applet = jApplet;
        this.switchMembers = commonSwitchArray;
        String string = this.applet.getClass().getName();
        this.fromCM = true;
        if (string != null && string.equalsIgnoreCase("DeviceManager")) {
            this.fromCM = false;
        }
        int n = 0;
        while (n < this.switchMembers.length) {
            if (this.switchMembers[n].memberType.equals("CC") || this.switchMembers[n].memberType.equals("AC")) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
        this.setTitle("Management VLAN");
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setSize(439, 231);
        this.setVisible(false);
        this.availableVLANs_JPanel = new JPanel(new BorderLayout(0, 0));
        this.availableVLANs_JPanel.setBorder(BorderFactory.createTitledBorder("Available VLANs"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().add((Component)this.availableVLANs_JPanel, this.setGridBagConstraints(gridBagConstraints, 0, 0, 0.1, 0.1, 1, 0, 0, 17, 20, 20, 20, 10, 1, 1));
        this.availableVLAN_JList = new JList();
        this.availableVLAN_JList.setSelectionMode(0);
        this.availableVLAN_JList.setFixedCellHeight(15);
        this.availableVLAN_JList.setFixedCellWidth(80);
        this.availableVLAN_JScrollPane = new JScrollPane(this.availableVLAN_JList);
        this.availableVLANs_JPanel.add((Component)this.availableVLAN_JScrollPane, "Center");
        this.addIcon = new ImageIcon(SVGetImages.rightArrow);
        this.select_JButton = new JButton("Select", this.addIcon);
        this.select_JButton.addActionListener(this);
        this.select_JButton.setHorizontalTextPosition(2);
        this.getContentPane().add((Component)this.select_JButton, this.setGridBagConstraints(gridBagConstraints, 1, 0, 0.0, 0.0, 0, 0, 0, 10, 0, 10, 0, 0, 1, 1));
        this.currentMgmtVLAN_JPanel = new JPanel(new BorderLayout());
        this.currentMgmtVLAN_JPanel.setBorder(BorderFactory.createTitledBorder("Current Management VLAN"));
        this.getContentPane().add((Component)this.currentMgmtVLAN_JPanel, this.setGridBagConstraints(gridBagConstraints, 2, 0, 0.1, 0.0, 2, 0, 0, 10, 0, 20, 0, 0, 1, 1));
        this.vlanID_JLabel = new JLabel(" VLAN ID:  ");
        this.selectedID_JLabel = new JLabel("");
        this.currentMgmtVLAN_JPanel.add((Component)this.vlanID_JLabel, "West");
        this.currentMgmtVLAN_JPanel.add((Component)this.selectedID_JLabel, "Center");
        this.actionButtons_JPanel = new JPanel();
        this.getContentPane().add((Component)this.actionButtons_JPanel, this.setGridBagConstraints(gridBagConstraints, 0, 2, 0.1, 0.0, 2, 0, 0, 10, 0, 0, 0, 0, 1, 3));
        this.ok_JButton = new JButton("OK");
        this.ok_JButton.addActionListener(this);
        this.actionButtons_JPanel.add(this.ok_JButton);
        this.cancel_JButton = new JButton("Cancel");
        this.cancel_JButton.addActionListener(this);
        this.actionButtons_JPanel.add(this.cancel_JButton);
        this.help_JButton = new JButton("Help");
        this.help_JButton.addActionListener(this);
        this.actionButtons_JPanel.add(this.help_JButton);
        CommonIOSCLIs commonIOSCLIs = new CommonIOSCLIs(this.applet);
        String[] stringArray = commonIOSCLIs.getVlanIDs(null);
        String string2 = commonIOSCLIs.getCurrentMgmtVlanID(null);
        string2.trim();
        this.selectedID_JLabel.setText(string2);
        this.prevMgmtVlanID = string2;
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2].trim();
            if (!string2.equalsIgnoreCase(stringArray[n2])) {
                this.model.insertValue(Integer.parseInt(stringArray[n2]));
            }
            ++n2;
        }
        this.availableVLAN_JList.setModel(this.model);
        ((Component)this).setSize(520, 300);
        this.setMinimumWidth(this.getSize().width);
        this.setMinimumHeight(this.getSize().height);
    }

    public ManagementVLAN_JDialog(String string, JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray);
        this.setTitle(string);
    }

    public ManagementVLAN_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this((Frame)null, jApplet, commonSwitchArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.select_JButton) {
            int n = this.availableVLAN_JList.getSelectedIndex();
            if (n >= 0) {
                String string = this.selectedID_JLabel.getText();
                this.selectedID_JLabel.setText(this.model.getValueAt(n).toString());
                this.model.deleteValue(n);
                this.model.insertValue(Integer.parseInt(string));
                this.availableVLAN_JList.clearSelection();
                this.availableVLAN_JScrollPane.revalidate();
                this.availableVLAN_JScrollPane.repaint();
            }
        } else if (actionEvent.getSource() == this.ok_JButton) {
            int n;
            if (!this.prevMgmtVlanID.equalsIgnoreCase(this.selectedID_JLabel.getText().trim()) && (n = JOptionPane.showConfirmDialog(null, "You could lose some connections by changing Manangement VLAN.\nDo you want to continue?", "Confirmation", 0, 3)) == 0) {
                CommonIOSCLIs commonIOSCLIs = new CommonIOSCLIs(this.applet);
                if (this.fromCM) {
                    String string = commonIOSCLIs.setClusterMgmtVlanID(this.selectedID_JLabel.getText().trim());
                } else {
                    String string = commonIOSCLIs.setDeviceMgmtVlanID(this.switchMembers[this.switchIndex].esn, this.selectedID_JLabel.getText().trim());
                }
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.cancel_JButton) {
            this.dispose();
        } else if (actionEvent.getSource() == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.applet, (String)"mgmtvlan");
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public static void main(String[] stringArray) {
        new ManagementVLAN_JDialog(null, null).setVisible(true);
    }

    public GridBagConstraints setGridBagConstraints(GridBagConstraints gridBagConstraints, int n, int n2, double d, double d2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n3;
        gridBagConstraints.gridheight = n11;
        gridBagConstraints.gridwidth = n12;
        gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }
}

