/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class PortConfigGroup_JDialog
extends JDialog
implements ActionListener,
ItemListener {
    boolean frameSizeAdjusted = false;
    JPanel portConfig_JPanel = new JPanel();
    JLabel portDescription_JLabel = new JLabel("Description:");
    JLabel portStatus_JLabel = new JLabel("Status:");
    JLabel portDuplex_JLabel = new JLabel("Duplex:");
    JLabel portSpeed_JLabel = new JLabel("Speed:");
    JLabel portFast_JLabel = new JLabel("Port Fast:");
    JLabel QoS8021p_JLabel = new JLabel("802.1p Priority:");
    JLabel flowControl_JLabel = new JLabel("Flow Control:");
    JLabel power_JLabel = new JLabel("Inline Power: ");
    JTextField portDescription_JTextField = new JTextField(15);
    String[] status = new String[]{" ", "Enable", "Disable"};
    JComboBox portStatus_JComboBox = new JComboBox<String>(this.status);
    String[] duplex = new String[]{" ", "Half", "Full", "Auto", "Full with Flow Control"};
    JComboBox portDuplex_JComboBox = new JComboBox<String>(this.duplex);
    String[] speed = new String[]{" ", "10", "100", "Auto"};
    JComboBox portSpeed_JComboBox = new JComboBox<String>(this.speed);
    String[] portFast = new String[]{" ", "Enable", "Disable"};
    JComboBox portFast_JComboBox = new JComboBox<String>(this.portFast);
    String[] Qos = new String[]{" ", "0", "1", "2", "3", "4", "5", "6", "7"};
    JComboBox QoS8021p_JComboBox = new JComboBox<String>(this.Qos);
    String[] flowControl = new String[]{" ", "None", "Asymmetric", "Symmetric", "Any"};
    JComboBox flowControl_JComboBox = new JComboBox<String>(this.flowControl);
    String[] power = new String[]{" ", "auto", "never"};
    JComboBox power_JComboBox = new JComboBox<String>(this.power);
    JButton ok_JButton = new JButton("OK");
    JButton cancel_JButton = new JButton("Cancel");
    JButton help_JButton = new JButton("Help");
    JApplet theApplet;
    JDialog theDialog;
    CommonSwitch[] switches;
    String[] ports;
    boolean c1900_2820Only;
    boolean fx100PortOnly;
    boolean gigPortOnly;
    boolean atmPortOnly;
    boolean stdEditionOnly;
    boolean ethernetPortOnly;
    boolean noGigPort;
    boolean no8021p;
    boolean powerEnabled;
    boolean anyGigVariable;
    boolean singleSelection;
    String singleDescription;
    String singleStatus;
    String singleDuplex;
    String singleSpeed;
    String singlePortFast;
    String singleFlowControl;
    String single8021p;
    String singlePower;
    boolean variableGig = false;
    JTable portConfig_JTable;
    PortConfigTableModel portConfigTableModel;
    String DIALOG_TITLE = "Modify Port Configuration";

    public PortConfigGroup_JDialog(Frame frame) {
        super(frame);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.setVisible(false);
        this.portConfig_JPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.portConfig_JPanel, "Center");
        this.portConfig_JPanel.add((Component)this.portDescription_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.portConfig_JPanel.add((Component)this.portStatus_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.portConfig_JPanel.add((Component)this.portDuplex_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.portConfig_JPanel.add((Component)this.portSpeed_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.portConfig_JPanel.add((Component)this.portFast_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.portConfig_JPanel.add((Component)this.QoS8021p_JLabel, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.portConfig_JPanel.add((Component)this.flowControl_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.portConfig_JPanel.add((Component)this.portDescription_JTextField, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.portConfig_JPanel.add((Component)this.portStatus_JComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.portConfig_JPanel.add((Component)this.portDuplex_JComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.portConfig_JPanel.add((Component)this.portSpeed_JComboBox, gridBagConstraints);
        this.portSpeed_JComboBox.addItemListener(this);
        gridBagConstraints.gridy = 4;
        this.portConfig_JPanel.add((Component)this.portFast_JComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.portConfig_JPanel.add((Component)this.QoS8021p_JComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.portConfig_JPanel.add((Component)this.flowControl_JComboBox, gridBagConstraints);
        FlowLayout flowLayout = new FlowLayout(1, 5, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.add(this.ok_JButton);
        jPanel.add(this.cancel_JButton);
        jPanel.add(this.help_JButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.portConfig_JPanel.setBorder(BorderFactory.createTitledBorder("Port Config Options"));
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        this.invalidate();
        ((Component)this).setSize(this.getPreferredSize());
    }

    public PortConfigGroup_JDialog(JApplet jApplet, JDialog jDialog, Vector vector, Vector vector2) {
        this((Frame)null);
        this.theApplet = jApplet;
        if (jDialog != null) {
            this.theDialog = (PortConfig_JDialog)jDialog;
            this.portConfig_JTable = ((PortConfig_JDialog)this.theDialog).getPortConfigTable();
            this.portConfigTableModel = ((PortConfig_JDialog)this.theDialog).getPortConfigTableModel();
            ((Component)jDialog).setCursor(new Cursor(3));
        } else {
            this.theDialog = null;
            jApplet.setCursor(new Cursor(3));
        }
        if (vector.size() != vector2.size()) {
            JOptionPane.showMessageDialog(this, "Internal Error: switch vector size and port vector is different.", this.DIALOG_TITLE, 0);
            return;
        }
        this.switches = new CommonSwitch[vector.size()];
        this.ports = new String[vector2.size()];
        vector.copyInto(this.switches);
        vector2.copyInto(this.ports);
        if (vector.size() == 1) {
            this.singleSelection = true;
            this.singlePortConfiguration();
        } else {
            this.singleSelection = false;
            this.multiplePortConfiguration();
        }
        if (jDialog != null) {
            ((Component)jDialog).setCursor(new Cursor(0));
        } else {
            jApplet.setCursor(new Cursor(0));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            this.clickOK();
        } else if (object == this.cancel_JButton) {
            this.clickCancel();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    boolean areAllC1900_2820(CommonSwitch[] commonSwitchArray) {
        boolean bl = true;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (!(commonSwitchArray[n] instanceof c1900Switch) && !(commonSwitchArray[n] instanceof c2820Switch)) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    boolean areAllFastEtherPorts(String[] stringArray) {
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toLowerCase().indexOf("fastether") == -1) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    void clickCancel() {
        this.setVisible(false);
        this.dispose();
    }

    void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"portdg");
    }

    void clickOK() {
        block68: {
            String string;
            int n;
            block67: {
                String string2;
                ((Component)this).setCursor(new Cursor(3));
                if (!this.singleSelection) break block67;
                String string3 = this.switches[0].esn;
                String string4 = this.portDescription_JTextField.getText();
                if (!string4.equals(this.singleDescription) && !string4.equals(" ")) {
                    if (!PortMappingBasic_JDialog.isValidText(string4)) {
                        JOptionPane.showMessageDialog(this, "Fixed text contains invalid characters.\nOnly alphanumeric characters, spaces, '-' and '_' are allowed.", "Invalid Description", 0);
                        return;
                    }
                    string2 = this.switches[0].Cli.setPortDescription(string3, this.ports[0], string4);
                    if (string2.equals("") && this.theDialog != null) {
                        this.portConfigTableModel.updatePortDescription(this.ports[0], string4);
                    }
                }
                if (!(string4 = (String)this.portStatus_JComboBox.getSelectedItem()).equals(this.singleStatus) && !string4.equals(" ") && (string2 = this.switches[0].Cli.setPortStatus(string3, this.ports[0], string4)).equals("") && this.theDialog != null) {
                    string2 = this.switches[0].Cli.getPortStatusActual(string3, this.ports[0]);
                    this.portConfigTableModel.updatePortStatus(this.ports[0], string4.equals("Enable") ? "Enabled" : "Disabled", string2);
                }
                if (this.portDuplex_JComboBox.isEnabled() && !(string4 = (String)this.portDuplex_JComboBox.getSelectedItem()).equals(this.singleDuplex) && !string4.equals(" ") && (string2 = this.switches[0].Cli.setPortDuplex(string3, this.ports[0], string4)).equals("") && this.theDialog != null) {
                    string2 = this.switches[0].Cli.getPortDuplexActual(string3, this.ports[0]);
                    this.portConfigTableModel.updatePortDuplex(this.ports[0], string4, string2);
                }
                if (this.portSpeed_JComboBox.isEnabled() && !(string4 = (String)this.portSpeed_JComboBox.getSelectedItem()).equals(this.singleSpeed) && !string4.equals(" ") && (string2 = this.switches[0].Cli.setPortSpeed(string3, this.ports[0], string4)).equals("") && this.theDialog != null) {
                    string2 = this.switches[0].Cli.getPortSpeedActual(string3, this.ports[0]);
                    this.portConfigTableModel.updatePortSpeed(this.ports[0], string4, string2);
                }
                if (this.portFast_JComboBox.isEnabled() && !(string4 = (String)this.portFast_JComboBox.getSelectedItem()).equals(this.singlePortFast) && !string4.equals(" ") && (string2 = this.switches[0].Cli.setPortFast(string3, this.ports[0], string4)).equals("") && this.theDialog != null) {
                    if (this.switches[0].deviceType.indexOf("2820") != -1) {
                        char[] cArray = this.ports[0].toCharArray();
                        int n2 = 0;
                        int n3 = 0;
                        while (n3 < cArray.length) {
                            if (Character.isDigit(cArray[n3])) {
                                n2 = Character.digit(cArray[n3], 10);
                                break;
                            }
                            ++n3;
                        }
                        if (this.ports[0].toLowerCase().startsWith("fastethernet")) {
                            if (n2 == 1) {
                                int n4;
                                if (this.switches[0].Slot1Type.indexOf("X2818") != -1) {
                                    n4 = 1;
                                    while (n4 < 9) {
                                        this.portConfigTableModel.updatePortFast("FastEthernet1/" + n4, string4.equals("Enable") ? "Enabled" : "Disabled");
                                        ++n4;
                                    }
                                }
                                if (this.switches[0].Slot1Type.indexOf("X2824") != -1) {
                                    n4 = 1;
                                    while (n4 < 5) {
                                        this.portConfigTableModel.updatePortFast("FastEthernet1/" + n4, string4.equals("Enable") ? "Enabled" : "Disabled");
                                        ++n4;
                                    }
                                }
                            } else if (n2 == 2) {
                                int n5;
                                if (this.switches[0].Slot2Type.indexOf("X2818") != -1) {
                                    n5 = 1;
                                    while (n5 < 9) {
                                        this.portConfigTableModel.updatePortFast("FastEthernet2/" + n5, string4.equals("Enable") ? "Enabled" : "Disabled");
                                        ++n5;
                                    }
                                }
                                if (this.switches[0].Slot2Type.indexOf("X2824") != -1) {
                                    n5 = 1;
                                    while (n5 < 5) {
                                        this.portConfigTableModel.updatePortFast("FastEthernet2/" + n5, string4.equals("Enable") ? "Enabled" : "Disabled");
                                        ++n5;
                                    }
                                }
                            } else {
                                this.portConfigTableModel.updatePortFast(this.ports[0], string4.equals("Enable") ? "Enabled" : "Disabled");
                            }
                        } else {
                            this.portConfigTableModel.updatePortFast(this.ports[0], string4.equals("Enable") ? "Enabled" : "Disabled");
                        }
                    } else {
                        this.portConfigTableModel.updatePortFast(this.ports[0], string4.equals("Enable") ? "Enabled" : "Disabled");
                    }
                }
                if (this.flowControl_JComboBox.isEnabled() && !(string4 = (String)this.flowControl_JComboBox.getSelectedItem()).equals(this.singleFlowControl) && !string4.equals(" ") && (string2 = this.switches[0].Cli.setPortFlowControl(string3, this.ports[0], string4)).equals("") && this.theDialog != null) {
                    this.portConfigTableModel.updatePortFlowControl(this.ports[0], string4);
                }
                if (this.QoS8021p_JComboBox.isEnabled() && this.switches[0].support802Dot1p() && !(string4 = (String)this.QoS8021p_JComboBox.getSelectedItem()).equals(this.single8021p) && !string4.equals(" ") && (string2 = this.switches[0].Cli.setPort8021pPriority(string3, this.ports[0], string4)).equals("") && this.theDialog != null) {
                    this.portConfigTableModel.updatePort8021p(this.ports[0], string4);
                }
                if (!this.powerEnabled) break block68;
                string4 = (String)this.power_JComboBox.getSelectedItem();
                if ((string4 = string4.trim()).length() == 0 || string4.equals(this.singlePower) || string4.equals(" ") || !(string2 = this.switches[0].Cli.setPortPower(string3, this.ports[0], string4)).equals("") || this.theDialog == null) break block68;
                string2 = this.switches[0].Cli.getPortPowerActual(string3, this.ports[0]);
                this.portConfigTableModel.updatePortPower(this.ports[0], string4, string2);
                break block68;
            }
            String string5 = (String)this.portStatus_JComboBox.getSelectedItem();
            if (!string5.equals(" ")) {
                n = 0;
                while (n < this.switches.length) {
                    string = this.switches[n].Cli.setPortStatus(this.switches[n].esn, this.ports[n], string5);
                    if (string.equals("") && this.theDialog != null) {
                        string = this.switches[0].Cli.getPortStatusActual(this.switches[n].esn, this.ports[n]);
                        this.portConfigTableModel.updatePortStatus(this.ports[n], string5.equals("Enable") ? "Enabled" : "Disabled", string);
                    }
                    ++n;
                }
            }
            if (this.portDuplex_JComboBox.isEnabled() && !(string5 = (String)this.portDuplex_JComboBox.getSelectedItem()).equals(" ")) {
                n = 0;
                while (n < this.switches.length) {
                    string = this.switches[n].Cli.setPortDuplex(this.switches[n].esn, this.ports[n], string5);
                    if (string.equals("") && this.theDialog != null) {
                        string = this.switches[0].Cli.getPortDuplexActual(this.switches[n].esn, this.ports[n]);
                        this.portConfigTableModel.updatePortDuplex(this.ports[n], string5, string);
                    }
                    ++n;
                }
            }
            if (this.portSpeed_JComboBox.isEnabled() && !(string5 = (String)this.portSpeed_JComboBox.getSelectedItem()).equals(" ")) {
                n = 0;
                while (n < this.switches.length) {
                    string = this.switches[n].Cli.setPortSpeed(this.switches[n].esn, this.ports[n], string5);
                    if (string.equals("") && this.theDialog != null) {
                        string = this.switches[0].Cli.getPortSpeedActual(this.switches[n].esn, this.ports[n]);
                        this.portConfigTableModel.updatePortSpeed(this.ports[n], string5, string);
                    }
                    ++n;
                }
            }
            if (this.portFast_JComboBox.isEnabled() && !(string5 = (String)this.portFast_JComboBox.getSelectedItem()).equals(" ")) {
                n = 0;
                while (n < this.switches.length) {
                    string = this.switches[n].Cli.setPortFast(this.switches[n].esn, this.ports[n], string5.equals("Enable") ? "Enable" : "Disable");
                    if (string.equals("") && this.theDialog != null) {
                        if (this.switches[0].deviceType.indexOf("2820") != -1) {
                            char[] cArray = this.ports[n].toCharArray();
                            int n6 = 0;
                            int n7 = 0;
                            while (n7 < cArray.length) {
                                if (Character.isDigit(cArray[n7])) {
                                    n6 = Character.digit(cArray[n7], 10);
                                    break;
                                }
                                ++n7;
                            }
                            if (this.ports[n].toLowerCase().startsWith("fastethernet")) {
                                int n8;
                                if (n6 == 1) {
                                    if (this.switches[0].Slot1Type.indexOf("X2818") != -1) {
                                        n8 = 1;
                                        while (n8 < 9) {
                                            this.portConfigTableModel.updatePortFast("FastEthernet1/" + n8, string5.equals("Enable") ? "Enabled" : "Disabled");
                                            ++n8;
                                        }
                                    }
                                    if (this.switches[0].Slot1Type.indexOf("X2824") != -1) {
                                        n8 = 1;
                                        while (n8 < 5) {
                                            this.portConfigTableModel.updatePortFast("FastEthernet1/" + n8, string5.equals("Enable") ? "Enabled" : "Disabled");
                                            ++n8;
                                        }
                                    }
                                } else if (n6 == 2) {
                                    if (this.switches[0].Slot2Type.indexOf("X2818") != -1) {
                                        n8 = 1;
                                        while (n8 < 9) {
                                            this.portConfigTableModel.updatePortFast("FastEthernet2/" + n8, string5.equals("Enable") ? "Enabled" : "Disabled");
                                            ++n8;
                                        }
                                    }
                                    if (this.switches[0].Slot2Type.indexOf("X2824") != -1) {
                                        n8 = 1;
                                        while (n8 < 5) {
                                            this.portConfigTableModel.updatePortFast("FastEthernet2/" + n8, string5.equals("Enable") ? "Enabled" : "Disabled");
                                            ++n8;
                                        }
                                    }
                                } else {
                                    this.portConfigTableModel.updatePortFast(this.ports[n], string5.equals("Enable") ? "Enabled" : "Disabled");
                                }
                            } else {
                                this.portConfigTableModel.updatePortFast(this.ports[n], string5.equals("Enable") ? "Enabled" : "Disabled");
                            }
                        } else {
                            this.portConfigTableModel.updatePortFast(this.ports[n], string5.equals("Enable") ? "Enabled" : "Disabled");
                        }
                    }
                    ++n;
                }
            }
            if (this.flowControl_JComboBox.isEnabled() && !(string5 = (String)this.flowControl_JComboBox.getSelectedItem()).equals(" ")) {
                n = 0;
                while (n < this.switches.length) {
                    string = this.switches[n].Cli.setPortFlowControl(this.switches[n].esn, this.ports[n], string5);
                    if (string.equals("") && this.theDialog != null) {
                        this.portConfigTableModel.updatePortFlowControl(this.ports[n], string5);
                    }
                    ++n;
                }
            }
            if (this.QoS8021p_JComboBox.isEnabled() && !(string5 = (String)this.QoS8021p_JComboBox.getSelectedItem()).equals(" ")) {
                n = 0;
                while (n < this.switches.length) {
                    if (this.switches[n].support802Dot1p() && (string = this.switches[n].Cli.setPort8021pPriority(this.switches[n].esn, this.ports[n], string5)).equals("") && this.theDialog != null) {
                        this.portConfigTableModel.updatePort8021p(this.ports[n], string5);
                    }
                    ++n;
                }
            }
            if (this.powerEnabled) {
                string5 = (String)this.power_JComboBox.getSelectedItem();
                if ((string5 = string5.trim()).length() != 0 && !string5.equals(this.singlePower)) {
                    n = 0;
                    while (n < this.switches.length) {
                        if (this.switches[n].supportTel() && (string = this.switches[n].Cli.setPortPower(this.switches[n].esn, this.ports[n], string5)).equals("") && this.theDialog != null) {
                            string = this.switches[0].Cli.getPortPowerActual(this.switches[n].esn, this.ports[n]);
                            this.portConfigTableModel.updatePortPower(this.ports[n], string5, string);
                        }
                        ++n;
                    }
                }
            }
        }
        this.dispose();
    }

    boolean hasAnyC1900_2820(CommonSwitch[] commonSwitchArray) {
        boolean bl = false;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] instanceof c1900Switch || commonSwitchArray[n] instanceof c2820Switch) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    boolean isAnyC2950(CommonSwitch[] commonSwitchArray) {
        boolean bl = false;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n].deviceType.indexOf("WS-C2950") != -1) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    boolean isFxPort(String string, CommonSwitch commonSwitch) {
        if (string.toLowerCase().indexOf("fastethernet") == -1) {
            return false;
        }
        int n = string.indexOf("/");
        if (n == -1) {
            return false;
        }
        int n2 = Integer.parseInt(string.substring(n - 1, n));
        int n3 = Integer.parseInt(string.substring(n + 1));
        String string2 = "";
        switch (n2) {
            case 0: {
                string2 = commonSwitch.slot0Ports[n3 - 1].getName();
                break;
            }
            case 1: {
                string2 = commonSwitch.slot1Ports[n3 - 1].getName();
                break;
            }
            case 2: {
                string2 = commonSwitch.slot2Ports[n3 - 1].getName();
                break;
            }
        }
        return string2.indexOf("ffx") != -1 || commonSwitch.deviceType.indexOf("C2950C-24") != -1 && n3 > 24 || string2.indexOf("100BaseFX1") != -1 || string2.indexOf("100BaseFX4") != -1;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.variableGig && itemEvent.getSource() == this.portSpeed_JComboBox) {
            String string = (String)this.portSpeed_JComboBox.getSelectedItem();
            String string2 = (String)this.portDuplex_JComboBox.getItemAt(1);
            if (string.equals("1000") || string.equals("Auto")) {
                if (string2.equals("Half")) {
                    this.portDuplex_JComboBox.removeItem("Half");
                    this.portDuplex_JComboBox.setSelectedItem("Full");
                }
            } else if (!string2.equals("Half")) {
                this.portDuplex_JComboBox.insertItemAt("Half", 1);
            }
        }
    }

    void multiplePortConfiguration() {
        int n;
        int n2;
        this.setTitle(this.DIALOG_TITLE);
        this.portDescription_JTextField.setEnabled(false);
        this.c1900_2820Only = this.areAllC1900_2820(this.switches);
        this.ethernetPortOnly = true;
        if (this.c1900_2820Only) {
            n2 = 0;
            while (n2 < this.ports.length) {
                if (!this.ports[n2].startsWith("Ether")) {
                    this.ethernetPortOnly = false;
                    break;
                }
                ++n2;
            }
        }
        if (this.c1900_2820Only) {
            if (this.areAllFastEtherPorts(this.ports)) {
                this.portSpeed_JComboBox.setSelectedItem("100");
            }
            this.portSpeed_JComboBox.setEnabled(false);
        }
        this.gigPortOnly = true;
        n2 = 0;
        while (n2 < this.ports.length) {
            if (this.ports[n2].toLowerCase().indexOf("gig") == -1) {
                this.gigPortOnly = false;
                break;
            }
            ++n2;
        }
        this.atmPortOnly = true;
        int n3 = 0;
        while (n3 < this.ports.length) {
            if (this.ports[n3].indexOf("ATM") == -1) {
                this.atmPortOnly = false;
                break;
            }
            ++n3;
        }
        this.fx100PortOnly = true;
        int n4 = 0;
        while (n4 < this.ports.length) {
            if (!this.isFxPort(this.ports[n4], this.switches[n4])) {
                this.fx100PortOnly = false;
                break;
            }
            ++n4;
        }
        this.stdEditionOnly = true;
        int n5 = 0;
        while (n5 < this.switches.length) {
            if (this.switches[n5].enterpriseEdition) {
                this.stdEditionOnly = false;
                break;
            }
            ++n5;
        }
        this.noGigPort = true;
        int n6 = 0;
        while (n6 < this.ports.length) {
            if (this.ports[n6].toLowerCase().indexOf("gig") != -1) {
                this.noGigPort = false;
                break;
            }
            ++n6;
        }
        this.no8021p = true;
        int n7 = 0;
        while (n7 < this.switches.length) {
            if (this.switches[n7].support802Dot1p()) {
                this.no8021p = false;
                break;
            }
            ++n7;
        }
        if (this.c1900_2820Only && this.ethernetPortOnly) {
            this.portSpeed_JComboBox.setSelectedItem("10");
            this.portSpeed_JComboBox.setEnabled(false);
            this.portDuplex_JComboBox.removeItem("Auto");
        }
        if (this.fx100PortOnly) {
            this.portSpeed_JComboBox.setSelectedItem("100");
            this.portSpeed_JComboBox.setEnabled(false);
        }
        if (this.gigPortOnly) {
            this.portSpeed_JComboBox.addItem("1000");
            this.portSpeed_JComboBox.setSelectedItem("1000");
            this.anyGigVariable = false;
            n = 0;
            while (n < this.ports.length) {
                if (this.ports[n].toLowerCase().indexOf("gig") != -1 && this.switches[n].deviceType.indexOf("WS-C2950T-24") != -1) {
                    this.anyGigVariable = true;
                    break;
                }
                ++n;
            }
            if (!this.anyGigVariable) {
                this.portSpeed_JComboBox.setSelectedItem("1000");
                this.portSpeed_JComboBox.setEnabled(false);
            }
        }
        if (this.atmPortOnly) {
            this.portSpeed_JComboBox.addItem("155");
            this.portSpeed_JComboBox.setSelectedItem("155");
            this.portSpeed_JComboBox.setEnabled(false);
            this.portFast_JComboBox.setEnabled(false);
        }
        if (this.stdEditionOnly) {
            this.QoS8021p_JComboBox.setEnabled(false);
        }
        if (this.noGigPort) {
            this.flowControl_JComboBox.setEnabled(false);
        }
        if (this.no8021p) {
            this.QoS8021p_JComboBox.setEnabled(false);
        }
        this.powerEnabled = false;
        n = 0;
        while (n < this.switches.length) {
            if (this.switches[n].supportTel()) {
                this.powerEnabled = true;
                break;
            }
            ++n;
        }
        if (this.powerEnabled) {
            this.showPower();
            if (this.gigPortOnly) {
                this.power_JComboBox.setEnabled(false);
            }
        }
        if (!this.hasAnyC1900_2820(this.switches)) {
            this.portDuplex_JComboBox.removeItem("Full with Flow Control");
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void showPower() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.portConfig_JPanel.add((Component)this.power_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.portConfig_JPanel.add((Component)this.power_JComboBox, gridBagConstraints);
        ((Component)this).setSize(this.getWidth(), this.getHeight() + this.power_JComboBox.getHeight() + 50);
    }

    void singlePortConfiguration() {
        boolean bl = this.areAllC1900_2820(this.switches);
        StringBuffer stringBuffer = new StringBuffer(this.DIALOG_TITLE);
        stringBuffer.append(" - ");
        stringBuffer.append(this.ports[0]);
        String string = stringBuffer.toString();
        this.setTitle(string);
        String string2 = this.ports[0].toLowerCase();
        String string3 = this.switches[0].esn;
        this.singleDescription = this.switches[0].Cli.getPortDescription(string3, this.ports[0]);
        this.portDescription_JTextField.setText(this.singleDescription);
        this.singleStatus = this.switches[0].Cli.getPortStatus(string3, this.ports[0]);
        if (this.singleStatus.equals("")) {
            this.portStatus_JComboBox.setSelectedItem("Disable");
            this.singleStatus = "Disable";
        } else {
            this.portStatus_JComboBox.setSelectedItem("Enable");
            this.singleStatus = "Enable";
        }
        if (!this.hasAnyC1900_2820(this.switches)) {
            this.portDuplex_JComboBox.removeItem("Full with Flow Control");
        }
        this.singleDuplex = this.switches[0].Cli.getPortDuplex(string3, this.ports[0]);
        String string4 = this.singleDuplex.toLowerCase();
        if (string4.indexOf("half") != -1) {
            this.portDuplex_JComboBox.setSelectedItem("Half");
            this.singleDuplex = "Half";
        } else if (string4.indexOf("full-flow") != -1) {
            this.portDuplex_JComboBox.setSelectedItem("Full with Flow Control");
            this.singleDuplex = "Full with Flow Control";
        } else if (string4.indexOf("full") != -1) {
            this.portDuplex_JComboBox.setSelectedItem("Full");
            this.singleDuplex = "Full";
        } else if (string4.indexOf("auto") != -1) {
            this.portDuplex_JComboBox.setSelectedItem("Auto");
            this.singleDuplex = "Auto";
        }
        this.singleSpeed = this.switches[0].Cli.getPortSpeed(string3, this.ports[0]);
        String string5 = this.singleSpeed.toLowerCase();
        if (string5.indexOf("100") != -1) {
            this.portSpeed_JComboBox.setSelectedItem("100");
            this.singleSpeed = "100";
        } else if (string5.indexOf("10") != -1) {
            this.portSpeed_JComboBox.setSelectedItem("10");
            this.singleSpeed = "10";
        } else if (string5.indexOf("Auto") != -1) {
            this.portSpeed_JComboBox.setSelectedItem("Auto");
            this.singleSpeed = "Auto";
        } else if (string5.indexOf("auto") != -1) {
            this.portSpeed_JComboBox.setSelectedItem("Auto");
            this.singleSpeed = "Auto";
        }
        this.singlePortFast = this.switches[0].Cli.getPortFastStatus(string3, this.ports[0]);
        if (this.singlePortFast.equals("")) {
            this.portFast_JComboBox.setSelectedItem("Disable");
            this.singlePortFast = "Disable";
        } else {
            this.portFast_JComboBox.setSelectedItem("Enable");
            this.singlePortFast = "Enable";
        }
        this.singleFlowControl = this.switches[0].Cli.getPortFlowControl(string3, this.ports[0]);
        if (this.singleFlowControl.equals("NA")) {
            this.flowControl_JComboBox.setEnabled(false);
            this.singleFlowControl = "NA";
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.singleFlowControl, ",");
            this.singleFlowControl = stringTokenizer.nextToken();
            this.flowControl_JComboBox.setSelectedItem(this.singleFlowControl);
        }
        if (this.switches[0].support802Dot1p()) {
            this.single8021p = this.switches[0].Cli.getPort8021pPriority(string3, this.ports[0]);
            this.QoS8021p_JComboBox.setSelectedItem(this.single8021p);
        } else {
            this.QoS8021p_JComboBox.setEnabled(false);
        }
        if (string2.indexOf("gig") != -1) {
            this.portSpeed_JComboBox.addItem("1000");
            try {
                int n = string2.indexOf("/");
                int n2 = Integer.parseInt(string2.substring(n - 1, n));
                if (n2 == 0) {
                    String[] stringArray = this.switches[0].Cli.getPortName(string3);
                    int n3 = -1;
                    n3 = 0;
                    while (n3 < this.switches[0].slot0PortNumbers) {
                        if (string2.equalsIgnoreCase(stringArray[n3])) break;
                        ++n3;
                    }
                    if (this.switches[0].slot0Ports[n3].portType == 104) {
                        if (string5.indexOf("1000") != -1) {
                            this.portSpeed_JComboBox.setSelectedItem("1000");
                            this.singleSpeed = "1000";
                        }
                        this.portSpeed_JComboBox.setEnabled(true);
                        this.variableGig = true;
                        if (this.singleSpeed.equals("1000") || this.singleSpeed.equals("Auto")) {
                            this.portDuplex_JComboBox.removeItem("Half");
                        }
                    } else {
                        this.portSpeed_JComboBox.setSelectedItem("1000");
                        this.portSpeed_JComboBox.setEnabled(false);
                        this.singleSpeed = "1000";
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (string2.indexOf("atm") != -1) {
            this.portSpeed_JComboBox.addItem("155");
            this.portSpeed_JComboBox.setSelectedItem("155");
            this.portSpeed_JComboBox.setEnabled(false);
            this.singleSpeed = "155";
            this.portDuplex_JComboBox.setSelectedItem("Full");
            this.portDuplex_JComboBox.setEnabled(false);
            this.singleDuplex = "Full";
            this.portFast_JComboBox.setEnabled(false);
        }
        if (string2.indexOf("fdd") != -1) {
            this.portSpeed_JComboBox.setSelectedItem("100");
            this.portSpeed_JComboBox.setEnabled(false);
            this.singleSpeed = "100";
            this.portDuplex_JComboBox.setSelectedItem("Full");
            this.portDuplex_JComboBox.setEnabled(false);
            this.singleDuplex = "Full";
        }
        if (string2.indexOf("ethernet") != -1 && string2.indexOf("fast") == -1 && string2.indexOf("longreach") == -1 && string2.indexOf("gig") == -1) {
            this.portSpeed_JComboBox.setSelectedItem("10");
            this.portSpeed_JComboBox.setEnabled(false);
            this.singleSpeed = "10";
        }
        if (this.isFxPort(string2, this.switches[0])) {
            this.portSpeed_JComboBox.setEnabled(false);
            if (this.switches[0].deviceType.indexOf("WS-C2950") != -1) {
                this.portDuplex_JComboBox.removeItem("Half");
                this.portDuplex_JComboBox.setSelectedItem("Full");
                this.portDuplex_JComboBox.setEnabled(false);
            }
        }
        if (bl) {
            this.portSpeed_JComboBox.setEnabled(false);
        }
        if (this.switches[0].supportTel()) {
            this.showPower();
            this.powerEnabled = true;
            if (string2.toLowerCase().indexOf("gig") != -1) {
                this.power_JComboBox.setEnabled(false);
            }
            this.singlePower = this.switches[0].Cli.getPortPower(string3, this.ports[0]);
            this.power_JComboBox.setSelectedItem(this.singlePower);
        }
    }
}

