/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SnmpConfig
extends DeviceComboDialog {
    protected static final String illegalChars = " /\\";
    protected static final String illegalCharsDesc = "Spaces, forward-slashes, and back-slashes\n";
    protected boolean snmpDisabled;
    protected CommunityStrings communityMirror;
    protected SnmpConfigGui gui;

    public SnmpConfig(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null);
    }

    public SnmpConfig(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(jApplet, commonSwitchArray, commonSwitch);
        this.constructorInit();
    }

    private void addTitledBorders() {
        this.gui.borderNewStringPanel.setBorder(BorderFactory.createTitledBorder("New String"));
        this.gui.borderStringListPanel.setBorder(BorderFactory.createTitledBorder("Current String(s)"));
        this.gui.borderNewTrapPanel.setBorder(BorderFactory.createTitledBorder("New Manager"));
        this.gui.borderTrapListPanel.setBorder(BorderFactory.createTitledBorder("Current Manager(s)"));
    }

    protected void deviceChanged() {
        if (Switch.type(this.device.switchBoxName) == 0) {
            this.setC1900Gui();
        } else {
            this.setC3500Gui();
        }
    }

    protected void enableC1900TrapTypes() {
        this.gui.checkBox4.setEnabled(true);
        this.gui.checkBox5.setEnabled(true);
    }

    protected void enableC3500TrapTypes() {
        boolean bl = this.device.enterpriseEdition;
        this.gui.checkBox4.setEnabled(bl);
        this.gui.checkBox5.setEnabled(bl);
    }

    protected String getButtonsNeeded() {
        String string = "OK APPLY REFRESH CANCEL HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        this.gui = new SnmpConfigGui();
        this.addTitledBorders();
        return this.gui;
    }

    protected String getHelpUrl() {
        String string = "";
        JPanel jPanel = (JPanel)this.gui.tabbedPanel.getSelectedComponent();
        if (jPanel == this.gui.optionsPanel) {
            string = "";
        } else if (jPanel == this.gui.stringsPanel) {
            string = "";
        } else if (jPanel == this.gui.trapsPanel) {
            string = "";
        }
        return "snmpdg";
    }

    protected void getMirrorObjects(Vector vector) {
        vector.addElement(new SystemOptions());
        this.communityMirror = new CommunityStrings();
        vector.addElement(this.communityMirror);
        vector.addElement(new TrapManagers());
    }

    protected String getWindowTitle() {
        return "SNMP Management";
    }

    protected boolean isDeviceSupported(CommonSwitch commonSwitch) {
        return true;
    }

    protected void setC1900Gui() {
        if (this.gui.checkBox6.isVisible()) {
            this.gui.trapEnableCheckBox.setVisible(false);
            this.gui.borderNewTrapPanel.setBorder(null);
            this.gui.checkBox1.setText("Address-violation");
            this.gui.checkBox2.setText("Authentication");
            this.gui.checkBox3.setText("BSC");
            this.gui.checkBox4.setText("Link-up-down");
            this.gui.checkBox5.setText("VTP");
            this.gui.checkBox6.setVisible(false);
            this.gui.borderAddrCommPanel.setBorder(BorderFactory.createTitledBorder("New Manager"));
            this.gui.borderTrapTypesPanel.setBorder(BorderFactory.createTitledBorder(this.gui.trapTypesLabel.getText()));
            this.gui.trapTypesLabel.setVisible(false);
            this.gui.trapWarningLabel1.setVisible(true);
            this.gui.trapWarningLabel2.setVisible(true);
        }
    }

    protected void setC3500Gui() {
        if (this.gui.trapWarningLabel1.isVisible()) {
            this.gui.trapEnableCheckBox.setVisible(true);
            this.gui.borderAddrCommPanel.setBorder(null);
            this.gui.borderTrapTypesPanel.setBorder(null);
            this.gui.trapTypesLabel.setVisible(true);
            this.gui.checkBox1.setText("Config");
            this.gui.checkBox2.setText("SNMP");
            this.gui.checkBox3.setText("TTY");
            this.gui.checkBox4.setText("VLAN-membership");
            this.gui.checkBox5.setText("VTP");
            this.gui.checkBox6.setVisible(true);
            this.gui.borderNewTrapPanel.setBorder(BorderFactory.createTitledBorder("New Manager"));
            this.gui.trapWarningLabel1.setVisible(false);
            this.gui.trapWarningLabel2.setVisible(false);
        }
    }

    protected class SystemOptions
    implements DeviceMirrorObject,
    ActionListener,
    DocumentListener {
        boolean[] enableSnmp;
        String[] name;
        String[] location;
        String[] contact;

        protected SystemOptions() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SnmpConfig.this.gui.enableCheckbox) {
                this.enableCheckbox_Action();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void enableCheckbox_Action() {
            boolean bl = SnmpConfig.this.gui.enableCheckbox.isSelected();
            this.setGuiEnabled(bl);
            SnmpConfig.this.uiChanged = true;
            SnmpConfig.this.updateBottomButtons();
        }

        public void hookupListeners() {
            SnmpConfig.this.gui.enableCheckbox.addActionListener(this);
            SnmpConfig.this.gui.nameField.getDocument().addDocumentListener(this);
            SnmpConfig.this.gui.locationField.getDocument().addDocumentListener(this);
            SnmpConfig.this.gui.contactField.getDocument().addDocumentListener(this);
        }

        public void initializeMembers() {
            this.enableSnmp = new boolean[2];
            this.name = new String[2];
            this.location = new String[2];
            this.contact = new String[2];
            IllegalCharsDocument.setIllegalCharsFor((JTextComponent)SnmpConfig.this.gui.nameField, (String)SnmpConfig.illegalChars, (String)SnmpConfig.illegalCharsDesc);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void setGuiEnabled(boolean bl) {
            SnmpConfig.this.snmpDisabled = bl ^ true;
            DeviceDialog.setContainerEnabled(SnmpConfig.this.gui.tabbedPanel, bl);
            if (bl) {
                if (Switch.type(SnmpConfig.this.device.switchBoxName) == 0) {
                    SnmpConfig.this.enableC1900TrapTypes();
                } else {
                    SnmpConfig.this.enableC3500TrapTypes();
                }
            }
        }

        protected void textFieldChanged(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            SnmpConfig.this.uiChanged = true;
            SnmpConfig.this.updateBottomButtons();
        }

        public void updateDeviceFromMirror() {
            String string;
            if (this.enableSnmp[0] != this.enableSnmp[1]) {
                String string2 = SnmpConfig.this.communityMirror.getEnablingString();
                string = SnmpConfig.this.device.Cli.setSNMPAgentEnable(SnmpConfig.this.device.esn, this.enableSnmp[1], string2);
                SnmpConfig.this.displayUserError(string);
                this.enableSnmp[0] = this.enableSnmp[1];
                SnmpConfig.this.uiNeedsRefresh = true;
            }
            if (SnmpConfig.this.snmpDisabled) {
                return;
            }
            if (!this.name[0].equals(this.name[1])) {
                string = SnmpConfig.this.device.Cli.setHostName(SnmpConfig.this.device.esn, this.name[1]);
                SnmpConfig.this.displayUserError(string);
                this.name[0] = this.name[1];
            }
            if (!this.location[0].equals(this.location[1])) {
                string = SnmpConfig.this.device.Cli.setSysLocation(SnmpConfig.this.device.esn, this.location[1]);
                SnmpConfig.this.displayUserError(string);
                this.location[0] = this.location[1];
            }
            if (!this.contact[0].equals(this.contact[1])) {
                string = SnmpConfig.this.device.Cli.setSysContact(SnmpConfig.this.device.esn, this.contact[1]);
                SnmpConfig.this.displayUserError(string);
                this.contact[0] = this.contact[1];
            }
        }

        public void updateGuiFromMirror() {
            SnmpConfig.this.gui.enableCheckbox.setSelected(this.enableSnmp[0]);
            SnmpConfig.this.gui.enableCheckbox.setEnabled(Switch.type(SnmpConfig.this.device.switchBoxName) != 0);
            this.setGuiEnabled(this.enableSnmp[0]);
            SnmpConfig.this.gui.nameField.setText(this.name[0]);
            SnmpConfig.this.gui.locationField.setText(this.location[0]);
            SnmpConfig.this.gui.contactField.setText(this.contact[0]);
        }

        public void updateMirrorFromDevice() {
            this.enableSnmp[0] = SnmpConfig.this.device.Cli.getSNMPAgentStatus(SnmpConfig.this.device.esn);
            this.name[0] = SnmpConfig.this.device.Cli.getHostName(SnmpConfig.this.device.esn);
            this.location[0] = SnmpConfig.this.device.Cli.getSysLocation(SnmpConfig.this.device.esn);
            this.contact[0] = SnmpConfig.this.device.Cli.getSysContact(SnmpConfig.this.device.esn);
        }

        public void updateMirrorFromGui() {
            this.enableSnmp[1] = SnmpConfig.this.gui.enableCheckbox.isSelected();
            this.name[1] = SnmpConfig.this.gui.nameField.getText().trim();
            this.location[1] = SnmpConfig.this.gui.locationField.getText().trim();
            this.contact[1] = SnmpConfig.this.gui.contactField.getText().trim();
        }
    }

    protected class CommunityStrings
    implements DeviceMirrorObject,
    DocumentListener,
    ListSelectionListener,
    ActionListener {
        Vector[] stringList;
        DefaultListModel stringListModel;

        protected CommunityStrings() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SnmpConfig.this.gui.stringSelAllBut) {
                this.selAllBut_Action();
            } else if (object == SnmpConfig.this.gui.addStringsBut) {
                this.add_Action();
            } else if (object == SnmpConfig.this.gui.removeStringsBut) {
                SnmpConfig.this.removeFromList(SnmpConfig.this.gui.stringList, SnmpConfig.this.gui.removeStringsBut, SnmpConfig.this.gui.stringSelAllBut);
            }
        }

        protected void add_Action() {
            CommunityString communityString = new CommunityString(SnmpConfig.this.gui.newStringField.getText().trim(), SnmpConfig.this.gui.roRadioButton.isSelected());
            int n = this.stringListModel.indexOf(communityString);
            if (n != -1) {
                CommunityString communityString2 = (CommunityString)this.stringListModel.get(n);
                if (communityString2.accessEquals(communityString)) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(SnmpConfig.this, "The community already exists.", "Error", 0);
                    return;
                }
                this.stringListModel.set(n, communityString);
            } else {
                this.stringListModel.addElement(communityString);
            }
            SnmpConfig.this.uiChanged = true;
            SnmpConfig.this.updateBottomButtons();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public String encodeCommunity(String string) {
            String string2 = "";
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                string2 = !Character.isLetter(c) && !Character.isDigit(c) ? String.valueOf(string2) + "%" + Integer.toHexString(c) : String.valueOf(string2) + String.valueOf(c);
                ++n;
            }
            return string2;
        }

        protected String getEnablingString() {
            String string = "public/RO";
            if (!this.stringList[0].isEmpty()) {
                CommunityString communityString = (CommunityString)this.stringList[0].elementAt(0);
                string = String.valueOf(communityString.getName()) + "/" + communityString.getAccess();
                return string;
            }
            if (!this.stringList[1].isEmpty()) {
                CommunityString communityString = (CommunityString)this.stringList[1].elementAt(0);
                string = String.valueOf(communityString.getName()) + "/" + communityString.getAccess();
                return string;
            }
            return string;
        }

        public void hookupListeners() {
            SnmpConfig.this.gui.newStringField.getDocument().addDocumentListener(this);
            SnmpConfig.this.gui.stringList.addListSelectionListener(this);
            SnmpConfig.this.gui.stringSelAllBut.addActionListener(this);
            SnmpConfig.this.gui.addStringsBut.addActionListener(this);
            SnmpConfig.this.gui.removeStringsBut.addActionListener(this);
        }

        public void initializeMembers() {
            this.stringList = new Vector[2];
            this.stringList[0] = new Vector();
            this.stringList[1] = new Vector();
            IllegalCharsDocument.setIllegalCharsFor((JTextComponent)SnmpConfig.this.gui.newStringField, (String)SnmpConfig.illegalChars, (String)SnmpConfig.illegalCharsDesc);
            this.stringListModel = new DefaultListModel();
            SnmpConfig.this.gui.stringList.setModel(this.stringListModel);
            SnmpConfig.this.gui.stringButtonGroup.add(SnmpConfig.this.gui.roRadioButton);
            SnmpConfig.this.gui.stringButtonGroup.add(SnmpConfig.this.gui.rwRadioButton);
            SnmpConfig.this.gui.roRadioButton.setSelected(true);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void selAllBut_Action() {
            SnmpConfig.this.gui.stringList.setSelectionInterval(0, this.stringListModel.size() - 1);
        }

        protected void textFieldChanged(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            SnmpConfig.this.uiChanged = true;
            SnmpConfig.this.updateBottomButtons();
            String string = SnmpConfig.this.gui.newStringField.getText().trim();
            boolean bl = true;
            if (string.equals("")) {
                bl = false;
            }
            SnmpConfig.this.gui.addStringsBut.setEnabled(bl);
        }

        public void updateDeviceFromMirror() {
            String string;
            CommunityString communityString;
            if (SnmpConfig.this.snmpDisabled) {
                return;
            }
            int n = 0;
            int n2 = this.stringList[0].size();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 - n;
                communityString = (CommunityString)this.stringList[0].elementAt(n4);
                if (!this.stringList[1].contains(communityString)) {
                    string = SnmpConfig.this.device.Cli.setSNMPCommunity(SnmpConfig.this.device.esn, this.encodeCommunity(communityString.getName()), communityString.getAccess(), "delete");
                    SnmpConfig.this.displayUserError(string);
                    this.stringList[0].removeElementAt(n4);
                    ++n;
                }
                ++n3;
            }
            n2 = this.stringList[1].size();
            int n5 = 0;
            while (n5 < n2) {
                CommunityString communityString2;
                communityString = (CommunityString)this.stringList[1].elementAt(n5);
                int n6 = this.stringList[0].indexOf(communityString);
                if (n6 == -1 || !(communityString2 = (CommunityString)this.stringList[0].elementAt(n6)).accessEquals(communityString)) {
                    string = SnmpConfig.this.device.Cli.setSNMPCommunity(SnmpConfig.this.device.esn, this.encodeCommunity(communityString.getName()), communityString.getAccess(), "add");
                    SnmpConfig.this.displayUserError(string);
                    if (n6 != -1) {
                        this.stringList[0].setElementAt(communityString, n6);
                    } else {
                        this.stringList[0].addElement(communityString);
                    }
                }
                ++n5;
            }
        }

        public void updateGuiFromMirror() {
            SnmpConfig.this.gui.newStringField.setText("");
            SnmpConfig.this.gui.roRadioButton.setSelected(true);
            this.stringListModel.clear();
            int n = 0;
            while (n < this.stringList[0].size()) {
                this.stringListModel.addElement(this.stringList[0].elementAt(n));
                ++n;
            }
            SnmpConfig.this.gui.stringSelAllBut.setEnabled(this.stringListModel.isEmpty() ^ true);
        }

        public void updateMirrorFromDevice() {
            String[] stringArray = SnmpConfig.this.device.Cli.getSNMPCommunities(SnmpConfig.this.device.esn);
            this.stringList[0].removeAllElements();
            if (stringArray == null) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                CommunityString communityString = new CommunityString(stringArray[n]);
                this.stringList[0].addElement(communityString);
                ++n;
            }
        }

        public void updateMirrorFromGui() {
            this.stringList[1].removeAllElements();
            Object[] objectArray = this.stringListModel.toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.stringList[1].addElement(objectArray[n]);
                ++n;
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            SnmpConfig.this.gui.removeStringsBut.setEnabled(jList.isSelectionEmpty() ^ true);
        }
    }

    protected class TrapManagers
    implements DeviceMirrorObject,
    DocumentListener,
    ListSelectionListener,
    ActionListener {
        Vector[] trapList;
        boolean[][] trapTypes;
        boolean[] trapEnabled;
        boolean enableApply = false;
        DefaultListModel trapListModel;

        protected TrapManagers() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SnmpConfig.this.gui.trapSelAllBut) {
                this.selAllBut_Action();
            } else if (object == SnmpConfig.this.gui.addTrapsBut) {
                this.add_Action();
            } else if (object == SnmpConfig.this.gui.removeTrapsBut) {
                DefaultListModel defaultListModel = (DefaultListModel)SnmpConfig.this.gui.trapList.getModel();
                int[] nArray = SnmpConfig.this.gui.trapList.getSelectedIndices();
                Object[] objectArray = defaultListModel.toArray();
                int n = 0;
                while (n < nArray.length) {
                    if (this.trapList[0].contains(objectArray[nArray[n]])) {
                        this.enableApply = true;
                        break;
                    }
                    this.enableApply = this.enableApply;
                    ++n;
                }
                SnmpConfig.this.removeFromList(SnmpConfig.this.gui.trapList, SnmpConfig.this.gui.removeTrapsBut, SnmpConfig.this.gui.trapSelAllBut);
                SnmpConfig.this.uiChanged = this.enableApply;
                SnmpConfig.this.updateBottomButtons();
            } else if (object == SnmpConfig.this.gui.trapEnableCheckBox) {
                this.enableApply = true;
                SnmpConfig.this.uiChanged = true;
                SnmpConfig.this.updateBottomButtons();
            } else if (object instanceof JCheckBox) {
                this.checkbox_Action();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void add_Action() {
            String string = SnmpConfig.this.gui.ipAddrField.getText().trim();
            if (!IpAddress.isFormatValid(string)) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(SnmpConfig.this, "Invalid IP address.", "Error", 0);
                SnmpConfig.this.gui.ipAddrField.selectAll();
                SnmpConfig.this.gui.ipAddrField.requestFocus();
                return;
            }
            TrapManager trapManager = new TrapManager();
            int n = this.trapListModel.indexOf(trapManager);
            if (n >= 0) {
                if (Switch.type(SnmpConfig.this.device.switchBoxName) == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(SnmpConfig.this, "The trap manager already exists.", "Error", 0);
                    return;
                }
                this.trapListModel.setElementAt(trapManager, n);
            } else {
                this.trapListModel.addElement(trapManager);
            }
            SnmpConfig.this.uiChanged = true;
            SnmpConfig.this.updateBottomButtons();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void checkbox_Action() {
            if (Switch.type(SnmpConfig.this.device.switchBoxName) == 0) {
                SnmpConfig.this.uiChanged = true;
                SnmpConfig.this.updateBottomButtons();
            }
        }

        public void hookupListeners() {
            SnmpConfig.this.gui.trapEnableCheckBox.addActionListener(this);
            SnmpConfig.this.gui.ipAddrField.getDocument().addDocumentListener(this);
            SnmpConfig.this.gui.communityField.getDocument().addDocumentListener(this);
            SnmpConfig.this.gui.checkBox1.addActionListener(this);
            SnmpConfig.this.gui.checkBox2.addActionListener(this);
            SnmpConfig.this.gui.checkBox3.addActionListener(this);
            SnmpConfig.this.gui.checkBox4.addActionListener(this);
            SnmpConfig.this.gui.checkBox5.addActionListener(this);
            SnmpConfig.this.gui.checkBox6.addActionListener(this);
            SnmpConfig.this.gui.trapList.addListSelectionListener(this);
            SnmpConfig.this.gui.trapSelAllBut.addActionListener(this);
            SnmpConfig.this.gui.addTrapsBut.addActionListener(this);
            SnmpConfig.this.gui.removeTrapsBut.addActionListener(this);
        }

        public void initializeMembers() {
            this.trapList = new Vector[2];
            this.trapList[0] = new Vector();
            this.trapList[1] = new Vector();
            this.trapTypes = new boolean[2][5];
            this.trapEnabled = new boolean[2];
            IllegalCharsDocument.setIllegalCharsFor((JTextComponent)SnmpConfig.this.gui.communityField, (String)SnmpConfig.illegalChars, (String)SnmpConfig.illegalCharsDesc);
            this.trapListModel = new DefaultListModel();
            SnmpConfig.this.gui.trapList.setModel(this.trapListModel);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textFieldChanged(documentEvent);
        }

        protected void selAllBut_Action() {
            SnmpConfig.this.gui.trapList.setSelectionInterval(0, this.trapListModel.size() - 1);
        }

        protected void textFieldChanged(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            String string = SnmpConfig.this.gui.ipAddrField.getText().trim();
            String string2 = SnmpConfig.this.gui.communityField.getText().trim();
            boolean bl = true;
            if (string.equals("") || string2.equals("")) {
                bl = false;
            }
            SnmpConfig.this.gui.addTrapsBut.setEnabled(bl);
        }

        public void updateDeviceFromMirror() {
            String string;
            TrapManager trapManager;
            if (SnmpConfig.this.snmpDisabled) {
                return;
            }
            int n = 0;
            int n2 = this.trapList[0].size();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 - n;
                trapManager = (TrapManager)this.trapList[0].elementAt(n4);
                if (!this.trapList[1].contains(trapManager)) {
                    string = SnmpConfig.this.device.Cli.setTrapManagers(SnmpConfig.this.device.esn, trapManager.getIpAddress(), trapManager.getCommunity(), trapManager.getTrapTypes(), false);
                    SnmpConfig.this.displayUserError(string);
                    this.trapList[0].removeElementAt(n4);
                    ++n;
                }
                ++n3;
            }
            if (this.trapEnabled[1]) {
                string = SnmpConfig.this.device.Cli.enableTraps(SnmpConfig.this.device.esn);
                SnmpConfig.this.displayUserError(string);
            } else {
                string = SnmpConfig.this.device.Cli.disableTraps(SnmpConfig.this.device.esn);
                SnmpConfig.this.displayUserError(string);
            }
            n2 = this.trapList[1].size();
            int n5 = 0;
            while (n5 < n2) {
                trapManager = (TrapManager)this.trapList[1].elementAt(n5);
                if (trapManager.isUserAdded()) {
                    string = SnmpConfig.this.device.Cli.setTrapManagers(SnmpConfig.this.device.esn, trapManager.getIpAddress(), trapManager.getCommunity(), trapManager.getTrapTypes(), true);
                    SnmpConfig.this.displayUserError(string);
                    int n6 = this.trapList[0].indexOf(trapManager);
                    if (n6 >= 0) {
                        this.trapList[0].setElementAt(trapManager, n6);
                    } else {
                        this.trapList[0].addElement(trapManager);
                    }
                    trapManager.setUserAdded(false);
                }
                ++n5;
            }
            if (Switch.type(SnmpConfig.this.device.switchBoxName) != 0) {
                return;
            }
            if (this.trapTypes[0][0] != this.trapTypes[1][0]) {
                string = SnmpConfig.this.device.Cli.setCommonTrapTypes(SnmpConfig.this.device.esn, "address-violation", this.trapTypes[1][0]);
                SnmpConfig.this.displayUserError(string);
                this.trapTypes[0][0] = this.trapTypes[1][0];
            }
            if (this.trapTypes[0][1] != this.trapTypes[1][1]) {
                string = SnmpConfig.this.device.Cli.setCommonTrapTypes(SnmpConfig.this.device.esn, "authentication", this.trapTypes[1][1]);
                SnmpConfig.this.displayUserError(string);
                this.trapTypes[0][1] = this.trapTypes[1][1];
            }
            if (this.trapTypes[0][2] != this.trapTypes[1][2]) {
                string = SnmpConfig.this.device.Cli.setCommonTrapTypes(SnmpConfig.this.device.esn, "bsc", this.trapTypes[1][2]);
                SnmpConfig.this.displayUserError(string);
                this.trapTypes[0][2] = this.trapTypes[1][2];
            }
            if (this.trapTypes[0][3] != this.trapTypes[1][3]) {
                string = SnmpConfig.this.device.Cli.setCommonTrapTypes(SnmpConfig.this.device.esn, "link-up-down", this.trapTypes[1][3]);
                SnmpConfig.this.displayUserError(string);
                this.trapTypes[0][3] = this.trapTypes[1][3];
            }
            if (this.trapTypes[0][4] != this.trapTypes[1][4]) {
                string = SnmpConfig.this.device.Cli.setCommonTrapTypes(SnmpConfig.this.device.esn, "vtp", this.trapTypes[1][4]);
                SnmpConfig.this.displayUserError(string);
                this.trapTypes[0][4] = this.trapTypes[1][4];
            }
        }

        public void updateGuiFromMirror() {
            SnmpConfig.this.gui.ipAddrField.setText("");
            SnmpConfig.this.gui.communityField.setText("");
            this.trapListModel.clear();
            int n = 0;
            while (n < this.trapList[0].size()) {
                this.trapListModel.addElement(this.trapList[0].elementAt(n));
                ++n;
            }
            SnmpConfig.this.gui.trapSelAllBut.setEnabled(this.trapListModel.isEmpty() ^ true);
            if (Switch.type(SnmpConfig.this.device.switchBoxName) != 0) {
                SnmpConfig.this.gui.trapEnableCheckBox.setSelected(this.trapEnabled[0]);
                SnmpConfig.this.gui.checkBox1.setSelected(false);
                SnmpConfig.this.gui.checkBox2.setSelected(false);
                SnmpConfig.this.gui.checkBox3.setSelected(false);
                SnmpConfig.this.gui.checkBox4.setSelected(false);
                SnmpConfig.this.gui.checkBox5.setSelected(false);
                SnmpConfig.this.gui.checkBox6.setSelected(false);
            } else {
                SnmpConfig.this.gui.trapEnableCheckBox.setSelected(true);
                SnmpConfig.this.gui.checkBox1.setSelected(this.trapTypes[0][0]);
                SnmpConfig.this.gui.checkBox2.setSelected(this.trapTypes[0][1]);
                SnmpConfig.this.gui.checkBox3.setSelected(this.trapTypes[0][2]);
                SnmpConfig.this.gui.checkBox4.setSelected(this.trapTypes[0][3]);
                SnmpConfig.this.gui.checkBox5.setSelected(this.trapTypes[0][4]);
            }
        }

        public void updateMirrorFromDevice() {
            this.trapEnabled[0] = SnmpConfig.this.device.Cli.isSNMPTrapEnabled(SnmpConfig.this.device.esn);
            String[] stringArray = SnmpConfig.this.device.Cli.getTrapManagers(SnmpConfig.this.device.esn);
            this.trapList[0].removeAllElements();
            if (stringArray == null) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                TrapManager trapManager = new TrapManager(stringArray[n]);
                this.trapList[0].addElement(trapManager);
                ++n;
            }
            if (Switch.type(SnmpConfig.this.device.switchBoxName) != 0) {
                return;
            }
            String string = SnmpConfig.this.device.Cli.getCommonTrapTypes(SnmpConfig.this.device.esn);
            this.trapTypes[0][0] = string.indexOf("address-violation") >= 0;
            this.trapTypes[0][1] = string.indexOf("authentication") >= 0;
            this.trapTypes[0][2] = string.indexOf("bsc") >= 0;
            this.trapTypes[0][3] = string.indexOf("link-up-down") >= 0;
            this.trapTypes[0][4] = string.indexOf("vtp") >= 0;
        }

        public void updateMirrorFromGui() {
            this.trapList[1].removeAllElements();
            Object[] objectArray = this.trapListModel.toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.trapList[1].addElement(objectArray[n]);
                ++n;
            }
            this.trapEnabled[1] = SnmpConfig.this.gui.trapEnableCheckBox.isSelected();
            if (Switch.type(SnmpConfig.this.device.switchBoxName) != 0) {
                return;
            }
            this.trapTypes[1][0] = SnmpConfig.this.gui.checkBox1.isSelected();
            this.trapTypes[1][1] = SnmpConfig.this.gui.checkBox2.isSelected();
            this.trapTypes[1][2] = SnmpConfig.this.gui.checkBox3.isSelected();
            this.trapTypes[1][3] = SnmpConfig.this.gui.checkBox4.isSelected();
            this.trapTypes[1][4] = SnmpConfig.this.gui.checkBox5.isSelected();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            SnmpConfig.this.gui.removeTrapsBut.setEnabled(jList.isSelectionEmpty() ^ true);
        }
    }

    protected class CommunityString {
        protected String name;
        protected String access;

        protected CommunityString(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.name = stringTokenizer.nextToken();
            this.access = stringTokenizer.nextToken();
        }

        protected CommunityString(String string, boolean bl) {
            this.name = this.getExtendedString(string);
            this.access = bl ? "RO" : "RW";
        }

        protected boolean accessEquals(CommunityString communityString) {
            return this.access.equals(communityString.access);
        }

        public boolean equals(Object object) {
            CommunityString communityString = (CommunityString)object;
            return this.name.equals(communityString.name);
        }

        protected String getAccess() {
            return this.access;
        }

        protected String getExtendedString(String string) {
            String string2 = !(SnmpConfig.this.applet instanceof ClusterManager) ? string : (SnmpConfig.this.device.memberType.equals("CC") || SnmpConfig.this.device.memberType.equals("AC") ? string : String.valueOf(string) + "@" + SnmpConfig.this.device.esn);
            return string2;
        }

        protected String getName() {
            return this.name;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.access;
        }
    }

    protected class TrapManager {
        protected String ipAddress;
        protected String community;
        protected boolean trapType1;
        protected boolean trapType2;
        protected boolean trapType3;
        protected boolean trapType4;
        protected boolean trapType5;
        protected boolean trapType6;
        protected boolean userAdded;

        protected TrapManager() {
            this.userAdded = true;
            this.ipAddress = SnmpConfig.this.gui.ipAddrField.getText().trim();
            this.community = SnmpConfig.this.gui.communityField.getText().trim();
            if (Switch.type(SnmpConfig.this.device.switchBoxName) == 0) {
                return;
            }
            this.trapType1 = SnmpConfig.this.gui.checkBox1.isSelected();
            this.trapType2 = SnmpConfig.this.gui.checkBox2.isSelected();
            this.trapType3 = SnmpConfig.this.gui.checkBox3.isSelected();
            this.trapType4 = SnmpConfig.this.gui.checkBox4.isSelected();
            this.trapType5 = SnmpConfig.this.gui.checkBox5.isSelected();
            this.trapType6 = SnmpConfig.this.gui.checkBox6.isSelected();
        }

        protected TrapManager(String string) {
            this.userAdded = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.ipAddress = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                this.community = stringTokenizer.nextToken();
            }
        }

        public boolean equals(Object object) {
            TrapManager trapManager = (TrapManager)object;
            boolean bl = this.ipAddress.equals(trapManager.ipAddress);
            boolean bl2 = this.community != null && trapManager.community != null ? this.community.equals(trapManager.community) : true;
            return bl && bl2;
        }

        private void getC1900TrapTypes(Vector vector) {
            if (this.trapType1) {
                vector.addElement("Address-violation");
            }
            if (this.trapType2) {
                vector.addElement("Authentication");
            }
            if (this.trapType3) {
                vector.addElement("BSC");
            }
            if (this.trapType4) {
                vector.addElement("Link-up-down");
            }
            if (this.trapType5) {
                vector.addElement("VTP");
            }
        }

        private void getC3500TrapTypes(Vector vector) {
            if (this.trapType1) {
                vector.addElement("Config");
            }
            if (this.trapType2) {
                vector.addElement("SNMP");
            }
            if (this.trapType3) {
                vector.addElement("TTY");
            }
            if (this.trapType4) {
                vector.addElement("VLAN-membership");
            }
            if (this.trapType5) {
                vector.addElement("VTP");
            }
            if (this.trapType6) {
                vector.addElement("c2900");
            }
        }

        protected String getCommunity() {
            return this.community;
        }

        protected String getIpAddress() {
            return this.ipAddress;
        }

        protected String[] getTrapTypes() {
            Vector vector = new Vector(7);
            if (Switch.type(SnmpConfig.this.device.switchBoxName) == 0) {
                this.getC1900TrapTypes(vector);
            } else {
                this.getC3500TrapTypes(vector);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        protected boolean isUserAdded() {
            return this.userAdded;
        }

        protected void setUserAdded(boolean bl) {
            this.userAdded = bl;
        }

        public String toString() {
            String string = this.ipAddress;
            if (this.community != null) {
                string = String.valueOf(string) + " " + this.community;
            }
            return string;
        }
    }
}

