/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class LegendDialog
extends JFrame
implements ActionListener,
WindowListener {
    static LegendDialog dialog = null;
    Container cp = this.getContentPane();
    JTabbedPane tab = new JTabbedPane();
    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    JButton ok = new JButton("OK");

    private LegendDialog() {
        this.setDefaultCloseOperation(2);
        this.setTitle("ClusterBuilder/ClusterView Legend");
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        EtchedBorder etchedBorder = new EtchedBorder();
        this.cp.setLayout(new BorderLayout());
        this.cp.add((Component)this.tab, "Center");
        this.c.anchor = 17;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.ipady = 4;
        this.c.ipadx = 4;
        this.cp.add((Component)this.createTitle(), "North");
        this.tab.addTab("Devices", this.createDevicePanel());
        this.tab.addTab("Labels", this.createLabelsPanel());
        this.tab.addTab("Links", this.createLinksPanel());
        this.ok.addActionListener(this);
        this.cp.add((Component)this.ok, "South");
        this.addWindowListener(this);
        ((Component)this).setLocation(new Point(50, 50));
        ((Component)this).setVisible(true);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        dialog = null;
        this.dispose();
    }

    private void addLabel(JPanel jPanel, String string, Integer n, boolean bl) {
        ClusterLabel clusterLabel = new ClusterLabel(string, n);
        this.c.gridwidth = bl ? 0 : 1;
        this.c.gridheight = 1;
        this.c.anchor = 17;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.layout.setConstraints(clusterLabel, this.c);
        jPanel.add(clusterLabel);
    }

    private JPanel addLegendTitle(String string) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(" ");
        this.c.gridwidth = 0;
        this.c.gridheight = 1;
        this.layout.setConstraints(jLabel, this.c);
        this.cp.add(jLabel);
        jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 8));
        this.c.gridwidth = 0;
        this.c.gridheight = 2;
        this.layout.setConstraints(jLabel, this.c);
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel createDevicePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(this.layout);
        this.addLabel(jPanel, "Switch UP", ImageFactory.SWITCH_UP, false);
        this.addLabel(jPanel, "Switch FAULT", ImageFactory.SWITCH_FAULT, false);
        this.addLabel(jPanel, "Switch DOWN", ImageFactory.SWITCH_DOWN, true);
        this.addLabel(jPanel, "Commander UP", ImageFactory.COMMANDER_UP, false);
        this.addLabel(jPanel, "Commander FAULT", ImageFactory.COMMANDER_FAULT, true);
        this.addLabel(jPanel, "LRE Member UP", ImageFactory.KONA_SWITCH_UP, false);
        this.addLabel(jPanel, "LRE Member FAULT", ImageFactory.KONA_SWITCH_FAULT, false);
        this.addLabel(jPanel, "LRE Member DOWN", ImageFactory.KONA_SWITCH_DOWN, true);
        this.addLabel(jPanel, "LRE Commander UP", ImageFactory.KONA_COMMANDER_UP, false);
        this.addLabel(jPanel, "LRE Commander FAULT", ImageFactory.KONA_COMMANDER_FAULT, true);
        this.addLabel(jPanel, "Cluster UP", ImageFactory.CLUSTER, false);
        this.addLabel(jPanel, "Unknown", ImageFactory.UNKNOWN_NODE, true);
        return jPanel;
    }

    private JPanel createLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(this.layout);
        this.addLabel(jPanel, "Member", ImageFactory.MEMBER_LABEL, false);
        this.addLabel(jPanel, "Candidate", ImageFactory.CANDIDATE_LABEL, false);
        this.addLabel(jPanel, "Edge Device", ImageFactory.DISQUALIFIED_LABEL, true);
        this.addLabel(jPanel, "Standby Cmdr", ImageFactory.STANDBY_LABEL, true);
        return jPanel;
    }

    private JPanel createLinksPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(this.layout);
        this.addLabel(jPanel, "Member", ImageFactory.MEMBER_LINK, false);
        this.addLabel(jPanel, "Fast (>100MB)", ImageFactory.FAST_LINK, false);
        this.addLabel(jPanel, "Candidate", ImageFactory.CANDIDAE_LINK, true);
        this.addLabel(jPanel, "Blocked", ImageFactory.BLOCKED_LINK, false);
        this.addLabel(jPanel, "Blocked Fast", ImageFactory.BLOCKED_FAST_LINK, true);
        this.addLabel(jPanel, "Multiple Link", ImageFactory.MULTI_LINK, false);
        this.addLabel(jPanel, "GigaStack GBIC", ImageFactory.GBIC, true);
        JLabel jLabel = new JLabel("Note: Except for \"Candidate\" above, this legend applies for links between members only.");
        this.c.gridwidth = 0;
        this.c.gridheight = 1;
        this.c.anchor = 17;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.layout.setConstraints(jLabel, this.c);
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel createTitle() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel("ClusterBuilder/View Legend");
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 10));
        this.c.gridwidth = 0;
        this.c.gridheight = 2;
        this.layout.setConstraints(jLabel, this.c);
        jPanel.add(jLabel);
        return jPanel;
    }

    public static synchronized LegendDialog launchDialog() {
        if (dialog == null) {
            dialog = new LegendDialog();
            ((Component)dialog).setVisible(true);
        } else {
            dialog.toFront();
        }
        return dialog;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        dialog = null;
    }

    public void windowClosing(WindowEvent windowEvent) {
        dialog = null;
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    class ClusterLabel
    extends JLabel {
        public ClusterLabel(String string, Integer n) {
            this.setText(string);
            this.setFont(new Font("Dialog", 1, 10));
            this.setIcon(ImageFactory.getEntry(n).getIcon());
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(2);
        }
    }
}

