/*
 * Decompiled with CFR 0.152.
 */
import custom.CiscoChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class Graph
extends JDialog
implements ItemListener {
    protected JApplet theApplet;
    protected CommonSwitch[] switches;
    protected CommonSwitch theSwitch;
    protected int switchIndex;
    protected String initialPortName;
    protected CiscoChartPanel chartBean = new CiscoChartPanel();
    protected String[] chartTypeStrings = new String[]{"Line", "Bar", "Area"};
    protected JComboBox chartSelectionCombo;
    protected JPanel topPanel;
    protected JPanel mainPanel;
    protected GraphMapper mapper;
    protected JCheckBox logScalingCheckBox;
    protected JRadioButton zoomInButton;
    protected JRadioButton zoomNormalButton;
    protected int pollingInterval = 2000;
    protected int viewPoints = 40;
    protected int bufferPoints = 1000;

    public Graph(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(jApplet, commonSwitchArray, commonSwitch, null);
    }

    public Graph(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch, String string) {
        super((Frame)null);
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        this.initialPortName = string;
        if (commonSwitchArray != null) {
            int n;
            if (commonSwitch == null) {
                commonSwitch = commonSwitchArray[0];
                n = 0;
                while (n < commonSwitchArray.length) {
                    if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                        commonSwitch = commonSwitchArray[n];
                        break;
                    }
                    ++n;
                }
            }
            this.switchIndex = 0;
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n] == commonSwitch) {
                    this.switchIndex = n;
                    break;
                }
                ++n;
            }
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.layoutTopPanel();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.dispose();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Help");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.helpClicked();
            }
        });
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.chartBean.setPreferredSize(new Dimension(650, 275));
        this.chartBean.setMaxDataPoints(this.bufferPoints);
        this.chartBean.setMaxUnscrolledPoints(this.viewPoints);
        this.chartBean.getChart().getYAxis().setTitleRotated(true);
        this.chartBean.setZoomable(false);
        this.chartBean.clearAllDatasets();
        this.chartBean.setChartType(0);
        jPanel2.add((Component)this.chartBean, "Center");
        jPanel2.add((Component)this.chartBean.getScrollBar(), "South");
        this.startGraphMapper();
        this.mainPanel.add((Component)this.topPanel, "North");
        this.mainPanel.add((Component)jPanel2, "Center");
        this.mainPanel.add((Component)jPanel, "South");
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
                Graph.this.mapper.interrupt();
            }

            public void windowClosing(WindowEvent windowEvent) {
                Graph.this.mapper.interrupt();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    public void getPollingInterval() {
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(this.theSwitch.Cli.getClusterUserSetting(), ",\n");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer.hasMoreTokens()) break block3;
            try {
                this.pollingInterval = Integer.parseInt(stringTokenizer.nextToken().trim()) * 1000;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public abstract void helpClicked();

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.zoomInButton || object == this.zoomNormalButton) {
            boolean bl = this.zoomInButton.isSelected();
            if (!bl) {
                this.chartBean.unZoom();
            }
            this.chartBean.setZoomable(bl);
            this.mapper.setZoomable(bl);
        } else if (object == this.logScalingCheckBox) {
            boolean bl = this.logScalingCheckBox.isSelected();
            this.chartBean.setLogScaling(bl);
        }
    }

    public void layoutTopPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.topPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.populateOptionPanel(jPanel);
        this.populateChartTypePanel(jPanel);
        this.topPanel.add((Component)jPanel, "West");
    }

    public void populateChartTypePanel(JPanel jPanel) {
        this.chartSelectionCombo = new JComboBox();
        int n = 0;
        while (n < this.chartTypeStrings.length) {
            this.chartSelectionCombo.addItem(this.chartTypeStrings[n]);
            ++n;
        }
        this.chartSelectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)Graph.this.chartSelectionCombo.getSelectedItem();
                if (string.equals("Line")) {
                    Graph.this.chartBean.setChartType(0);
                } else if (string.equals("Bar")) {
                    Graph.this.chartBean.setChartType(1);
                } else if (string.equals("StackBar")) {
                    Graph.this.chartBean.setChartType(2);
                } else if (string.equals("Area")) {
                    Graph.this.chartBean.setChartType(3);
                } else if (string.equals("StackArea")) {
                    Graph.this.chartBean.setChartType(4);
                }
            }
        });
        jPanel.add(new JLabel("Graph Type:"));
        jPanel.add(this.chartSelectionCombo);
    }

    public void populateDataTypePanel(JPanel jPanel, JComboBox jComboBox, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            jComboBox.addItem(stringArray[n]);
            ++n;
        }
        jPanel.add(new JLabel("Data Type:"));
        jPanel.add(jComboBox);
    }

    public void populateDeviceSelectionPanel(JPanel jPanel, JComboBox jComboBox) {
        int n = 0;
        while (n < this.switches.length) {
            if (!(this.switches[n] instanceof c1900Switch) && !(this.switches[n] instanceof c2820Switch)) {
                jComboBox.addItem(this.switches[n].switchName);
            }
            ++n;
        }
        jComboBox.setSelectedItem(this.switches[this.switchIndex].switchName);
        jComboBox.addItemListener(this);
        jPanel.add(new JLabel("Device:"));
        jPanel.add(jComboBox);
    }

    public void populateOptionPanel(JPanel jPanel) {
        this.logScalingCheckBox = new JCheckBox("Logarithmic Scaling", false);
        this.logScalingCheckBox.addItemListener(this);
        jPanel.add(this.logScalingCheckBox);
        this.zoomInButton = new JRadioButton("Zoomable", false);
        this.zoomInButton.addItemListener(this);
        this.zoomNormalButton = new JRadioButton("Default View", true);
        this.zoomNormalButton.addItemListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.zoomInButton);
        buttonGroup.add(this.zoomNormalButton);
        jPanel.add(this.zoomInButton);
        jPanel.add(this.zoomNormalButton);
    }

    public void populatePortSelectionPanel(String string, JComboBox jComboBox) {
        jComboBox.removeAllItems();
        String[] stringArray = this.theSwitch.Cli.getPortName(this.theSwitch.esn);
        String[] stringArray2 = this.theSwitch.Cli.getAllPortStatusActual(this.theSwitch.esn);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray2[n].equals("UP")) {
                jComboBox.addItem(stringArray[n]);
                if (string != null && stringArray[n].equalsIgnoreCase(string)) {
                    jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
                }
            }
            ++n;
        }
    }

    public abstract void startGraphMapper();

    public void startGraphMapper(int n, String string) {
        this.getPollingInterval();
        this.mapper = new GraphMapper(this.theSwitch, string, this.chartBean, n, this.pollingInterval, this.viewPoints);
        this.mapper.start();
    }
}

